/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.net;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.impl.net.SSLConfigurationMethod;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorAbstractUI;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class SSLConfiguratorTrustStoreUI
extends SSLConfiguratorAbstractUI {
    private Button certRadioButton;
    private Button keyStoreRadioButton;
    protected TextWithOpen caCertPath;
    protected TextWithOpen clientCertPath;
    protected TextWithOpen clientKeyPath;
    protected TextWithOpen keyStorePath;
    protected Text keyStorePassword;
    protected SSLConfigurationMethod method;
    protected Composite sslCertComposite;
    protected Composite sslKeyStoreComposite;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createTrustStoreConfigGroup(composite);
    }

    protected Group createTrustStoreConfigGroup(Composite composite) {
        boolean certificatesSupported = this.isCertificatesSupported();
        boolean keyStoreSupported = this.isKeystoreSupported();
        assert (certificatesSupported || keyStoreSupported);
        Group sslParameters = UIUtils.createControlGroup((Composite)composite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_legend_parameters, (int)1, (int)768, (int)-1);
        if (certificatesSupported && keyStoreSupported) {
            SelectionAdapter methodSwitcher = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SSLConfiguratorTrustStoreUI.this.showMethodControls((SSLConfigurationMethod)e.widget.getData());
                }
            };
            Composite sslMethodComposite = UIUtils.createComposite((Composite)sslParameters, (int)3);
            UIUtils.createControlLabel((Composite)sslMethodComposite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_method);
            this.certRadioButton = UIUtils.createRadioButton((Composite)sslMethodComposite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_method_certs, (Object)SSLConfigurationMethod.CERTIFICATES, (SelectionListener)methodSwitcher);
            this.keyStoreRadioButton = UIUtils.createRadioButton((Composite)sslMethodComposite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_method_keystore, (Object)SSLConfigurationMethod.KEYSTORE, (SelectionListener)methodSwitcher);
        }
        this.sslCertComposite = UIUtils.createComposite((Composite)sslParameters, (int)2);
        this.sslCertComposite.setLayoutData((Object)new GridData(768));
        if (this.useCACertificate()) {
            UIUtils.createControlLabel((Composite)this.sslCertComposite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_certs_ca_name);
            this.caCertPath = new TextWithOpenFile(this.sslCertComposite, UIConnectionMessages.dialog_setting_ssl_configurator_certs_ca_title, new String[]{"*.*", "*.crt", "*"});
            this.caCertPath.setLayoutData((Object)new GridData(768));
        }
        UIUtils.createControlLabel((Composite)this.sslCertComposite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_certs_client_name);
        this.clientCertPath = new TextWithOpenFile(this.sslCertComposite, UIConnectionMessages.dialog_setting_ssl_configurator_certs_client_title, new String[]{"*.*", "*.crt", "*"});
        this.clientCertPath.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)this.sslCertComposite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_certs_client_key_name);
        this.clientKeyPath = new TextWithOpenFile(this.sslCertComposite, UIConnectionMessages.dialog_setting_ssl_configurator_certs_client_key_title, new String[]{"*.*", "*.key", "*"});
        this.clientKeyPath.setLayoutData((Object)new GridData(768));
        this.sslKeyStoreComposite = UIUtils.createComposite((Composite)sslParameters, (int)2);
        this.sslKeyStoreComposite.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)this.sslKeyStoreComposite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_keystore_name);
        this.keyStorePath = new TextWithOpenFile(this.sslKeyStoreComposite, UIConnectionMessages.dialog_setting_ssl_configurator_keystore_title, new String[]{"*.jks;*.pfx", "*.*"});
        this.keyStorePath.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)this.sslKeyStoreComposite, (String)UIConnectionMessages.dialog_setting_ssl_configurator_keystore_password_name);
        this.keyStorePassword = new Text(this.sslKeyStoreComposite, 0x400800);
        this.keyStorePassword.setLayoutData((Object)new GridData(768));
        return sslParameters;
    }

    private void showMethodControls(SSLConfigurationMethod configurationMethod) {
        boolean keystore = configurationMethod == SSLConfigurationMethod.KEYSTORE;
        this.showControl((Control)this.sslCertComposite, !keystore);
        this.showControl((Control)this.sslKeyStoreComposite, keystore);
        this.sslCertComposite.getParent().getParent().layout(true, true);
        this.method = configurationMethod;
    }

    private void showControl(Control control, boolean flag) {
        control.setVisible(flag);
        ((GridData)control.getLayoutData()).exclude = !flag;
    }

    protected boolean isCertificatesSupported() {
        return true;
    }

    protected boolean isKeystoreSupported() {
        return false;
    }

    protected boolean useCACertificate() {
        return false;
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        SSLConfigurationMethod method;
        if (this.isCertificatesSupported()) {
            if (this.caCertPath != null) {
                this.caCertPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.ca.cert")));
            }
            this.clientCertPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.client.cert")));
            this.clientKeyPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.client.key")));
        }
        if (this.isKeystoreSupported()) {
            this.keyStorePath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.keystore")));
            this.keyStorePassword.setText(CommonUtils.notEmpty((String)configuration.getPassword()));
        }
        if (this.isCertificatesSupported() && this.isKeystoreSupported()) {
            method = (SSLConfigurationMethod)CommonUtils.valueOf(SSLConfigurationMethod.class, (String)configuration.getStringProperty("ssl.method"), (Enum)SSLConfigurationMethod.CERTIFICATES);
            if (method == SSLConfigurationMethod.CERTIFICATES) {
                this.certRadioButton.setSelection(true);
            } else {
                this.keyStoreRadioButton.setSelection(true);
            }
        } else {
            method = this.isCertificatesSupported() ? SSLConfigurationMethod.CERTIFICATES : SSLConfigurationMethod.KEYSTORE;
        }
        this.showMethodControls(method);
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        if (this.isCertificatesSupported()) {
            if (this.caCertPath != null) {
                configuration.setProperty("ssl.ca.cert", (Object)this.caCertPath.getText().trim());
            }
            configuration.setProperty("ssl.client.cert", (Object)this.clientCertPath.getText().trim());
            configuration.setProperty("ssl.client.key", (Object)this.clientKeyPath.getText().trim());
        }
        if (this.isKeystoreSupported()) {
            configuration.setProperty("ssl.keystore", (Object)this.keyStorePath.getText().trim());
            String password = this.keyStorePassword.getText().trim();
            if (!CommonUtils.isEmptyTrimmed((String)password)) {
                configuration.setPassword(password);
                configuration.setSavePassword(true);
            }
        }
        configuration.setProperty("ssl.method", (Object)this.method.name());
    }
}

