/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.plan;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.plan.ExasolPlanNode;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class ExasolPlanAnalyser
extends AbstractExecutionPlan {
    private static final Log LOG = Log.getLog(ExasolPlanAnalyser.class);
    private ExasolDataSource dataSource;
    private String query;
    private List<ExasolPlanNode> rootNodes;

    public ExasolPlanAnalyser(ExasolDataSource dataSource, String query) {
        this.dataSource = dataSource;
        this.query = query;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "/*snapshot execution*/ SELECT * FROM EXA_USER_PROFILE_LAST_DAY WHERE SESSION_ID = CURRENT_SESSION AND STMT_ID = (select max(stmt_id) from EXA_USER_PROFILE_LAST_DAY where sql_text = ?)";
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    public void explain(DBCSession session) throws DBCException {
        this.rootNodes = new ArrayList<ExasolPlanNode>();
        JDBCSession connection = (JDBCSession)session;
        boolean oldAutoCommit = false;
        try {
            try {
                oldAutoCommit = connection.getAutoCommit();
                if (oldAutoCommit) {
                    connection.setAutoCommit(false);
                }
                JDBCUtils.executeSQL((Connection)connection, (String)"ALTER SESSION SET PROFILE = 'ON'", (Object[])new Object[0]);
                JDBCUtils.executeSQL((Connection)connection, (String)this.query, (Object[])new Object[0]);
                JDBCUtils.executeSQL((Connection)connection, (String)"ALTER SESSION SET PROFILE = 'OFF'", (Object[])new Object[0]);
                connection.rollback();
                JDBCUtils.executeSQL((Connection)connection, (String)"FLUSH STATISTICS", (Object[])new Object[0]);
                connection.commit();
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCPreparedStatement stmt = connection.prepareStatement(this.getPlanQueryString());){
                    stmt.setString(1, this.query);
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCResultSet dbResult = stmt.executeQuery();){
                        while (dbResult.next()) {
                            ExasolPlanNode node = new ExasolPlanNode(null, (ResultSet)dbResult);
                            this.rootNodes.add(node);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, session.getExecutionContext());
            }
        }
        finally {
            try {
                connection.rollback();
                if (oldAutoCommit) {
                    connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                LOG.error((Object)"Error closing plan analyser", (Throwable)e);
            }
        }
    }

    public ExasolDataSource getDataSource() {
        return this.dataSource;
    }
}

