/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListViewer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardMapQuery;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardQuery;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewContainer;
import org.jkiss.dbeaver.ui.dashboard.model.data.DashboardDataset;
import org.jkiss.dbeaver.ui.dashboard.model.data.DashboardDatasetRow;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DashboardUpdater {
    private static final Log log = Log.getLog(DashboardUpdater.class);
    private Map<DBPDataSourceContainer, List<MapQueryInfo>> mapQueries = new HashMap<DBPDataSourceContainer, List<MapQueryInfo>>();

    public void updateDashboards(DBRProgressMonitor monitor) {
        List<DashboardContainer> dashboards = this.getDashboardsToUpdate();
        this.updateDashboards(monitor, dashboards);
    }

    private void updateDashboards(DBRProgressMonitor monitor, List<DashboardContainer> dashboards) {
        monitor.beginTask("Update dashboards", dashboards.size());
        for (DashboardContainer dashboardContainer : dashboards) {
            DashboardMapQuery mapQuery = dashboardContainer.getMapQuery();
            if (mapQuery == null) continue;
            List queryList = this.mapQueries.computeIfAbsent(dashboardContainer.getDataSourceContainer(), k -> new ArrayList());
            boolean found = false;
            for (MapQueryInfo mqi : queryList) {
                if (mqi.mapQuery != mapQuery) continue;
                found = true;
                break;
            }
            if (found) continue;
            queryList.add(new MapQueryInfo(dashboardContainer.getGroup().getView(), mapQuery));
        }
        for (Map.Entry entry : this.mapQueries.entrySet()) {
            monitor.subTask("Read dashboard data");
            DBPDataSourceContainer dsContainer = (DBPDataSourceContainer)entry.getKey();
            DBPDataSource dataSource = dsContainer.getDataSource();
            if (dataSource == null) continue;
            try {
                DBExecUtils.tryExecuteRecover(dashboards, (DBPDataSource)dataSource, param -> {
                    try {
                        for (MapQueryInfo mqi : (List)mqEntry.getValue()) {
                            this.readMapQueryData(monitor, mqi);
                        }
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (DBException e) {
                log.debug((Object)("Error reading map query data for '" + dsContainer.getName() + "'"), (Throwable)e);
            }
        }
        for (DashboardContainer dashboardContainer : dashboards) {
            DBPDataSource dataSource = dashboardContainer.getDataSourceContainer().getDataSource();
            if (dataSource == null) continue;
            try {
                DBExecUtils.tryExecuteRecover(dashboards, (DBPDataSource)dataSource, param -> {
                    try {
                        this.updateDashboard(monitor, dashboard);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (DBException e) {
                log.debug((Object)("Error reading dashboard '" + dashboardContainer.getDashboardId() + "' data: " + GeneralUtils.getRootCause((Throwable)e).getMessage()));
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private void readMapQueryData(DBRProgressMonitor monitor, MapQueryInfo mqInfo) throws DBCException {
        block31: {
            DBCExecutionContext executionContext = mqInfo.viewContainer.getExecutionContext();
            if (executionContext == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Read map query '" + mqInfo.mapQuery.getId() + "' data");){
                    session.enableLogging(false);
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, mqInfo.mapQuery.getQueryText(), false, false, false);){
                        if (!dbStat.executeStatement()) break block31;
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (DBCResultSet dbResults = dbStat.openResultSet();){
                            mqInfo.timestamp = new Date();
                            while (dbResults.nextRow()) {
                                String mapKey = CommonUtils.toString((Object)dbResults.getAttributeValue(0));
                                Object mapValue = dbResults.getAttributeValue(1);
                                mqInfo.mapValue.put(mapKey, mapValue);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new DBCException("Error reading map query data", (Throwable)e);
            }
        }
    }

    private void updateDashboard(DBRProgressMonitor monitor, DashboardContainer dashboard) throws DBCException {
        if (!dashboard.getDataSourceContainer().isConnected() || DBWorkbench.getPlatform().isShuttingDown()) {
            return;
        }
        if (dashboard.getMapQuery() != null) {
            this.fetchDashboardMapData(monitor, dashboard);
            return;
        }
        List<? extends DashboardQuery> queries = dashboard.getQueryList();
        if (queries.isEmpty()) {
            return;
        }
        DashboardViewContainer view = dashboard.getGroup().getView();
        DBCExecutionContext executionContext = view.getExecutionContext();
        if (executionContext == null) {
            return;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Read dashboard '" + dashboard.getDashboardTitle() + "' data");){
            session.enableLogging(false);
            for (DashboardQuery dashboardQuery : queries) {
                try {
                    Throwable throwable2 = null;
                    Object var12_16 = null;
                    try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, dashboardQuery.getQueryText(), false, false, false);){
                        if (!dbStat.executeStatement()) continue;
                        Throwable throwable3 = null;
                        Object var15_21 = null;
                        try (DBCResultSet dbResults = dbStat.openResultSet();){
                            this.fetchDashboardData(dashboard, dbResults);
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    throw new DBCException("Error updating dashboard " + dashboard.getDashboardId(), (Throwable)e, session.getExecutionContext());
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private void fetchDashboardMapData(DBRProgressMonitor monitor, final DashboardContainer dashboard) {
        MapQueryInfo mqi = this.getMapQueryData(dashboard);
        if (mqi == null) {
            return;
        }
        Map mapValue = mqi.mapValue;
        if (mapValue != null) {
            Object[] mapKeys = dashboard.getMapKeys();
            Object[] mapLabels = dashboard.getMapLabels();
            if (!ArrayUtils.isEmpty((Object[])mapKeys)) {
                if (ArrayUtils.isEmpty((Object[])mapLabels)) {
                    mapLabels = mapKeys;
                }
                DashboardDataset dataset = new DashboardDataset((String[])mapLabels);
                Object[] mapValues = new Object[mapKeys.length];
                int i = 0;
                while (i < mapKeys.length) {
                    Object value = mapValue.get(mapKeys[i]);
                    Number numValue = value instanceof Number ? (Number)((Number)value) : (Number)CommonUtils.toDouble(value);
                    mapValues[i] = numValue;
                    ++i;
                }
                Date timestamp = mqi.timestamp;
                if (timestamp == null) {
                    timestamp = new Date();
                }
                dataset.addRow(new DashboardDatasetRow(timestamp, mapValues));
                dashboard.updateDashboardData(dataset);
            } else if (dashboard.getMapFormula() != null) {
                final HashMap ciMap = new HashMap(mapValue.size());
                for (Map.Entry me : mapValue.entrySet()) {
                    ciMap.put(((String)me.getKey()).toLowerCase(Locale.ENGLISH), me.getValue());
                }
                JexlContext context = new JexlContext(){

                    public Object get(String name) {
                        if (name.equals("map")) {
                            return ciMap;
                        }
                        if (name.equals("dashboard")) {
                            return dashboard;
                        }
                        return null;
                    }

                    public void set(String name, Object value) {
                        log.warn((Object)"Set is not implemented in DBX model");
                    }

                    public boolean has(String name) {
                        return name.equals("object") || name.equals("dashboard");
                    }
                };
                Object result = dashboard.getMapFormula().evaluate(context);
                if (result instanceof Number) {
                    Object columnName = dashboard.getDashboardTitle();
                    if (!ArrayUtils.isEmpty((Object[])mapLabels)) {
                        columnName = mapLabels[0];
                    }
                    DashboardDataset dataset = new DashboardDataset(new String[]{columnName});
                    dataset.addRow(new DashboardDatasetRow(new Date(), new Object[]{result}));
                    dashboard.updateDashboardData(dataset);
                } else {
                    log.debug((Object)("Wrong expression result: " + result));
                }
            }
        }
    }

    private void fetchDashboardData(DashboardContainer dashboard, DBCResultSet dbResults) throws DBCException {
        DBCResultSetMetaData meta = dbResults.getMeta();
        List rsAttrs = meta.getAttributes();
        ArrayList<String> colNames = new ArrayList<String>();
        String tsColName = null;
        for (DBCAttributeMetaData rsAttr : rsAttrs) {
            String colName = rsAttr.getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = rsAttr.getName();
            }
            if ("STAT_TIMESTAMP".equalsIgnoreCase(colName)) {
                tsColName = colName;
                continue;
            }
            colNames.add(colName);
        }
        DashboardDataset dataset = new DashboardDataset(colNames.toArray(new String[0]));
        while (dbResults.nextRow()) {
            Object[] values = new Object[colNames.size()];
            Date timestamp = tsColName != null ? (Date)dbResults.getAttributeValue(tsColName) : new Date();
            int i = 0;
            while (i < colNames.size()) {
                values[i] = dbResults.getAttributeValue((String)colNames.get(i));
                ++i;
            }
            dataset.addRow(new DashboardDatasetRow(timestamp, values));
            if (dataset.getRows().size() >= dashboard.getDashboardMaxItems()) break;
        }
        switch (dashboard.getDashboardFetchType()) {
            case rows: {
                dataset = this.transposeDataset(dataset);
            }
        }
        dashboard.updateDashboardData(dataset);
    }

    private DashboardDataset transposeDataset(DashboardDataset dataset) {
        int oldColumnCount = dataset.getColumnNames().length;
        if (oldColumnCount < 2) {
            return dataset;
        }
        ArrayList<String> colNamesFromRows = new ArrayList<String>();
        List<DashboardDatasetRow> oldRows = dataset.getRows();
        Date oldTimestamp = oldRows.get(0).getTimestamp();
        DashboardDatasetRow[] newRows = new DashboardDatasetRow[oldColumnCount - 1];
        int i = 0;
        while (i < oldRows.size()) {
            DashboardDatasetRow oldRow = oldRows.get(i);
            colNamesFromRows.add(CommonUtils.toString((Object)oldRow.getValues()[0], (String)String.valueOf(i + 1)));
            int colIndex = 1;
            while (colIndex < oldColumnCount) {
                DashboardDatasetRow newRow = newRows[colIndex - 1];
                if (newRow == null) {
                    newRows[colIndex - 1] = newRow = new DashboardDatasetRow(oldTimestamp, new Object[oldRows.size()]);
                }
                newRow.getValues()[i] = oldRow.getValues()[colIndex];
                ++colIndex;
            }
            ++i;
        }
        DashboardDataset newDataset = new DashboardDataset(colNamesFromRows.toArray(new String[0]));
        DashboardDatasetRow[] dashboardDatasetRowArray = newRows;
        int n = newRows.length;
        int n2 = 0;
        while (n2 < n) {
            DashboardDatasetRow newRow = dashboardDatasetRowArray[n2];
            newDataset.addRow(newRow);
            ++n2;
        }
        return newDataset;
    }

    public List<DashboardContainer> getDashboardsToUpdate() {
        ArrayList<DashboardContainer> dashboards = new ArrayList<DashboardContainer>();
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IViewReference[] iViewReferenceArray = page.getViewReferences();
                int n5 = iViewReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IWorkbenchPart part;
                    IViewReference view = iViewReferenceArray[n6];
                    if (view.getId().equalsIgnoreCase("org.jkiss.dbeaver.ui.dashboardView") && (part = view.getPart(false)) instanceof DashboardView) {
                        this.getViewDashboards((DashboardView)part, dashboards);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return dashboards;
    }

    private void getViewDashboards(DashboardView view, List<DashboardContainer> dashboards) {
        long currentTime = System.currentTimeMillis();
        DashboardListViewer viewManager = view.getDashboardListViewer();
        if (viewManager == null || !viewManager.getDataSourceContainer().isConnected()) {
            return;
        }
        for (DashboardGroupContainer dashboardGroupContainer : viewManager.getGroups()) {
            for (DashboardContainer dashboardContainer : dashboardGroupContainer.getItems()) {
                Date lastUpdateTime = dashboardContainer.getLastUpdateTime();
                if (lastUpdateTime != null && currentTime - lastUpdateTime.getTime() < dashboardContainer.getUpdatePeriod()) continue;
                dashboards.add(dashboardContainer);
            }
        }
    }

    private MapQueryInfo getMapQueryData(DashboardContainer dashboard) {
        List<MapQueryInfo> mapQueryInfos = this.mapQueries.get(dashboard.getDataSourceContainer());
        if (mapQueryInfos != null) {
            for (MapQueryInfo mqi : mapQueryInfos) {
                if (mqi.mapQuery != dashboard.getMapQuery()) continue;
                return mqi;
            }
        }
        return null;
    }

    private static class MapQueryInfo {
        private final DashboardViewContainer viewContainer;
        private final DashboardMapQuery mapQuery;
        public Date timestamp;
        private Map<String, Object> mapValue = new HashMap<String, Object>();

        public MapQueryInfo(DashboardViewContainer viewContainer, DashboardMapQuery mapQuery) {
            this.viewContainer = viewContainer;
            this.mapQuery = mapQuery;
        }
    }
}

