/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleMember;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRolePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreRole
implements PostgreObject,
PostgrePrivilegeOwner,
DBPPersistedObject,
DBPSaveableObject,
DBPRefreshableObject,
DBPNamedObject2,
DBARole,
DBAUser {
    public static final String CAT_SETTINGS = "Settings";
    public static final String CAT_FLAGS = "Flags";
    private static final Log log = Log.getLog(PostgreRole.class);
    private final PostgreDatabase database;
    private long oid;
    private String name;
    private boolean superUser;
    private boolean inherit;
    private boolean createRole;
    private boolean createDatabase;
    private boolean canLogin;
    private boolean replication;
    private boolean bypassRls;
    private int connLimit;
    private String password;
    private Date validUntil;
    private boolean persisted;
    private MembersCache membersCache = new MembersCache(true);
    private MembersCache belongsCache = new MembersCache(false);

    public PostgreRole(PostgreDatabase database, String name, String password, boolean isUser) {
        this.database = database;
        this.name = name;
        this.password = password;
        this.canLogin = isUser;
        this.persisted = false;
    }

    public PostgreRole(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        this.database = database;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) {
        this.persisted = true;
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rolname");
        this.superUser = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolsuper");
        this.inherit = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolinherit");
        this.createRole = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcreaterole");
        this.createDatabase = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcreatedb");
        this.canLogin = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcanlogin");
        this.replication = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolreplication");
        this.bypassRls = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolbypassrls");
        this.connLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"rolconnlimit");
        this.password = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rolpassword");
        this.validUntil = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"rolvaliduntil");
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.database;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    public boolean isUser() {
        return this.canLogin;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, editable=true, updatable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=2)
    public long getObjectId() {
        return this.oid;
    }

    @Property(editable=true, updatable=true, order=10, visibleIf=PostgreRoleCanBeSuperUserValidator.class)
    public boolean isSuperUser() {
        return this.superUser;
    }

    public void setSuperUser(boolean superUser) {
        this.superUser = superUser;
    }

    @Property(editable=true, updatable=true, order=11, visibleIf=PostgreRoleInheritValidator.class)
    public boolean isInherit() {
        return this.inherit;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    @Property(editable=true, updatable=true, order=12)
    public boolean isCreateRole() {
        return this.createRole;
    }

    public void setCreateRole(boolean createRole) {
        this.createRole = createRole;
    }

    @Property(editable=true, updatable=true, order=13, visibleIf=PostgreRoleCanCreateDBValidator.class)
    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    public void setCreateDatabase(boolean createDatabase) {
        this.createDatabase = createDatabase;
    }

    @Property(editable=true, updatable=true, order=14)
    public boolean isCanLogin() {
        return this.canLogin;
    }

    public void setCanLogin(boolean canLogin) {
        this.canLogin = canLogin;
    }

    @Property(editable=true, updatable=true, order=15)
    public boolean isReplication() {
        return this.replication;
    }

    public void setReplication(boolean replication) {
        this.replication = replication;
    }

    @Property(editable=true, updatable=true, order=16)
    public boolean isBypassRls() {
        return this.bypassRls;
    }

    public void setBypassRls(boolean bypassRls) {
        this.bypassRls = bypassRls;
    }

    @Property(category="Settings", editable=true, updatable=true, order=20)
    public int getConnLimit() {
        return this.connLimit;
    }

    public void setConnLimit(int connLimit) {
        this.connLimit = connLimit;
    }

    @Property(hidden=true, category="Settings", editable=true, updatable=true, order=21)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Property(category="Settings", editable=true, updatable=true, order=22)
    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    @Association
    public Collection<PostgreRoleMember> getMembers(DBRProgressMonitor monitor) throws DBException {
        return this.membersCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreRoleMember> getBelongs(DBRProgressMonitor monitor) throws DBException {
        return this.belongsCache.getAllObjects(monitor, this);
    }

    @Override
    public PostgreSchema getSchema() {
        return null;
    }

    @Override
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public List<PostgrePrivilege> getPrivileges(DBRProgressMonitor monitor, boolean includeNestedObjects) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read role privileges");){
            JDBCPreparedStatement dbStat;
            Throwable throwable2;
            ArrayList<PostgrePrivilege> permissions = new ArrayList<PostgrePrivilege>();
            try {
                Throwable throwable3 = null;
                throwable2 = null;
                try {
                    dbStat = session.prepareStatement("SELECT * FROM information_schema.table_privileges WHERE table_catalog=? AND grantee=?");
                    try {
                        dbStat.setString(1, this.getDatabase().getName());
                        dbStat.setString(2, this.getName());
                        permissions.addAll(PostgreRole.getRolePermissions(this, PostgrePrivilegeGrant.Kind.TABLE, dbStat));
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error reading table privileges", e);
            }
            try {
                e = null;
                throwable2 = null;
                try {
                    dbStat = session.prepareStatement("SELECT * FROM information_schema.routine_privileges WHERE specific_catalog=? AND grantee=?");
                    try {
                        dbStat.setString(1, this.getDatabase().getName());
                        dbStat.setString(2, this.getName());
                        permissions.addAll(PostgreRole.getRolePermissions(this, PostgrePrivilegeGrant.Kind.FUNCTION, dbStat));
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (e == null) {
                        e = throwable5;
                    } else if (e != throwable5) {
                        e.addSuppressed(throwable5);
                    }
                    throw e;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error reading routine privileges", e);
            }
            String otherObjectsSQL = "SELECT * FROM (\n\tSELECT DISTINCT relnamespace,\n\trelname,\n\trelkind,\n\trelacl,\n(aclexplode(relacl)).grantee as granteeI\nFROM\n\tpg_class\nWHERE\n\trelacl IS NOT NULL\n\tAND relnamespace IN (\nSELECT oid\nFROM pg_namespace\nWHERE nspname NOT LIKE 'pg_%' AND nspname != 'information_schema')\nUNION ALL\nSELECT DISTINCT\n\tn.oid AS relnamespace,\n\tn.nspname AS relname,\n\t'C' AS relkind,\n\tnspacl AS relacl,\n(aclexplode(nspacl)).grantee as granteeI\nFROM\n\tpg_catalog.pg_namespace n\nWHERE\n\tn.nspacl IS NOT NULL \n\t) AS tr\nWHERE tr.granteeI=? AND tr.relkind IN('S', 'm', 'C')";
            try {
                throwable2 = null;
                Object var9_19 = null;
                try (JDBCPreparedStatement dbStat2 = session.prepareStatement(otherObjectsSQL);){
                    dbStat2.setLong(1, this.getObjectId());
                    Throwable throwable6 = null;
                    Object var12_24 = null;
                    try (JDBCResultSet dbResult = dbStat2.executeQuery();){
                        while (dbResult.nextRow()) {
                            List<PostgrePrivilege> privileges;
                            long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (int)1);
                            String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname");
                            String objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind");
                            Object acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (int)4);
                            PostgreSchema schema = this.getDatabase().getSchema(monitor, schemaId);
                            if (schema == null || objectName == null || objectType == null) continue;
                            PostgrePrivilegeGrant.Kind pKind = PostgrePrivilegeGrant.Kind.TABLE;
                            if (objectType.equals("C")) {
                                privileges = PostgreUtils.extractPermissionsFromACL(monitor, schema, acl);
                                pKind = PostgrePrivilegeGrant.Kind.SCHEMA;
                            } else if (objectType.equals("S")) {
                                PostgreSequence sequence = schema.getSequence(monitor, objectName);
                                privileges = PostgreUtils.extractPermissionsFromACL(monitor, sequence, acl);
                                pKind = PostgrePrivilegeGrant.Kind.SEQUENCE;
                            } else {
                                PostgreMaterializedView materializedView = schema.getMaterializedView(monitor, objectName);
                                privileges = PostgreUtils.extractPermissionsFromACL(monitor, materializedView, acl);
                            }
                            for (PostgrePrivilege p : privileges) {
                                if (!(p instanceof PostgreObjectPrivilege) || !this.getName().equals(((PostgreObjectPrivilege)p).getGrantee())) continue;
                                ArrayList<PostgrePrivilegeGrant> grants = new ArrayList<PostgrePrivilegeGrant>();
                                PostgrePrivilege.ObjectPermission[] objectPermissionArray = p.getPermissions();
                                int n = objectPermissionArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    PostgrePrivilege.ObjectPermission perm = objectPermissionArray[n2];
                                    grants.add(new PostgrePrivilegeGrant(perm.getGrantor(), this.getName(), this.getDatabase().getName(), schema.getName(), objectName, perm.getPrivilegeType(), false, false));
                                    ++n2;
                                }
                                permissions.add(new PostgreRolePrivilege(this, pKind, schema.getName(), objectName, grants));
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable6 == null) {
                            throwable6 = throwable7;
                        } else if (throwable6 != throwable7) {
                            throwable6.addSuppressed(throwable7);
                        }
                        throw throwable6;
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable2 == null) {
                        throwable2 = throwable8;
                    } else if (throwable2 != throwable8) {
                        throwable2.addSuppressed(throwable8);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error reading routine privileges", e);
            }
            Collections.sort(permissions);
            return permissions;
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
            } else if (throwable != throwable9) {
                throwable.addSuppressed(throwable9);
            }
            throw throwable;
        }
    }

    @Override
    public String generateChangeOwnerQuery(String owner) {
        return null;
    }

    private static Collection<PostgrePrivilege> getRolePermissions(PostgreRole role, PostgrePrivilegeGrant.Kind kind, JDBCPreparedStatement dbStat) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCResultSet dbResult = dbStat.executeQuery();){
            LinkedHashMap<String, List> privs = new LinkedHashMap<String, List>();
            while (dbResult.next()) {
                PostgrePrivilegeGrant privilege = new PostgrePrivilegeGrant(kind, (ResultSet)dbResult);
                String tableId = String.valueOf(privilege.getObjectSchema()) + "." + privilege.getObjectName();
                List privList = privs.computeIfAbsent(tableId, k -> new ArrayList());
                privList.add(privilege);
            }
            ArrayList<PostgrePrivilege> result = new ArrayList<PostgrePrivilege>(privs.size());
            for (List priv : privs.values()) {
                result.add(new PostgreRolePrivilege(role, kind, ((PostgrePrivilegeGrant)priv.get(0)).getObjectSchema(), ((PostgrePrivilegeGrant)priv.get(0)).getObjectName(), priv));
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.membersCache.clearCache();
        this.belongsCache.clearCache();
        return this;
    }

    public String toString() {
        return this.getName();
    }

    static class MembersCache
    extends JDBCObjectCache<PostgreRole, PostgreRoleMember> {
        private final boolean members;

        MembersCache(boolean members) {
            this.members = members;
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreRole owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM pg_catalog.pg_auth_members WHERE " + (this.members ? "roleid" : "member") + "=?");
            dbStat.setLong(1, owner.getObjectId());
            return dbStat;
        }

        protected PostgreRoleMember fetchObject(@NotNull JDBCSession session, @NotNull PostgreRole owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreRoleMember(owner, (ResultSet)dbResult);
        }
    }

    public static class PostgreRoleCanBeSuperUserValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(PostgreRole object, Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsSuperusers();
        }
    }

    public static class PostgreRoleCanCreateDBValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(PostgreRole object, Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsRolesWithCreateDBAbility();
        }
    }

    public static class PostgreRoleInheritValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(PostgreRole object, Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsInheritance();
        }
    }
}

