/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mssql.ui.SQLServerUIMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorAbstractUI;
import org.jkiss.utils.CommonUtils;

public class SQLServerSSLConfigurator
extends SSLConfiguratorAbstractUI {
    private TextWithOpen keystoreFile;
    private Text keystorePassword;
    private Text keystoreHostname;
    private Button trustServerCertificate;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createSSLConfigHint(composite, true, 1);
        Group advancedGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLServerUIMessages.dialog_setting_ssl_advanced_title, (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)advancedGroup, (String)SQLServerUIMessages.dialog_setting_ssl_advanced_keystore_label);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.keystoreFile = new TextWithOpenFile((Composite)advancedGroup, SQLServerUIMessages.dialog_setting_ssl_advanced_keystore_title, new String[]{"*.jks;*.pfx"});
        this.keystoreFile.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)advancedGroup, (String)SQLServerUIMessages.dialog_setting_ssl_advanced_keystore_password_label);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.keystorePassword = new Text((Composite)advancedGroup, 0x400800);
        this.keystorePassword.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)advancedGroup, (String)SQLServerUIMessages.dialog_setting_ssl_advanced_hostname_label);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.keystoreHostname = new Text((Composite)advancedGroup, 2048);
        this.keystoreHostname.setLayoutData((Object)new GridData(768));
        this.keystoreHostname.setToolTipText(SQLServerUIMessages.dialog_setting_ssl_advanced_hostname_tip);
        this.trustServerCertificate = UIUtils.createCheckbox((Composite)advancedGroup, (String)SQLServerUIMessages.dialog_setting_trust_server_certificate, (String)SQLServerUIMessages.dialog_setting_trust_server_certificate_tip, (boolean)true, (int)2);
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        this.keystoreFile.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("sslKeyStore")));
        this.keystorePassword.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("sslKeyStorePassword")));
        this.keystoreHostname.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("sslKeyStoreHostname")));
        this.trustServerCertificate.setSelection(configuration.getBooleanProperty("sslTrustServerCertificate"));
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.setProperty("sslKeyStore", (Object)this.keystoreFile.getText().trim());
        configuration.setProperty("sslKeyStorePassword", (Object)this.keystorePassword.getText().trim());
        configuration.setProperty("sslKeyStoreHostname", (Object)this.keystoreHostname.getText().trim());
        configuration.setProperty("sslTrustServerCertificate", (Object)this.trustServerCertificate.getSelection());
    }
}

