/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.Provider;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLSemanticProcessor {
    private static final Log log = Log.getLog(SQLSemanticProcessor.class);
    private static final String NESTED_QUERY_AlIAS = "z_q";

    public static Statement parseQuery(@Nullable SQLDialect dialect, @NotNull String sql) throws DBCException {
        CCJSqlParser parser = new CCJSqlParser((Provider)new StringProvider(sql));
        try {
            if (dialect != null) {
                for (String[] qs : ArrayUtils.safeArray((Object[])dialect.getIdentifierQuoteStrings())) {
                    if (qs.length != 2 || !"[".equals(qs[0]) || !"]".equals(qs[1])) continue;
                    parser.withSquareBracketQuotation(true);
                    break;
                }
            }
            return parser.Statement();
        }
        catch (Exception e) {
            throw new DBCException("Error parsing SQL query", e);
        }
    }

    public static boolean isSelectQuery(SQLDialect dialect, String query) {
        try {
            Statement statement = SQLSemanticProcessor.parseQuery(dialect, query);
            return statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect && CommonUtils.isEmpty((Collection)((PlainSelect)((Select)statement).getSelectBody()).getIntoTables());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String addFiltersToQuery(DBRProgressMonitor monitor, DBPDataSource dataSource, String sqlQuery, DBDDataFilter dataFilter) {
        boolean supportSubqueries = dataSource.getSQLDialect().supportsSubqueries();
        if (supportSubqueries && dataSource.getContainer().getPreferenceStore().getBoolean("sql.query.filter.force.subselect")) {
            return SQLSemanticProcessor.wrapQuery(dataSource, sqlQuery, dataFilter);
        }
        String newQuery = SQLSemanticProcessor.injectFiltersToQuery(monitor, dataSource, sqlQuery, dataFilter);
        if (newQuery == null) {
            return SQLSemanticProcessor.wrapQuery(dataSource, sqlQuery, dataFilter);
        }
        return newQuery;
    }

    public static String injectFiltersToQuery(DBRProgressMonitor monitor, DBPDataSource dataSource, String sqlQuery, DBDDataFilter dataFilter) {
        try {
            PlainSelect select;
            Statement statement = SQLSemanticProcessor.parseQuery(dataSource.getSQLDialect(), sqlQuery);
            if (statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect && SQLSemanticProcessor.patchSelectQuery(monitor, dataSource, select = (PlainSelect)((Select)statement).getSelectBody(), dataFilter)) {
                return statement.toString();
            }
        }
        catch (Throwable e) {
            log.debug("SQL parse error", e);
        }
        return null;
    }

    public static String wrapQuery(DBPDataSource dataSource, String sqlQuery, DBDDataFilter dataFilter) {
        StringBuilder modifiedQuery = new StringBuilder(sqlQuery.length() + 100);
        modifiedQuery.append("SELECT * FROM (\n");
        modifiedQuery.append(sqlQuery);
        modifiedQuery.append("\n) ").append(NESTED_QUERY_AlIAS);
        if (dataFilter.hasConditions()) {
            modifiedQuery.append(" WHERE ");
            SQLUtils.appendConditionString(dataFilter, dataSource, NESTED_QUERY_AlIAS, modifiedQuery, true);
        }
        if (dataFilter.hasOrdering()) {
            modifiedQuery.append(" ORDER BY ");
            SQLUtils.appendOrderString(dataFilter, dataSource, NESTED_QUERY_AlIAS, modifiedQuery);
        }
        return modifiedQuery.toString();
    }

    private static boolean patchSelectQuery(DBRProgressMonitor monitor, DBPDataSource dataSource, PlainSelect select, DBDDataFilter filter) throws JSQLParserException, DBException {
        if (filter.hasConditions()) {
            for (DBDAttributeConstraint co : filter.getConstraints()) {
                if (!co.hasCondition()) continue;
                Table table = SQLSemanticProcessor.getConstraintTable(select, co);
                if (!SQLSemanticProcessor.isValidTableColumn(monitor, dataSource, table, co)) {
                    table = null;
                }
                if (table != null) {
                    if (table.getAlias() != null) {
                        co.setEntityAlias(table.getAlias().getName());
                        continue;
                    }
                    co.setEntityAlias(table.getName());
                    continue;
                }
                co.setEntityAlias(null);
            }
            StringBuilder whereString = new StringBuilder();
            SQLUtils.appendConditionString(filter, dataSource, null, whereString, true);
            String condString = whereString.toString();
            SQLSemanticProcessor.addWhereToSelect(select, condString);
        }
        if (filter.hasOrdering()) {
            ArrayList<OrderByElement> orderByElements = select.getOrderByElements();
            if (orderByElements == null) {
                orderByElements = new ArrayList<OrderByElement>();
                select.setOrderByElements(orderByElements);
            }
            for (DBDAttributeConstraint co : filter.getOrderConstraints()) {
                String columnName = co.getAttributeName();
                boolean forceNumeric = filter.hasNameDuplicates(columnName) || !SQLUtils.PATTERN_SIMPLE_NAME.matcher(columnName).matches();
                Expression orderExpr = SQLSemanticProcessor.getOrderConstraintExpression(monitor, dataSource, select, co, forceNumeric);
                OrderByElement element = new OrderByElement();
                element.setExpression(orderExpr);
                if (co.isOrderDescending()) {
                    element.setAsc(false);
                    element.setAscDescPresent(true);
                }
                orderByElements.add(element);
            }
        }
        return true;
    }

    private static boolean isValidTableColumn(DBRProgressMonitor monitor, DBPDataSource dataSource, Table table, DBDAttributeConstraint co) throws DBException {
        DBSAttributeBase attribute = co.getAttribute();
        if (attribute instanceof DBDAttributeBinding) {
            attribute = ((DBDAttributeBinding)attribute).getMetaAttribute();
        }
        if (table != null && attribute instanceof DBCAttributeMetaData) {
            DBSEntity entity;
            DBSEntityAttribute entityAttribute = null;
            DBCEntityMetaData entityMetaData = ((DBCAttributeMetaData)attribute).getEntityMetaData();
            if (entityMetaData != null && (entity = DBUtils.getEntityFromMetaData(monitor, DBUtils.getDefaultContext(dataSource, true), entityMetaData)) != null) {
                entityAttribute = entity.getAttribute(monitor, co.getAttributeName());
            }
            return entityAttribute != null;
        }
        return true;
    }

    private static Expression getOrderConstraintExpression(DBRProgressMonitor monitor, DBPDataSource dataSource, PlainSelect select, DBDAttributeConstraint co, boolean forceNumeric) throws JSQLParserException, DBException {
        LongValue orderExpr;
        String attrName = DBUtils.getQuotedIdentifier(dataSource, co.getAttributeName());
        if (forceNumeric || attrName.isEmpty()) {
            orderExpr = new LongValue((long)co.getOrderPosition());
        } else if (CommonUtils.isJavaIdentifier((CharSequence)attrName)) {
            Table orderTable;
            Table table = orderTable = CommonUtils.isEmpty((Collection)select.getJoins()) ? null : SQLSemanticProcessor.getConstraintTable(select, co);
            if (!SQLSemanticProcessor.isValidTableColumn(monitor, dataSource, orderTable, co)) {
                orderTable = null;
            }
            orderExpr = new Column(orderTable, attrName);
        } else {
            orderExpr = CCJSqlParserUtil.parseExpression((String)attrName);
        }
        return orderExpr;
    }

    @Nullable
    public static Table getConstraintTable(PlainSelect select, DBDAttributeConstraint constraint) {
        String constrTable;
        DBSAttributeBase ca = constraint.getAttribute();
        if (ca instanceof DBDAttributeBinding) {
            constrTable = ((DBDAttributeBinding)ca).getMetaAttribute().getEntityName();
        } else if (ca instanceof DBSEntityAttribute) {
            constrTable = ((DBSEntityAttribute)ca).getParentObject().getName();
        } else {
            return null;
        }
        if (constrTable == null) {
            return null;
        }
        FromItem fromItem = select.getFromItem();
        Table table = SQLSemanticProcessor.findTableInFrom(fromItem, constrTable);
        if (table == null && !CommonUtils.isEmpty((Collection)select.getJoins())) {
            for (Join join : select.getJoins()) {
                table = SQLSemanticProcessor.findTableInFrom(join.getRightItem(), constrTable);
                if (table != null) break;
            }
        }
        return table;
    }

    @Nullable
    public static Table getTableFromSelect(Select select) {
        FromItem fromItem;
        if (select.getSelectBody() instanceof PlainSelect && (fromItem = ((PlainSelect)select.getSelectBody()).getFromItem()) instanceof Table) {
            return (Table)fromItem;
        }
        return null;
    }

    @Nullable
    private static Table findTableInFrom(FromItem fromItem, String tableName) {
        if (fromItem instanceof Table && tableName.equals(((Table)fromItem).getName())) {
            return (Table)fromItem;
        }
        return null;
    }

    public static void addWhereToSelect(PlainSelect select, String condString) throws JSQLParserException {
        Expression filterWhere;
        try {
            filterWhere = CCJSqlParserUtil.parseCondExpression((String)condString);
        }
        catch (JSQLParserException e) {
            throw new JSQLParserException("Bad query condition: [" + condString + "]", (Throwable)e);
        }
        SQLSemanticProcessor.addWhereToSelect(select, filterWhere);
    }

    public static void addWhereToSelect(PlainSelect select, Expression conditionExpr) throws JSQLParserException {
        Expression sourceWhere = select.getWhere();
        if (sourceWhere == null) {
            select.setWhere(conditionExpr);
        } else {
            select.setWhere((Expression)new AndExpression((Expression)new Parenthesis(sourceWhere), conditionExpr));
        }
    }
}

