/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.auth;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.access.DBASession;
import org.jkiss.dbeaver.model.auth.DBAAuthSpace;
import org.jkiss.dbeaver.model.auth.DBAAuthToken;
import org.jkiss.dbeaver.model.auth.DBASessionContext;
import org.jkiss.utils.CommonUtils;

public class SessionContextImpl
implements DBASessionContext {
    private final DBASessionContext parentContext;
    private final List<DBASession> sessions = new ArrayList<DBASession>();

    public SessionContextImpl(DBASessionContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    @Nullable
    public DBASession getSpaceSession(DBAAuthSpace space) {
        for (DBASession session : this.sessions) {
            if (!CommonUtils.equalObjects((Object)session.getSessionSpace(), (Object)space)) continue;
            return session;
        }
        return this.parentContext == null ? null : this.parentContext.getSpaceSession(space);
    }

    @Override
    public DBAAuthToken[] getSavedTokens() {
        return new DBAAuthToken[0];
    }

    @Override
    public void addSession(@NotNull DBASession session) {
        this.sessions.add(session);
    }

    @Override
    public boolean removeSession(@NotNull DBASession session) {
        return this.sessions.remove(session);
    }
}

