/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLDatabaseExportInfo;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLExportSettings;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLNativeToolHandler;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class MySQLDatabaseExportHandler
extends MySQLNativeToolHandler<MySQLExportSettings, DBSObject, MySQLDatabaseExportInfo> {
    public Collection<MySQLDatabaseExportInfo> getRunInfo(MySQLExportSettings settings) {
        return settings.getExportObjects();
    }

    protected MySQLExportSettings createTaskSettings(DBRRunnableContext context, DBTTask task) throws DBException {
        MySQLExportSettings settings = new MySQLExportSettings();
        settings.loadSettings(context, (DBPPreferenceStore)new TaskPreferenceStore(task));
        return settings;
    }

    protected boolean validateTaskParameters(DBTTask task, MySQLExportSettings settings, Log log) {
        File dir;
        if (task.getType().getId().equals("mysqlDatabaseBackup") && !(dir = settings.getOutputFolder()).exists() && !dir.mkdirs()) {
            log.error((Object)("Can't create directory '" + dir.getAbsolutePath() + "'"));
            return false;
        }
        return true;
    }

    @Override
    protected List<String> getCommandLine(MySQLExportSettings settings, MySQLDatabaseExportInfo arg) throws IOException {
        List<String> cmd = super.getCommandLine(settings, arg);
        if (!CommonUtils.isEmpty(arg.getTables())) {
            cmd.add(arg.getDatabase().getName());
            for (MySQLTableBase table : arg.getTables()) {
                cmd.add(table.getName());
            }
        } else {
            cmd.add(arg.getDatabase().getName());
        }
        return cmd;
    }

    public void fillProcessParameters(MySQLExportSettings settings, MySQLDatabaseExportInfo arg, List<String> cmd) throws IOException {
        File dumpBinary = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)settings.getClientHome(), (String)"bin", (String)"mysqldump");
        String dumpPath = dumpBinary.getAbsolutePath();
        cmd.add(dumpPath);
        switch (settings.getMethod()) {
            case LOCK_ALL_TABLES: {
                cmd.add("--lock-all-tables");
                break;
            }
            case ONLINE: {
                cmd.add("--single-transaction");
            }
        }
        if (settings.isNoCreateStatements()) {
            cmd.add("--no-create-info");
        } else if (CommonUtils.isEmpty(arg.getTables())) {
            cmd.add("--routines");
        }
        if (settings.isAddDropStatements()) {
            cmd.add("--add-drop-table");
        } else {
            cmd.add("--skip-add-drop-table");
        }
        if (settings.isDisableKeys()) {
            cmd.add("--disable-keys");
        }
        if (settings.isExtendedInserts()) {
            cmd.add("--extended-insert");
        } else {
            cmd.add("--skip-extended-insert");
        }
        if (settings.isBinariesInHex()) {
            cmd.add("--hex-blob");
        }
        if (settings.isNoData()) {
            cmd.add("--no-data");
        }
        if (settings.isDumpEvents()) {
            cmd.add("--events");
        }
        if (settings.isComments()) {
            cmd.add("--comments");
        }
        settings.addExtraCommandArgs(cmd);
    }

    protected boolean needsModelRefresh() {
        return false;
    }

    protected boolean isLogInputStream() {
        return false;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, MySQLExportSettings settings, MySQLDatabaseExportInfo arg, ProcessBuilder processBuilder, Process process, Log log) throws IOException {
        super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
        String outFileName = GeneralUtils.replaceVariables((String)settings.getOutputFilePattern(), name -> {
            switch (name) {
                case "database": {
                    return arg.getDatabase().getName();
                }
                case "host": {
                    return arg.getDatabase().getDataSource().getContainer().getConnectionConfiguration().getHostName();
                }
                case "table": {
                    Iterator<MySQLTableBase> iterator;
                    Iterator<MySQLTableBase> iterator2 = iterator = arg.getTables() == null ? null : arg.getTables().iterator();
                    if (iterator != null && iterator.hasNext()) {
                        return iterator.next().getName();
                    }
                    return "null";
                }
                case "timestamp": {
                    return RuntimeUtils.getCurrentTimeStamp();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
            }
            System.getProperty(name);
            return null;
        });
        File outFile = new File(settings.getOutputFolder(), outFileName);
        boolean isFiltering = settings.isRemoveDefiner();
        DumpFilterJob job = isFiltering ? new DumpFilterJob(monitor, process.getInputStream(), outFile, log) : new AbstractNativeToolHandler.DumpCopierJob(monitor, "Dump database", process.getInputStream(), outFile, log);
        ((Thread)((Object)job)).start();
    }

    static class DumpFilterJob
    extends AbstractNativeToolHandler.DumpJob {
        private Pattern DEFINER_PATTER = Pattern.compile("DEFINER\\s*=\\s*`[^*]*`@`[0-9a-z\\-_\\.%]*`", 2);

        DumpFilterJob(DBRProgressMonitor monitor, InputStream stream, File outFile, Log log) {
            super("MySQL databasse dump filter", monitor, stream, outFile, log);
        }

        public void runDump() throws IOException {
            this.monitor.beginTask("Export database", 100);
            long prevStatusUpdateTime = 0L;
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.input, GeneralUtils.DEFAULT_ENCODING));
                Throwable throwable = null;
                Object var6_6 = null;
                try (FileOutputStream output = new FileOutputStream(this.outFile);){
                    String line;
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, GeneralUtils.DEFAULT_ENCODING));
                    while ((line = reader.readLine()) != null) {
                        long currentTime;
                        Matcher matcher = this.DEFINER_PATTER.matcher(line);
                        if (matcher.find()) {
                            line = matcher.replaceFirst("");
                        }
                        if ((currentTime = System.currentTimeMillis()) - prevStatusUpdateTime > 300L) {
                            this.monitor.subTask("Saved " + numberFormat.format(reader.getLineNumber()) + " lines");
                            prevStatusUpdateTime = currentTime;
                        }
                        line = this.filterLine(line);
                        writer.write(line);
                        writer.newLine();
                    }
                    writer.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                this.monitor.done();
            }
        }

        @NotNull
        private String filterLine(@NotNull String line) {
            return line;
        }
    }
}

