/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourceOriginProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.registry.DataSourceOriginLocal;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;

class DataSourceOriginLazy
implements DBPDataSourceOrigin {
    private String originId;
    private Map<String, Object> originProperties;

    public DataSourceOriginLazy(String originId, Map<String, Object> originProperties) {
        this.originId = originId;
        this.originProperties = originProperties;
    }

    @NotNull
    public String getId() {
        return this.originId;
    }

    @NotNull
    public String getDisplayName() {
        return this.originId;
    }

    @Nullable
    public DBPImage getIcon() {
        return DBIcon.TYPE_UNKNOWN;
    }

    public boolean isDynamic() {
        return false;
    }

    @NotNull
    public Map<String, Object> getConfiguration() {
        return this.originProperties;
    }

    public String toString() {
        return this.getId();
    }

    @NotNull
    DBPDataSourceOrigin resolveRealOrigin() {
        DBPDataSourceOrigin origin = null;
        DBPDataSourceOriginProvider originProvider = DataSourceProviderRegistry.getInstance().getDataSourceOriginProvider(this.originId);
        if (originProvider != null) {
            origin = originProvider.getOrigin(this.originProperties);
        }
        if (origin == null) {
            origin = DataSourceOriginLocal.INSTANCE;
        }
        return origin;
    }
}

