/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public enum ERDViewStyle {
    ICONS(1, ERDUIMessages.erd_view_style_selection_item_icons),
    TYPES(2, ERDUIMessages.erd_view_style_selection_item_data_types),
    NULLABILITY(4, ERDUIMessages.erd_view_style_selection_item_nullability),
    COMMENTS(8, ERDUIMessages.erd_view_style_selection_item_comments),
    ENTITY_FQN(16, ERDUIMessages.erd_view_style_selection_item_fully_qualified_names);

    private final int value;
    private final String title;
    private static final Log log;

    static {
        log = Log.getLog(ERDAttributeVisibility.class);
    }

    private ERDViewStyle(int value, String title) {
        this.value = value;
        this.title = title;
    }

    public int getValue() {
        return this.value;
    }

    public String getTitle() {
        return this.title;
    }

    public static ERDViewStyle[] getDefaultStyles(DBPPreferenceStore store) {
        String attrString = store.getString("erd.attr.styles");
        if (!CommonUtils.isEmpty((String)attrString)) {
            String[] psList = attrString.split(",");
            ERDViewStyle[] pList = new ERDViewStyle[psList.length];
            int i = 0;
            while (i < psList.length) {
                try {
                    pList[i] = ERDViewStyle.valueOf(psList[i]);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)e);
                }
                ++i;
            }
            return pList;
        }
        return new ERDViewStyle[]{ICONS};
    }

    public static void setDefaultStyles(DBPPreferenceStore store, ERDViewStyle[] styles) {
        String stylesString = "";
        ERDViewStyle[] eRDViewStyleArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            ERDViewStyle style = eRDViewStyleArray[n2];
            if (!stylesString.isEmpty()) {
                stylesString = String.valueOf(stylesString) + ",";
            }
            stylesString = String.valueOf(stylesString) + style.name();
            ++n2;
        }
        store.setValue("erd.attr.styles", stylesString);
    }
}

