/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class JDBCTrace {
    private static final Log log = Log.getLog(JDBCTrace.class);
    private static final boolean apiTraceEnabled;
    private static final PrintWriter traceWriter;
    private static final String QUERY_DIVIDER = "=======================================================";
    private static final String RS_DIVIDER = "-------------------------------------------------------";

    static {
        boolean traceEnabled = CommonUtils.toBoolean((Object)System.getProperty("dbeaver.jdbc.trace"));
        if (traceEnabled) {
            PrintWriter writer;
            File traceFile = new File(DBWorkbench.getPlatform().getWorkspace().getMetadataFolder(), "jdbc-api-trace.log");
            try {
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(traceFile), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.error("Error opening JDBC trace file", e);
                writer = null;
            }
            traceWriter = writer;
        } else {
            traceWriter = null;
        }
        apiTraceEnabled = traceEnabled;
    }

    public static boolean isApiTraceEnabled() {
        return apiTraceEnabled;
    }

    public static void traceQueryBegin(String string) {
        if (!apiTraceEnabled) {
            return;
        }
        traceWriter.println(QUERY_DIVIDER);
        traceWriter.println(string);
        traceWriter.flush();
    }

    public static void dumpResultSetRow(ResultSet dbResult) {
        if (!apiTraceEnabled) {
            return;
        }
        try {
            ResultSetMetaData md = dbResult.getMetaData();
            int count = md.getColumnCount();
            int i = 1;
            while (i <= count) {
                Object colValue = dbResult.getObject(i);
                traceWriter.print(colValue + "\t|\t");
                ++i;
            }
            traceWriter.println();
            traceWriter.flush();
        }
        catch (Exception e) {
            log.debug(e);
        }
    }

    public static void dumpResultSetOpen(ResultSet dbResult) {
        if (!apiTraceEnabled) {
            return;
        }
        traceWriter.println(RS_DIVIDER);
        try {
            ResultSetMetaData md = dbResult.getMetaData();
            int count = md.getColumnCount();
            int i = 1;
            while (i <= count) {
                traceWriter.print(String.valueOf(md.getColumnName(i)) + " [" + md.getColumnTypeName(i) + "]\t|\t");
                ++i;
            }
            traceWriter.println();
            traceWriter.flush();
        }
        catch (Exception e) {
            log.debug(e);
        }
    }

    public static void dumpResultSetClose() {
        traceWriter.println(RS_DIVIDER);
    }
}

