/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.utils.CommonUtils;

public abstract class MySQLNativeToolHandler<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends AbstractNativeToolHandler<SETTINGS, BASE_OBJECT, PROCESS_ARG> {
    protected List<String> getMySQLToolCommandLine(AbstractNativeToolHandler<SETTINGS, BASE_OBJECT, PROCESS_ARG> handler, SETTINGS settings, PROCESS_ARG arg) throws IOException {
        String toolUserPassword;
        ArrayList<String> cmd = new ArrayList<String>();
        handler.fillProcessParameters(settings, arg, cmd);
        String toolUserName = settings.getToolUserName();
        if (CommonUtils.isEmpty((String)toolUserName)) {
            toolUserName = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserName();
        }
        if (CommonUtils.isEmpty((String)(toolUserPassword = settings.getToolUserPassword()))) {
            toolUserPassword = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserPassword();
        }
        if (!CommonUtils.isEmpty((String)toolUserName)) {
            String credentialsFile = MySQLNativeToolHandler.createCredentialsFile(toolUserName, toolUserPassword);
            cmd.add(1, "--defaults-file=" + credentialsFile);
        }
        DBPConnectionConfiguration connectionInfo = settings.getDataSourceContainer().getActualConnectionConfiguration();
        cmd.add("--host=" + connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            cmd.add("--port=" + connectionInfo.getHostPort());
        }
        return cmd;
    }

    private static String createCredentialsFile(String username, String password) throws IOException {
        File dir = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "mysql-native-handler");
        File cnf = new File(dir, "my.cnf");
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter writer = new FileWriter(cnf);){
            writer.write("[client]");
            writer.write("\nuser=" + (CommonUtils.isEmpty((String)username) ? "" : username));
            writer.write("\npassword=" + (CommonUtils.isEmpty((String)password) ? "" : password));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return cnf.getPath();
    }
}

