/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.jobs.DisconnectJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.controls.resultset.IQueryExecuteController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetJobAbstract;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;

abstract class ResultSetJobDataRead
extends ResultSetJobAbstract
implements ILoadService<Object>,
IQueryExecuteController {
    private static final int PROGRESS_VISUALIZE_PERIOD = 100;
    private DBDDataFilter dataFilter;
    private Composite progressControl;
    private int offset;
    private int maxRows;
    private Throwable error;
    private DBCStatistics statistics;
    private boolean refresh;

    ResultSetJobDataRead(DBSDataContainer dataContainer, DBDDataFilter dataFilter, ResultSetViewer controller, DBCExecutionContext executionContext, Composite progressControl) {
        super(String.valueOf(ResultSetMessages.controls_rs_pump_job_name) + " [" + dataContainer + "]", dataContainer, controller, executionContext);
        this.dataFilter = dataFilter;
        this.progressControl = progressControl;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public Throwable getError() {
        return this.error;
    }

    void setError(Throwable error) {
        this.error = error;
    }

    DBCStatistics getStatistics() {
        return this.statistics;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        this.error = null;
        ProgressLoaderVisualizer visualizer = new ProgressLoaderVisualizer((ILoadService)this, this.progressControl);
        DBRProgressMonitor progressMonitor = visualizer.overwriteMonitor(monitor);
        new PumpVisualizer((ProgressLoaderVisualizer<Object>)visualizer).schedule(200L);
        long fetchFlags = 2L;
        if (this.offset > 0) {
            fetchFlags |= 0x10L;
        }
        if (this.offset > 0 && this.getExecutionContext().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.reread.on.scroll")) {
            if (this.maxRows > 0) {
                this.maxRows += this.offset;
            }
            this.offset = 0;
        }
        if (this.refresh) {
            fetchFlags |= 0x100L;
        }
        long finalFlags = fetchFlags;
        DBCExecutionPurpose purpose = this.dataFilter != null && this.dataFilter.hasFilters() ? DBCExecutionPurpose.USER_FILTERED : DBCExecutionPurpose.USER;
        progressMonitor.beginTask("Read data", 1);
        try {
            try {
                Throwable throwable = null;
                Object var10_10 = null;
                try (DBCSession session = this.getExecutionContext().openSession(progressMonitor, purpose, NLS.bind((String)ResultSetMessages.controls_rs_pump_job_context_name, (Object)this.dataContainer.toString()));){
                    DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)session.getDataSource(), monitor1 -> {
                        try {
                            this.statistics = this.dataContainer.readData((DBCExecutionSource)this, session, (DBDDataReceiver)this.controller.getDataReceiver(), this.dataFilter, (long)this.offset, (long)this.maxRows, finalFlags, 0);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                this.error = e;
                visualizer.completeLoading(null);
                progressMonitor.done();
            }
        }
        finally {
            visualizer.completeLoading(null);
            progressMonitor.done();
        }
        return Status.OK_STATUS;
    }

    public String getServiceName() {
        return "ResultSet data pump";
    }

    public Object evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return null;
    }

    public Object getFamily() {
        return this.getExecutionController();
    }

    private class PumpVisualizer
    extends UIJob {
        private ProgressLoaderVisualizer<Object> visualizer;

        PumpVisualizer(ProgressLoaderVisualizer<Object> visualizer) {
            super(UIUtils.getDisplay(), "RSV Pump Visualizer");
            this.setSystem(true);
            this.visualizer = visualizer;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ResultSetJobDataRead loadService = (ResultSetJobDataRead)this.visualizer.getLoadService();
            if (loadService != null && loadService.isCanceled()) {
                long cancelTimestamp = loadService.getCancelTimestamp();
                long cancelTimeout = ResultSetJobDataRead.this.controller.getPreferenceStore().getLong("resultset.cancel.timeout");
                if (cancelTimeout > 0L && System.currentTimeMillis() - cancelTimestamp > cancelTimeout && UIUtils.confirmAction((Shell)this.getDisplay().getActiveShell(), (String)"Database not responding", (String)"Database driver is not responding.\nDo you want to cancel request and close connection?", (int)8)) {
                    DBPDataSource dataSource = ResultSetJobDataRead.this.dataContainer.getDataSource();
                    if (dataSource != null) {
                        new DisconnectJob(dataSource.getContainer()).schedule();
                    }
                    ResultSetJobDataRead.this.controller.removeDataPump(loadService);
                    loadService.forceDataReadCancel(new DBCException("Cancel operation timed out"));
                    this.visualizer.completeLoading(null);
                    this.visualizer.visualizeLoading();
                    return Status.OK_STATUS;
                }
            }
            if (!ResultSetJobDataRead.this.controller.getDataReceiver().isDataReceivePaused()) {
                this.visualizer.visualizeLoading();
            } else {
                this.visualizer.resetStartTime();
            }
            if (!this.visualizer.isCompleted()) {
                this.schedule(100L);
            }
            return Status.OK_STATUS;
        }
    }
}

