/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.AuthModelPgPassCredentials;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class AuthModelPgPass
extends AuthModelDatabaseNative<AuthModelPgPassCredentials> {
    private static final Log log = Log.getLog(AuthModelPgPass.class);
    public static final String PGPASSFILE_ENV_VARIABLE = "PGPASSFILE";

    @NotNull
    public AuthModelPgPassCredentials createCredentials() {
        return new AuthModelPgPassCredentials();
    }

    @NotNull
    public AuthModelPgPassCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelPgPassCredentials credentials = (AuthModelPgPassCredentials)super.loadCredentials(dataSource, configuration);
        try {
            this.loadPasswordFromPgPass(credentials, dataSource, configuration);
            credentials.setParseError(null);
        }
        catch (DBException e) {
            credentials.setParseError((Exception)((Object)e));
        }
        return credentials;
    }

    public void initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelPgPassCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        if (credentials.getParseError() != null) {
            throw new DBCException("Couldn't get password from PGPASS file", (Throwable)credentials.getParseError());
        }
        super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connectProps);
    }

    /*
     * Unable to fully structure code
     */
    private void loadPasswordFromPgPass(AuthModelPgPassCredentials credentials, DBPDataSourceContainer dataSource, DBPConnectionConfiguration configuration) throws DBException {
        conHostName = configuration.getHostName();
        conHostPort = configuration.getHostPort();
        conDatabaseName = configuration.getDatabaseName();
        conUserName = configuration.getUserName();
        if (CommonUtils.isEmpty((String)conHostPort)) {
            conHostPort = dataSource.getDriver().getDefaultPort();
        }
        if (CommonUtils.isEmpty((String)(pgPassPath = System.getenv("PGPASSFILE")))) {
            if (RuntimeUtils.isPlatformWindows()) {
                appData = System.getenv("AppData");
                if (appData == null) {
                    appData = System.getProperty("user.home");
                }
                pgPassPath = String.valueOf(appData) + "/postgresql/pgpass.conf";
            } else {
                pgPassPath = String.valueOf(System.getProperty("user.home")) + "/.pgpass";
            }
        }
        if (!(pgPassFile = new File(pgPassPath)).exists()) {
            throw new DBException("PgPass file '" + pgPassFile.getAbsolutePath() + "' not found");
        }
        try {
            var10_10 = null;
            var11_13 = null;
            try {
                r = new InputStreamReader((InputStream)new FileInputStream(pgPassFile), GeneralUtils.UTF8_CHARSET);
                try {
                    passString = IOUtils.readToString((Reader)r);
                    var18_18 = lines = passString.split("\n");
                    var17_19 = lines.length;
                    var16_20 = 0;
                    while (true) {
                        line = var18_18[var16_20];
                        if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && (params = AuthModelPgPass.splitPassLine(line)) != null) {
                            host = params[0];
                            port = params[1];
                            database = params[2];
                            user = params[3];
                            password = params[4];
                            if (AuthModelPgPass.matchParam(conHostName, host) && AuthModelPgPass.matchParam(conHostPort, port) && AuthModelPgPass.matchParam(conDatabaseName, database) && AuthModelPgPass.matchParam(conUserName, user)) {
                                if (!user.equals("*")) {
                                    configuration.setUserName(user);
                                }
                                credentials.setUserPassword(password);
                                return;
                            }
                        }
                        ++var16_20;
                        break;
                    }
                }
                finally {
                    if (var16_20 < var17_19) ** continue;
                }
            }
            catch (Throwable var11_14) {
                if (var10_10 == null) {
                    var10_10 = var11_14;
                } else if (var10_10 != var11_14) {
                    var10_10.addSuppressed(var11_14);
                }
                throw var10_10;
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading pgpass", (Throwable)e);
        }
        throw new DBException("No matches in pgpass");
    }

    @Nullable
    private static String[] splitPassLine(String line) {
        String[] params = (line = line.replace("\\\\", "@BSESC@").replace("\\:", "@CESC@")).split(":");
        if (params.length < 5) {
            return null;
        }
        int i = 0;
        while (i < params.length) {
            params[i] = params[i].replace("@CESC@", ":").replace("@BSESC@", "\\");
            ++i;
        }
        return params;
    }

    private static boolean matchParam(String cfgParam, String passParam) {
        return passParam.equals("*") || passParam.equalsIgnoreCase(cfgParam);
    }
}

