/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentBytes;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class UUIDOrderedAttributeTransformer
implements DBDAttributeTransformer {
    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "UUID (Ordered)", 16, DBPDataKind.BINARY));
        attribute.setTransformHandler(new UUIDValueHandler(attribute.getValueHandler()));
    }

    private class UUIDValueHandler
    extends ProxyValueHandler {
        public UUIDValueHandler(DBDValueHandler target) {
            super(target);
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            byte[] bytes = null;
            if (value instanceof byte[]) {
                bytes = (byte[])value;
            } else if (value instanceof JDBCContentBytes) {
                bytes = ((JDBCContentBytes)value).getRawValue();
            }
            if (bytes != null && bytes.length >= 16) {
                long mostSigBits = ((long)bytes[4] << 56) + ((long)(bytes[5] & 0xFF) << 48) + ((long)(bytes[6] & 0xFF) << 40) + ((long)(bytes[7] & 0xFF) << 32) + ((long)(bytes[2] & 0xFF) << 24) + (long)((bytes[3] & 0xFF) << 16) + (long)((bytes[0] & 0xFF) << 8) + (long)((bytes[1] & 0xFF) << 0);
                long leastSigBits = ((long)bytes[8] << 56) + ((long)(bytes[9] & 0xFF) << 48) + ((long)(bytes[10] & 0xFF) << 40) + ((long)(bytes[11] & 0xFF) << 32) + ((long)(bytes[12] & 0xFF) << 24) + (long)((bytes[13] & 0xFF) << 16) + (long)((bytes[14] & 0xFF) << 8) + (long)((bytes[15] & 0xFF) << 0);
                return new UUID(mostSigBits, leastSigBits).toString();
            }
            return super.getValueDisplayString(column, value, format);
        }
    }
}

