/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentBytes;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class UUIDAttributeTransformer
implements DBDAttributeTransformer {
    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "UUID", -1, DBPDataKind.BINARY));
        attribute.setTransformHandler(new UUIDValueHandler(attribute.getValueHandler()));
    }

    private class UUIDValueHandler
    extends ProxyValueHandler {
        public UUIDValueHandler(DBDValueHandler target) {
            super(target);
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            byte[] bytes = null;
            if (value instanceof byte[]) {
                bytes = (byte[])value;
            } else if (value instanceof JDBCContentBytes) {
                bytes = ((JDBCContentBytes)value).getRawValue();
            }
            if (bytes != null) {
                try {
                    return GeneralUtils.getUUIDFromBytes(bytes).toString();
                }
                catch (Exception exception) {
                    return String.valueOf(value);
                }
            }
            return super.getValueDisplayString(column, value, format);
        }
    }
}

