/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.references;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.references.ReferencesResultsDecorator;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class ReferencesResultsContainer
implements IResultSetContainer {
    private static final Log log = Log.getLog(ReferencesResultsContainer.class);
    private static final String V_PROP_ACTIVE_ASSOCIATIONS = "ref-panel-associations";
    private final IResultSetController parentController;
    private final Composite mainComposite;
    private final CSmartCombo<ReferenceKey> fkCombo;
    private ResultSetViewer dataViewer;
    private DBSDataContainer parentDataContainer;
    private DBSDataContainer dataContainer;
    private final List<ReferenceKey> referenceKeys = new ArrayList<ReferenceKey>();
    private ReferenceKey activeReferenceKey;
    private List<ResultSetRow> lastSelectedRows;

    ReferencesResultsContainer(Composite parent, IResultSetController parentController) {
        this.parentController = parentController;
        this.mainComposite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite keySelectorPanel = UIUtils.createComposite((Composite)this.mainComposite, (int)2);
        GridData gd = new GridData(768);
        gd.verticalIndent = 5;
        keySelectorPanel.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)keySelectorPanel, (String)"Reference");
        this.fkCombo = new CSmartCombo(keySelectorPanel, 2060, (ILabelProvider)new RefKeyLabelProvider());
        this.fkCombo.addItem(null);
        this.fkCombo.setLayoutData((Object)new GridData(768));
        this.fkCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferencesResultsContainer.this.activeReferenceKey = (ReferenceKey)ReferencesResultsContainer.this.fkCombo.getSelectedItem();
                if (ReferencesResultsContainer.this.activeReferenceKey == null) {
                    return;
                }
                ReferencesResultsContainer.this.refreshKeyValues(true);
                DBVEntity vEntityOwner = DBVUtils.getVirtualEntity((DBSDataContainer)ReferencesResultsContainer.this.parentDataContainer, (boolean)true);
                ArrayList<Map<String, Object>> activeAssociations = new ArrayList<Map<String, Object>>();
                activeAssociations.add(ReferencesResultsContainer.this.activeReferenceKey.createMemo());
                Object curActiveAssociations = vEntityOwner.getProperty(ReferencesResultsContainer.V_PROP_ACTIVE_ASSOCIATIONS);
                if (!CommonUtils.equalObjects((Object)curActiveAssociations, activeAssociations)) {
                    vEntityOwner.setProperty(ReferencesResultsContainer.V_PROP_ACTIVE_ASSOCIATIONS, activeAssociations);
                    vEntityOwner.persistConfiguration();
                }
            }
        });
        Composite viewerContainer = new Composite(this.mainComposite, 0);
        viewerContainer.setLayoutData((Object)new GridData(1808));
        viewerContainer.setLayout((Layout)new FillLayout());
        this.dataViewer = new ResultSetViewer(viewerContainer, parentController.getSite(), this);
    }

    public ReferenceKey getActiveReferenceKey() {
        return this.activeReferenceKey;
    }

    public IResultSetPresentation getOwnerPresentation() {
        return this.parentController.getActivePresentation();
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        DBSDataContainer dataContainer = this.getDataContainer();
        return dataContainer == null || dataContainer.getDataSource() == null ? null : dataContainer.getDataSource().getContainer().getProject();
    }

    public DBCExecutionContext getExecutionContext() {
        return DBUtils.getDefaultContext((DBSObject)this.dataContainer, (boolean)false);
    }

    @Override
    public IResultSetController getResultSetController() {
        return this.dataViewer;
    }

    @Override
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new ReferencesResultsDecorator(this);
    }

    public Composite getControl() {
        return this.mainComposite;
    }

    public void refreshReferences() {
        this.dataViewer.resetHistory();
        DBSDataContainer newParentContainer = this.parentController.getDataContainer();
        if (newParentContainer != this.parentDataContainer) {
            this.refreshReferenceKeyList();
        } else if (this.dataContainer != null) {
            this.refreshKeyValues(false);
        }
    }

    private void refreshReferenceKeyList() {
        Object activeAssociations;
        this.activeReferenceKey = null;
        this.referenceKeys.clear();
        UIUtils.syncExec(() -> {
            this.dataViewer.clearData();
            this.fkCombo.removeAll();
            this.dataViewer.showEmptyPresentation();
        });
        List<DBDAttributeBinding> visibleAttributes = this.parentController.getModel().getVisibleAttributes();
        if (visibleAttributes.isEmpty()) {
            return;
        }
        this.parentDataContainer = this.parentController.getDataContainer();
        if (this.parentDataContainer == null) {
            return;
        }
        final LinkedHashSet<DBSEntity> allEntities = new LinkedHashSet<DBSEntity>();
        for (DBDAttributeBinding attr : visibleAttributes) {
            DBSEntityAttribute entityAttribute = attr.getEntityAttribute();
            if (entityAttribute == null) continue;
            allEntities.add(entityAttribute.getParentObject());
        }
        if (allEntities.isEmpty() && this.parentDataContainer instanceof DBSEntity) {
            allEntities.add((DBSEntity)this.parentDataContainer);
        }
        final ArrayList<ReferenceKeyMemo> refKeyMemos = new ArrayList<ReferenceKeyMemo>();
        DBVEntity vEntityOwner = DBVUtils.getVirtualEntity((DBSDataContainer)this.parentDataContainer, (boolean)false);
        if (vEntityOwner != null && (activeAssociations = vEntityOwner.getProperty(V_PROP_ACTIVE_ASSOCIATIONS)) instanceof Collection) {
            for (Object refKeyMemoMap : (Collection)activeAssociations) {
                if (!(refKeyMemoMap instanceof Map)) continue;
                refKeyMemos.add(new ReferenceKeyMemo((Map)refKeyMemoMap));
            }
        }
        if (!allEntities.isEmpty()) {
            new AbstractJob("Load reference keys"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        ArrayList<ReferenceKey> refs = new ArrayList<ReferenceKey>();
                        for (DBSEntity entity : allEntities) {
                            if (entity instanceof DBVEntity) continue;
                            List associations = DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)entity);
                            for (DBSEntityAssociation assoc : associations) {
                                List attrs;
                                if (!(assoc instanceof DBSEntityReferrer) || CommonUtils.isEmpty((Collection)(attrs = ((DBSEntityReferrer)assoc).getAttributeReferences(monitor)))) continue;
                                ReferenceKey referenceKey = new ReferenceKey(monitor, false, assoc.getAssociatedEntity(), assoc, attrs);
                                refs.add(referenceKey);
                            }
                            List references = DBVUtils.getAllReferences((DBRProgressMonitor)monitor, (DBSEntity)entity);
                            for (DBSEntityAssociation assoc : references) {
                                List attrs;
                                if (!(assoc instanceof DBSEntityReferrer) || CommonUtils.isEmpty((Collection)(attrs = ((DBSEntityReferrer)assoc).getAttributeReferences(monitor)))) continue;
                                ReferenceKey referenceKey = new ReferenceKey(monitor, true, entity, assoc, attrs);
                                refs.add(referenceKey);
                            }
                        }
                        List list = ReferencesResultsContainer.this.referenceKeys;
                        synchronized (list) {
                            ReferencesResultsContainer.this.referenceKeys.clear();
                            ReferencesResultsContainer.this.referenceKeys.addAll(refs);
                            if (!ReferencesResultsContainer.this.referenceKeys.isEmpty()) {
                                if (!refKeyMemos.isEmpty()) {
                                    for (ReferenceKey key : ReferencesResultsContainer.this.referenceKeys) {
                                        for (ReferenceKeyMemo memo : refKeyMemos) {
                                            if (!key.matches(memo)) continue;
                                            ReferencesResultsContainer.this.activeReferenceKey = key;
                                            break;
                                        }
                                        if (ReferencesResultsContainer.this.activeReferenceKey != null) break;
                                    }
                                }
                                if (ReferencesResultsContainer.this.activeReferenceKey == null) {
                                    ReferencesResultsContainer.this.activeReferenceKey = (ReferenceKey)ReferencesResultsContainer.this.referenceKeys.get(0);
                                }
                            }
                        }
                        UIUtils.syncExec(() -> ReferencesResultsContainer.this.fillKeysCombo());
                    }
                    catch (DBException e) {
                        log.debug((Object)"Error reading references", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void fillKeysCombo() {
        if (this.fkCombo.isDisposed()) {
            return;
        }
        this.fkCombo.removeAll();
        if (this.referenceKeys.isEmpty()) {
            this.fkCombo.addItem(null);
        }
        for (ReferenceKey key : this.referenceKeys) {
            this.fkCombo.addItem((Object)key);
            if (key != this.activeReferenceKey) continue;
            this.fkCombo.select((Object)key);
        }
        if (this.activeReferenceKey != null) {
            this.refreshKeyValues(true);
        }
    }

    private void refreshKeyValues(final boolean force) {
        if (this.activeReferenceKey == null) {
            return;
        }
        new AbstractJob("Read references"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    DBSEntity realEntity = DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)ReferencesResultsContainer.this.activeReferenceKey.refEntity);
                    if (!(realEntity instanceof DBSDataContainer)) {
                        log.error((Object)"Referencing entity is not a data container");
                        return Status.OK_STATUS;
                    }
                    ReferencesResultsContainer.this.dataContainer = (DBSDataContainer)realEntity;
                    List<ResultSetRow> selectedRows = ReferencesResultsContainer.this.parentController.getSelection().getSelectedRows();
                    if (!force && CommonUtils.equalObjects((Object)ReferencesResultsContainer.this.lastSelectedRows, selectedRows)) {
                        return Status.OK_STATUS;
                    }
                    ReferencesResultsContainer.this.lastSelectedRows = selectedRows;
                    if (selectedRows.isEmpty()) {
                        UIUtils.asyncExec(() -> {
                            ReferencesResultsContainer.this.dataViewer.clearData();
                            ReferencesResultsContainer.this.dataViewer.showEmptyPresentation();
                        });
                    } else if (ReferencesResultsContainer.this.activeReferenceKey.isReference) {
                        ReferencesResultsContainer.this.dataViewer.navigateReference(monitor, ReferencesResultsContainer.this.parentController.getModel(), ReferencesResultsContainer.this.activeReferenceKey.refAssociation, selectedRows, false);
                    } else {
                        ReferencesResultsContainer.this.dataViewer.navigateAssociation(monitor, ReferencesResultsContainer.this.parentController.getModel(), ReferencesResultsContainer.this.activeReferenceKey.refAssociation, selectedRows, false);
                    }
                }
                catch (Exception e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private class RefKeyLabelProvider
    extends LabelProvider {
        private RefKeyLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element == null) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_ASSOCIATION);
            }
            ReferenceKey key = (ReferenceKey)element;
            return DBeaverIcons.getImage((DBPImage)(key.isReference ? UIIcon.ARROW_LEFT_ALL : UIIcon.ARROW_RIGHT_ALL));
        }

        public String getText(Object element) {
            if (element == null) {
                return "<No references>";
            }
            ReferenceKey key = (ReferenceKey)element;
            DBSEntity targetEntity = key.targetEntity;
            String title = String.valueOf(targetEntity.getName()) + " (" + key.refAssociation.getName() + ")";
            if (ReferencesResultsContainer.this.parentController.getDataContainer() != null && ReferencesResultsContainer.this.parentController.getDataContainer().getDataSource() != targetEntity.getDataSource()) {
                title = String.valueOf(title) + " [" + targetEntity.getDataSource().getContainer().getName() + "]";
            }
            return title;
        }
    }

    static class ReferenceKey {
        private final boolean isReference;
        private final DBSEntity refEntity;
        private final DBSEntityAssociation refAssociation;
        private final List<? extends DBSEntityAttributeRef> refAttributes;
        private DBSEntity targetEntity;

        ReferenceKey(DBRProgressMonitor monitor, boolean isReference, DBSEntity refEntity, DBSEntityAssociation refAssociation, List<? extends DBSEntityAttributeRef> refAttributes) {
            this.isReference = isReference;
            this.refEntity = refEntity;
            this.refAssociation = refAssociation;
            this.refAttributes = refAttributes;
            if (refAssociation != null) {
                if (isReference) {
                    this.targetEntity = refAssociation.getParentObject();
                } else {
                    DBSEntityConstraint refConstraint = refAssociation.getReferencedConstraint();
                    if (refConstraint != null) {
                        this.targetEntity = refConstraint.getParentObject();
                    }
                }
            }
            if (this.targetEntity instanceof DBVEntity) {
                try {
                    DBSEntity realEntity = ((DBVEntity)this.targetEntity).getRealEntity(monitor);
                    if (realEntity != null) {
                        this.targetEntity = realEntity;
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
        }

        public boolean isReference() {
            return this.isReference;
        }

        boolean matches(ReferenceKeyMemo memo) {
            return this.isReference == memo.isReference && CommonUtils.equalObjects((Object)DBUtils.getObjectFullName((DBPNamedObject)this.refEntity, (DBPEvaluationContext)DBPEvaluationContext.UI), (Object)memo.refEntityName) && CommonUtils.equalObjects((Object)this.refAssociation.getName(), (Object)memo.refAssociationName);
        }

        Map<String, Object> createMemo() {
            LinkedHashMap<String, Object> memo = new LinkedHashMap<String, Object>();
            memo.put("ref", this.isReference);
            memo.put("entity", DBUtils.getObjectFullName((DBPNamedObject)this.refEntity, (DBPEvaluationContext)DBPEvaluationContext.UI));
            memo.put("name", this.refAssociation.getName());
            return memo;
        }
    }

    static class ReferenceKeyMemo {
        final boolean isReference;
        final String refEntityName;
        final String refAssociationName;

        ReferenceKeyMemo(Map<String, Object> map) {
            this.isReference = CommonUtils.toBoolean((Object)map.get("ref"));
            this.refEntityName = CommonUtils.toString((Object)map.get("entity"));
            this.refAssociationName = CommonUtils.toString((Object)map.get("name"));
        }
    }
}

