/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.stream;

import java.util.Locale;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StreamConsumerPageOutput
extends ActiveWizardPage<DataTransferWizard> {
    private Combo encodingCombo;
    private Button encodingBOMCheckbox;
    private Text timestampPattern;
    private Text directoryText;
    private Text fileNameText;
    private Button compressCheckbox;
    private Button showFolderCheckbox;
    private Button execProcessCheckbox;
    private Text execProcessText;
    private Button clipboardCheck;
    private Button singleFileCheck;
    private Button showFinalMessageCheckbox;
    private Button splitFilesCheckbox;
    private Label maximumFileSizeLabel;
    private Text maximumFileSizeText;

    public StreamConsumerPageOutput() {
        super(DTMessages.data_transfer_wizard_output_name);
        this.setTitle(DTMessages.data_transfer_wizard_output_title);
        this.setDescription(DTMessages.data_transfer_wizard_output_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)DTMessages.data_transfer_wizard_output_group_general, (int)5, (int)768, (int)0);
        this.clipboardCheck = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_copy_to_clipboard, null, (boolean)false, (int)5);
        this.clipboardCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOutputClipboard(StreamConsumerPageOutput.this.clipboardCheck.getSelection());
                StreamConsumerPageOutput.this.updateControlsEnablement();
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.directoryText = DialogUtils.createOutputFolderChooser((Composite)generalSettings, null, e -> {
            settings.setOutputFolder(this.directoryText.getText());
            this.updatePageCompletion();
        });
        ((GridData)this.directoryText.getParent().getLayoutData()).horizontalSpan = 4;
        UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_file_name_pattern);
        this.fileNameText = new Text((Composite)generalSettings, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        UIUtils.setContentProposalToolTip((Control)this.fileNameText, (String)DTUIMessages.stream_consumer_page_output_tooltip_output_file_name_pattern, (String[])new String[]{"datasource", "catalog", "schema", "table", "timestamp", "date", "index", "project"});
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.addModifyListener(e -> {
            settings.setOutputFilePattern(this.fileNameText.getText());
            this.updatePageCompletion();
        });
        ContentAssistUtils.installContentProposal((Control)this.fileNameText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"datasource"), GeneralUtils.variablePattern((String)"catalog"), GeneralUtils.variablePattern((String)"schema"), GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"timestamp"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"index"), GeneralUtils.variablePattern((String)"project")}));
        UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)generalSettings, (String)settings.getOutputEncoding());
        this.encodingCombo.addModifyListener(e -> {
            int index = this.encodingCombo.getSelectionIndex();
            if (index >= 0) {
                settings.setOutputEncoding(this.encodingCombo.getItem(index));
            }
            this.updatePageCompletion();
        });
        this.timestampPattern = UIUtils.createLabelText((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_timestamp_pattern, (String)"yyyyMMddHHmm", (int)2048);
        this.timestampPattern.addModifyListener(e -> settings.setOutputTimestampPattern(this.timestampPattern.getText()));
        this.encodingBOMCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_insert_bom, (String)DTMessages.data_transfer_wizard_output_label_insert_bom_tooltip, (boolean)false, (int)1);
        this.encodingBOMCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOutputEncodingBOM(StreamConsumerPageOutput.this.encodingBOMCheckbox.getSelection());
            }
        });
        this.singleFileCheck = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_use_single_file, (String)DTMessages.data_transfer_wizard_output_label_use_single_file_tip, (boolean)false, (int)5);
        this.singleFileCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseSingleFile(StreamConsumerPageOutput.this.singleFileCheck.getSelection());
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.compressCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_compress, null, (boolean)false, (int)1);
        this.compressCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompressResults(StreamConsumerPageOutput.this.compressCheckbox.getSelection());
                StreamConsumerPageOutput.this.updateControlsEnablement();
            }
        });
        Composite outFilesSettings = UIUtils.createComposite((Composite)generalSettings, (int)3);
        outFilesSettings.setLayoutData((Object)new GridData(1, 1, true, false, 5, 1));
        this.splitFilesCheckbox = UIUtils.createCheckbox((Composite)outFilesSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_split_files, (String)DTMessages.data_transfer_wizard_output_checkbox_split_files_tip, (boolean)false, (int)1);
        this.splitFilesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setSplitOutFiles(StreamConsumerPageOutput.this.splitFilesCheckbox.getSelection());
                StreamConsumerPageOutput.this.updateControlsEnablement();
            }
        });
        this.maximumFileSizeLabel = UIUtils.createControlLabel((Composite)outFilesSettings, (String)DTUIMessages.stream_consumer_page_output_label_maximum_file_size);
        this.maximumFileSizeText = new Text(outFilesSettings, 2048);
        this.maximumFileSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        this.maximumFileSizeText.addModifyListener(e -> settings.setMaxOutFileSize(CommonUtils.toLong((Object)this.maximumFileSizeText.getText())));
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.maximumFileSizeText) * 10;
        this.maximumFileSizeText.setLayoutData((Object)gd);
        Group resultsSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.stream_consumer_page_output_label_results, (int)2, (int)768, (int)0);
        this.showFolderCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_open_folder, (boolean)true);
        this.showFolderCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenFolderOnFinish(StreamConsumerPageOutput.this.showFolderCheckbox.getSelection());
            }
        });
        this.showFolderCheckbox.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        this.execProcessCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)DTUIMessages.stream_consumer_page_output_checkbox_execute_process, (boolean)true);
        this.execProcessCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setExecuteProcessOnFinish(StreamConsumerPageOutput.this.execProcessCheckbox.getSelection());
                StreamConsumerPageOutput.this.updateControlsEnablement();
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.execProcessText = new Text((Composite)resultsSettings, 2048);
        this.execProcessText.setLayoutData((Object)new GridData(768));
        this.execProcessText.addModifyListener(e -> {
            settings.setFinishProcessCommand(this.execProcessText.getText());
            this.updatePageCompletion();
        });
        UIUtils.setContentProposalToolTip((Control)this.execProcessText, (String)DTUIMessages.stream_consumer_page_output_tooltip_process_command_line, (String[])new String[]{"file", "table", "timestamp", "date", "project"});
        ContentAssistUtils.installContentProposal((Control)this.execProcessText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"timestamp"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"project"), GeneralUtils.variablePattern((String)"file")}));
        this.showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)DTUIMessages.stream_consumer_page_output_label_show_finish_message, null, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage(), (int)4);
        this.showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)StreamConsumerPageOutput.this.getWizard()).getSettings().setShowFinalMessage(StreamConsumerPageOutput.this.showFinalMessageCheckbox.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    private void updateControlsEnablement() {
        boolean isBinary = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor().isBinaryFormat();
        boolean clipboard = !isBinary && this.clipboardCheck.getSelection();
        boolean isMulti = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().size() > 1;
        this.singleFileCheck.getSelection();
        this.clipboardCheck.setEnabled(!isBinary);
        this.singleFileCheck.setEnabled(isMulti && !clipboard && ((DataTransferWizard)this.getWizard()).getSettings().getMaxJobCount() <= 1);
        this.directoryText.setEnabled(!clipboard);
        this.fileNameText.setEnabled(!clipboard);
        this.compressCheckbox.setEnabled(!clipboard);
        this.splitFilesCheckbox.setEnabled(!clipboard);
        this.maximumFileSizeLabel.setEnabled(!clipboard && this.splitFilesCheckbox.getSelection());
        this.maximumFileSizeText.setEnabled(!clipboard && this.splitFilesCheckbox.getSelection());
        this.encodingCombo.setEnabled(!isBinary && !clipboard);
        this.encodingBOMCheckbox.setEnabled(!isBinary && !clipboard);
        this.timestampPattern.setEnabled(!clipboard);
        this.showFolderCheckbox.setEnabled(!clipboard);
        this.execProcessCheckbox.setEnabled(!clipboard);
        this.execProcessText.setEnabled(!clipboard);
    }

    public void activatePage() {
        boolean isBinary = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor().isBinaryFormat();
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        this.clipboardCheck.setSelection(settings.isOutputClipboard());
        this.singleFileCheck.setSelection(settings.isUseSingleFile());
        this.directoryText.setText(CommonUtils.toString((Object)settings.getOutputFolder()));
        this.fileNameText.setText(CommonUtils.toString((Object)settings.getOutputFilePattern()));
        this.compressCheckbox.setSelection(settings.isCompressResults());
        this.splitFilesCheckbox.setSelection(settings.isSplitOutFiles());
        this.maximumFileSizeText.setText(String.valueOf(settings.getMaxOutFileSize()));
        this.encodingCombo.setText(CommonUtils.toString((Object)settings.getOutputEncoding()));
        this.timestampPattern.setText(settings.getOutputTimestampPattern());
        this.encodingBOMCheckbox.setSelection(settings.isOutputEncodingBOM());
        this.showFolderCheckbox.setSelection(settings.isOpenFolderOnFinish());
        this.execProcessCheckbox.setSelection(settings.isExecuteProcessOnFinish());
        this.execProcessText.setText(CommonUtils.toString((Object)settings.getFinishProcessCommand()));
        if (isBinary) {
            this.clipboardCheck.setSelection(false);
            this.encodingBOMCheckbox.setSelection(false);
            settings.setOutputClipboard(false);
        }
        this.showFinalMessageCheckbox.setSelection(((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage());
        this.updatePageCompletion();
        this.updateControlsEnablement();
    }

    protected boolean determinePageCompletion() {
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        if (settings == null) {
            return false;
        }
        if (settings.isOutputClipboard()) {
            return true;
        }
        boolean valid = true;
        if (CommonUtils.isEmpty((String)settings.getOutputFolder())) {
            valid = false;
        }
        if (CommonUtils.isEmpty((String)settings.getOutputFilePattern())) {
            valid = false;
        }
        if (settings.isExecuteProcessOnFinish() && CommonUtils.isEmpty((String)settings.getFinishProcessCommand())) {
            return false;
        }
        return valid;
    }
}

