/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.ColumnsMappingDialog;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ObjectContainerSelectorPanel;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerPageMapping
extends ActiveWizardPage<DataTransferWizard> {
    private static final Log log = Log.getLog(DatabaseConsumerPageMapping.class);
    private static final String TARGET_NAME_BROWSE = "[browse]";
    private TreeViewer mappingViewer;
    private Button autoAssignButton;
    private ObjectContainerSelectorPanel containerPanel;

    public DatabaseConsumerPageMapping() {
        super(DTUIMessages.database_consumer_page_mapping_name_and_title);
        this.setTitle(DTUIMessages.database_consumer_page_mapping_name_and_title);
        this.setDescription(DTUIMessages.database_consumer_page_mapping_description);
    }

    private DatabaseConsumerSettings getDatabaseConsumerSettings() {
        return ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        final DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.containerPanel = new ObjectContainerSelectorPanel(composite, ((DataTransferWizard)this.getWizard()).getProject(), "container.data-transfer.database-consumer", DTMessages.data_transfer_db_consumer_target_container, DTMessages.data_transfer_db_consumer_choose_container){

            @Nullable
            protected DBNNode getSelectedNode() {
                DBNDatabaseNode selectedNode = settings.getContainerNode();
                if (selectedNode == null && !settings.getDataMappings().isEmpty()) {
                    DBSDataContainer firstSource = (DBSDataContainer)settings.getDataMappings().keySet().iterator().next();
                    selectedNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)firstSource);
                    while (selectedNode != null) {
                        if (selectedNode instanceof DBSWrapper && ((DBSWrapper)selectedNode).getObject() instanceof DBSObjectContainer) break;
                        selectedNode = selectedNode.getParentNode();
                    }
                }
                return selectedNode;
            }

            protected void setSelectedNode(DBNDatabaseNode node) {
                settings.setContainerNode(node);
                this.setContainerInfo(node);
                for (DatabaseMappingContainer mappingContainer : settings.getDataMappings().values()) {
                    if (mappingContainer.getMappingType() == DatabaseMappingType.unspecified) continue;
                    try {
                        mappingContainer.refreshMappingType(((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getRunnableContext(), DatabaseMappingType.unspecified);
                    }
                    catch (DBException e1) {
                        log.error((Object)e1);
                    }
                }
                DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                DatabaseConsumerPageMapping.this.updatePageCompletion();
                DatabaseConsumerPageMapping.this.setMessage(null);
            }
        };
        this.createMappingsTree(composite);
        Composite buttonsPanel = new Composite(composite, 0);
        buttonsPanel.setLayout((Layout)new GridLayout(5, false));
        buttonsPanel.setLayoutData((Object)new GridData(768));
        this.autoAssignButton = new Button(buttonsPanel, 8);
        this.autoAssignButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ASTERISK));
        this.autoAssignButton.setText(DTMessages.data_transfer_db_consumer_auto_assign);
        this.autoAssignButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConsumerPageMapping.this.autoAssignMappings();
            }
        });
        Button mapTableButton = new Button(buttonsPanel, 8);
        mapTableButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_TABLE));
        mapTableButton.setText(DTMessages.data_transfer_db_consumer_existing_table);
        mapTableButton.setEnabled(false);
        mapTableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConsumerPageMapping.this.mapExistingTable((DatabaseMappingContainer)DatabaseConsumerPageMapping.this.getSelectedMapping());
            }
        });
        Button createNewButton = new Button(buttonsPanel, 8);
        createNewButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_VIEW));
        createNewButton.setText(DTMessages.data_transfer_db_consumer_new_table);
        createNewButton.setEnabled(false);
        createNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConsumerPageMapping.this.mapNewTable((DatabaseMappingContainer)DatabaseConsumerPageMapping.this.getSelectedMapping());
            }
        });
        Button columnsButton = new Button(buttonsPanel, 8);
        columnsButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_COLUMNS));
        columnsButton.setText(DTMessages.data_transfer_db_consumer_column_mappings);
        columnsButton.setEnabled(false);
        columnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMappingObject selectedMapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                DatabaseConsumerPageMapping.this.mapColumns(selectedMapping instanceof DatabaseMappingContainer ? (DatabaseMappingContainer)selectedMapping : ((DatabaseMappingAttribute)selectedMapping).getParent());
            }
        });
        Button ddlButton = new Button(buttonsPanel, 8);
        ddlButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_TEXT));
        ddlButton.setText(DTMessages.data_transfer_db_consumer_ddl);
        ddlButton.setEnabled(false);
        ddlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMappingObject selectedMapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                DatabaseConsumerPageMapping.this.showDDL(selectedMapping instanceof DatabaseMappingContainer ? (DatabaseMappingContainer)selectedMapping : ((DatabaseMappingAttribute)selectedMapping).getParent());
            }
        });
        this.mappingViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    boolean updated = false;
                    Object element = null;
                    if (e.character != '\r') {
                        TreeItem item;
                        int n;
                        if (e.character == '\u007f') {
                            TreeItem[] treeItemArray = DatabaseConsumerPageMapping.this.mappingViewer.getTree().getSelection();
                            int n2 = treeItemArray.length;
                            n = 0;
                            while (n < n2) {
                                item = treeItemArray[n];
                                element = item.getData();
                                if (element instanceof DatabaseMappingAttribute) {
                                    DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)element;
                                    attribute.setMappingType(DatabaseMappingType.skip);
                                } else if (element instanceof DatabaseMappingContainer) {
                                    DatabaseMappingContainer container = (DatabaseMappingContainer)element;
                                    container.refreshMappingType(((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getRunnableContext(), DatabaseMappingType.skip);
                                }
                                ++n;
                            }
                            updated = true;
                        } else if (e.character == ' ') {
                            TreeItem[] treeItemArray = DatabaseConsumerPageMapping.this.mappingViewer.getTree().getSelection();
                            int n3 = treeItemArray.length;
                            n = 0;
                            while (n < n3) {
                                item = treeItemArray[n];
                                element = item.getData();
                                if (element instanceof DatabaseMappingAttribute) {
                                    DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)item.getData();
                                    attribute.setMappingType(DatabaseMappingType.existing);
                                    attribute.updateMappingType((DBRProgressMonitor)new VoidProgressMonitor());
                                } else if (element instanceof DatabaseMappingContainer) {
                                    DatabaseMappingContainer container = (DatabaseMappingContainer)element;
                                    DatabaseConsumerPageMapping.this.setMappingTarget((DatabaseMappingObject)container, container.getSource().getName());
                                }
                                ++n;
                            }
                            updated = true;
                        }
                    }
                    if (updated) {
                        List model;
                        int curIndex;
                        DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                        DatabaseConsumerPageMapping.this.updatePageCompletion();
                        if (element instanceof DatabaseMappingContainer && (curIndex = (model = (List)DatabaseConsumerPageMapping.this.mappingViewer.getInput()).indexOf(element)) < model.size() - 1) {
                            DatabaseConsumerPageMapping.this.mappingViewer.setSelection((ISelection)new StructuredSelection(model.get(curIndex + 1)), true);
                        }
                    }
                }
                catch (DBException e1) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_error_mapping_table, DTUIMessages.database_consumer_page_mapping_message_error_mapping_target_table, (Throwable)e1);
                }
            }
        });
        this.mappingViewer.addSelectionChangedListener(event -> {
            DatabaseMappingObject mapping = this.getSelectedMapping();
            mapTableButton.setEnabled(mapping instanceof DatabaseMappingContainer);
            createNewButton.setEnabled(mapping instanceof DatabaseMappingContainer && settings.getContainerNode() != null);
            boolean hasMappings = mapping instanceof DatabaseMappingContainer && mapping.getMappingType() != DatabaseMappingType.unspecified || mapping instanceof DatabaseMappingAttribute && ((DatabaseMappingAttribute)mapping).getParent().getMappingType() != DatabaseMappingType.unspecified;
            columnsButton.setEnabled(hasMappings);
            ddlButton.setEnabled(hasMappings);
        });
        this.mappingViewer.addDoubleClickListener(event -> {
            DatabaseMappingObject selectedMapping = this.getSelectedMapping();
            if (selectedMapping != null) {
                boolean cfr_ignored_0 = selectedMapping instanceof DatabaseMappingContainer;
            }
        });
        Composite hintPanel = new Composite(composite, 0);
        hintPanel.setLayout((Layout)new GridLayout(3, false));
        hintPanel.setLayoutData((Object)new GridData(32));
        new Label(hintPanel, 0).setText(DTUIMessages.database_consumer_page_mapping_label_hint);
        this.setControl((Control)composite);
    }

    private void createMappingsTree(Composite composite) {
        this.mappingViewer = new TreeViewer(composite, 67586);
        this.mappingViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.mappingViewer.getTree().setLinesVisible(true);
        this.mappingViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn columnSource = new TreeViewerColumn(this.mappingViewer, 16384);
        columnSource.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(DBUtils.getObjectFullName((DBPNamedObject)mapping.getSource(), (DBPEvaluationContext)DBPEvaluationContext.UI));
                if (mapping.getIcon() != null) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)mapping.getIcon()));
                }
                super.update(cell);
            }
        });
        columnSource.getColumn().setText(DTUIMessages.database_consumer_page_mapping_column_source_text);
        TreeViewerColumn columnTarget = new TreeViewerColumn(this.mappingViewer, 16384);
        columnTarget.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(mapping.getTargetName());
                if (mapping.getMappingType() == DatabaseMappingType.unspecified) {
                    cell.setBackground(UIUtils.getSharedTextColors().getColor(SharedTextColors.COLOR_WARNING));
                } else {
                    cell.setBackground(null);
                }
                super.update(cell);
            }
        });
        columnTarget.getColumn().setText(DTUIMessages.database_consumer_page_mapping_column_target_text);
        columnTarget.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                try {
                    return DatabaseConsumerPageMapping.this.createTargetEditor(element);
                }
                catch (DBException e) {
                    DatabaseConsumerPageMapping.this.setErrorMessage(e.getMessage());
                    return null;
                }
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                if (mapping.getMappingType() == DatabaseMappingType.unspecified) {
                    String newName = DatabaseConsumerPageMapping.this.transformTargetName(DBUtils.getQuotedIdentifier((DBPNamedObject)mapping.getSource()));
                    this.setValue(element, newName);
                    return newName;
                }
                if (mapping instanceof DatabaseMappingContainer) {
                    if (mapping.getMappingType() == DatabaseMappingType.existing) {
                        return ((DatabaseMappingContainer)mapping).getTarget();
                    }
                    return mapping.getTargetName();
                }
                if (mapping.getMappingType() == DatabaseMappingType.existing) {
                    return ((DatabaseMappingAttribute)mapping).getTarget();
                }
                return mapping.getTargetName();
            }

            protected void setValue(Object element, Object value) {
                try {
                    DatabaseConsumerSettings settings = DatabaseConsumerPageMapping.this.getDatabaseConsumerSettings();
                    String name = CommonUtils.toString((Object)value);
                    DBPDataSource dataSource = settings.getTargetDataSource((DatabaseMappingObject)element);
                    if (!name.equals("[skip]") && !name.equals(DatabaseConsumerPageMapping.TARGET_NAME_BROWSE) && dataSource != null) {
                        name = DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)name);
                        name = DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)name);
                    }
                    DatabaseConsumerPageMapping.this.setMappingTarget((DatabaseMappingObject)element, name);
                    DatabaseConsumerPageMapping.this.mappingViewer.update(element, null);
                    DatabaseConsumerPageMapping.this.mappingViewer.setSelection(DatabaseConsumerPageMapping.this.mappingViewer.getSelection());
                    DatabaseConsumerPageMapping.this.updatePageCompletion();
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_mapping_error, DTUIMessages.database_consumer_page_mapping_message_error_setting_target_table, (Throwable)e);
                }
            }
        });
        TreeViewerColumn columnMapping = new TreeViewerColumn(this.mappingViewer, 16384);
        columnMapping.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(mapping.getMappingType().name());
                super.update(cell);
            }
        });
        columnMapping.getColumn().setText(DTUIMessages.database_consumer_page_mapping_column_mapping_text);
        columnMapping.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                ArrayList<String> mappingTypes = new ArrayList<String>();
                mappingTypes.add(DatabaseMappingType.skip.name());
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                if (mapping instanceof DatabaseMappingAttribute) {
                    mappingTypes.add(((DatabaseMappingAttribute)mapping).getParent().getMappingType().name());
                } else {
                    mappingTypes.add(mapping.getMappingType().name());
                }
                return new CustomComboBoxCellEditor((ColumnViewer)DatabaseConsumerPageMapping.this.mappingViewer, (Composite)DatabaseConsumerPageMapping.this.mappingViewer.getTree(), mappingTypes.toArray(new String[0]), 12);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                return mapping.getMappingType().name();
            }

            protected void setValue(Object element, Object value) {
                try {
                    DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                    DatabaseMappingType mappingType = DatabaseMappingType.valueOf((String)value.toString());
                    if (mapping instanceof DatabaseMappingAttribute) {
                        ((DatabaseMappingAttribute)mapping).setMappingType(mappingType);
                    } else {
                        ((DatabaseMappingContainer)mapping).refreshMappingType(((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getRunnableContext(), mappingType);
                    }
                    DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                    DatabaseConsumerPageMapping.this.setErrorMessage(null);
                }
                catch (DBException e) {
                    DatabaseConsumerPageMapping.this.setErrorMessage(e.getMessage());
                }
            }
        });
        this.mappingViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public boolean hasChildren(Object element) {
                return element instanceof DatabaseMappingContainer;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof DatabaseMappingContainer) {
                    return ((DatabaseMappingContainer)parentElement).getAttributeMappings(((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getRunnableContext()).toArray();
                }
                return null;
            }
        });
    }

    private CellEditor createTargetEditor(Object element) throws DBException {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        boolean allowsCreate = true;
        ArrayList<String> items = new ArrayList<String>();
        if (element instanceof DatabaseMappingContainer) {
            if (settings.getContainerNode() == null) {
                allowsCreate = false;
            }
            if (settings.getContainer() != null) {
                DBSObjectContainer container = settings.getContainer();
                for (DBSObject child : container.getChildren((DBRProgressMonitor)new VoidProgressMonitor())) {
                    if (!(child instanceof DBSDataManipulator)) continue;
                    items.add(this.transformTargetName(DBUtils.getQuotedIdentifier((DBSObject)child)));
                }
            }
            items.add(TARGET_NAME_BROWSE);
        } else {
            DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)element;
            switch (mapping.getParent().getMappingType()) {
                case unspecified: 
                case skip: {
                    allowsCreate = false;
                }
            }
            if (mapping.getParent().getTarget() instanceof DBSEntity) {
                DBSEntity parentEntity = (DBSEntity)mapping.getParent().getTarget();
                for (DBSEntityAttribute attr : parentEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) {
                    items.add(this.transformTargetName(DBUtils.getQuotedIdentifier((DBSObject)attr)));
                }
            }
        }
        items.add("[skip]");
        CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor((ColumnViewer)this.mappingViewer, (Composite)this.mappingViewer.getTree(), items.toArray(new String[0]), 4 | (allowsCreate ? 0 : 8));
        return editor;
    }

    private void setMappingTarget(DatabaseMappingObject mapping, String name) throws DBException {
        if (name.equals("[skip]")) {
            if (mapping instanceof DatabaseMappingAttribute) {
                ((DatabaseMappingAttribute)mapping).setMappingType(DatabaseMappingType.skip);
            } else {
                ((DatabaseMappingContainer)mapping).refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.skip);
            }
        } else if (name.equals(TARGET_NAME_BROWSE)) {
            this.mapExistingTable((DatabaseMappingContainer)mapping);
        } else {
            name = this.transformTargetName(name);
            DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
            if (mapping instanceof DatabaseMappingContainer) {
                DatabaseMappingContainer containerMapping = (DatabaseMappingContainer)mapping;
                if (settings.getContainer() != null) {
                    DBSObjectContainer container = settings.getContainer();
                    for (DBSObject child : container.getChildren((DBRProgressMonitor)new VoidProgressMonitor())) {
                        if (!(child instanceof DBSDataManipulator) || !name.equalsIgnoreCase(child.getName())) continue;
                        containerMapping.setTarget((DBSDataManipulator)child);
                        containerMapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.existing);
                        return;
                    }
                }
                containerMapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.create);
                ((DatabaseMappingContainer)mapping).setTargetName(name);
            } else {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)mapping;
                if (attrMapping.getParent().getTarget() instanceof DBSEntity) {
                    DBSEntity parentEntity = (DBSEntity)attrMapping.getParent().getTarget();
                    for (DBSEntityAttribute attr : parentEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) {
                        if (!name.equalsIgnoreCase(attr.getName())) continue;
                        attrMapping.setMappingType(DatabaseMappingType.existing);
                        attrMapping.setTarget(attr);
                        return;
                    }
                }
                attrMapping.setMappingType(DatabaseMappingType.create);
                attrMapping.setTargetName(name);
            }
        }
    }

    private void autoAssignMappings() {
        TreeItem[] treeItemArray = this.mappingViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (element instanceof DatabaseMappingContainer) {
                DatabaseMappingContainer container = (DatabaseMappingContainer)element;
                try {
                    this.setMappingTarget((DatabaseMappingObject)container, container.getSource().getName());
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_mapping_error, NLS.bind((String)DTUIMessages.database_consumer_page_mapping_message_error_auto_mapping_source_table, (Object)container.getSource().getName()), (Throwable)e);
                }
            }
            ++n2;
        }
        this.mappingViewer.refresh();
        this.updatePageCompletion();
    }

    private void updateAutoAssign() {
        boolean hasUnassigned = false;
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        for (DatabaseMappingContainer mapping : settings.getDataMappings().values()) {
            if (mapping.getMappingType() == DatabaseMappingType.create || mapping.getMappingType() == DatabaseMappingType.existing) continue;
            hasUnassigned = true;
            break;
        }
        this.autoAssignButton.setEnabled(hasUnassigned);
    }

    private void mapExistingTable(DatabaseMappingContainer mapping) {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (activeProject != null) {
            DBNNode node;
            DBNDatabaseNode rootNode = settings.getContainerNode();
            if (rootNode == null) {
                rootNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(activeProject).getDatabases();
            }
            DBNDatabaseNode selectedNode = rootNode;
            if (mapping.getTarget() != null) {
                selectedNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)mapping.getTarget());
            }
            if ((node = DBWorkbench.getPlatformUI().selectObject((Object)this.getShell(), DTUIMessages.database_consumer_page_mapping_node_title, (DBNNode)rootNode, (DBNNode)selectedNode, new Class[]{DBSObjectContainer.class, DBSDataManipulator.class}, new Class[]{DBSDataManipulator.class}, null)) != null && node instanceof DBSWrapper) {
                DBSObject object = ((DBSWrapper)node).getObject();
                try {
                    if (object instanceof DBSDataManipulator) {
                        mapping.setTarget((DBSDataManipulator)object);
                        mapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.existing);
                        this.mapColumns(mapping);
                    } else {
                        mapping.setTarget(null);
                        mapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.unspecified);
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_error_mapping_table, DTUIMessages.database_consumer_page_mapping_message_error_mapping_existing_table, (Throwable)e);
                }
                this.mappingViewer.refresh();
                this.updatePageCompletion();
            }
        }
    }

    private void mapNewTable(DatabaseMappingContainer mapping) {
        String tableName = EnterNameDialog.chooseName((Shell)this.getShell(), (String)DTUIMessages.database_consumer_page_mapping_table_name, (String)this.transformTargetName(mapping.getMappingType() == DatabaseMappingType.create ? mapping.getTargetName() : ""));
        if (!CommonUtils.isEmpty((String)tableName)) {
            try {
                mapping.setTargetName(tableName);
                mapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.create);
                this.mappingViewer.refresh();
                this.updatePageCompletion();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_mapping_error, DTUIMessages.database_consumer_page_mapping_message_error_mapping_new_table, (Throwable)e);
            }
        }
    }

    private String transformTargetName(String name) {
        DBSObjectContainer container = this.getDatabaseConsumerSettings().getContainer();
        if (container == null) {
            return name;
        }
        return DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)name);
    }

    private void mapColumns(DatabaseMappingContainer mapping) {
        ColumnsMappingDialog dialog = new ColumnsMappingDialog((DataTransferWizard)this.getWizard(), this.getDatabaseConsumerSettings(), mapping);
        if (dialog.open() == 0) {
            this.mappingViewer.refresh();
            this.updatePageCompletion();
        }
    }

    private void showDDL(DatabaseMappingContainer mapping) {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        DBSObjectContainer container = settings.getContainer();
        if (container == null) {
            return;
        }
        DBPDataSource dataSource = container.getDataSource();
        String[] ddl = new String[1];
        try {
            this.getContainer().run(true, true, monitor -> {
                monitor.beginTask(DTUIMessages.database_consumer_page_mapping_monitor_task, 1);
                try {
                    DBCExecutionContext executionContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true);
                    stringArray[0] = DatabaseTransferConsumer.generateTargetTableDDL((DBRProgressMonitor)new DefaultProgressMonitor(monitor), (DBCExecutionContext)executionContext, (DBSObjectContainer)container, (DatabaseMappingContainer)mapping);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_target_DDL, DTUIMessages.database_consumer_page_mapping_message_error_generating_target_DDL, (Throwable)e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (serviceSQL != null) {
            serviceSQL.openSQLViewer(DBUtils.getDefaultContext((DBSObject)container, (boolean)true), DTUIMessages.database_consumer_page_mapping_sqlviewer_title, null, ddl[0], false, false);
        }
    }

    private DatabaseMappingObject getSelectedMapping() {
        IStructuredSelection selection = (IStructuredSelection)this.mappingViewer.getSelection();
        return selection.isEmpty() ? null : (DatabaseMappingObject)selection.getFirstElement();
    }

    public void activatePage() {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        DBSObjectContainer producerContainer = null;
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            Object container;
            DBSObject producerObject;
            if (pipe.getProducer() == null || !((producerObject = pipe.getProducer().getDatabaseObject()) instanceof DBSDataContainer) || !((container = producerObject.getParentObject()) instanceof DBSObjectContainer)) continue;
            producerContainer = (DBSObjectContainer)container;
        }
        settings.loadNode(((DataTransferWizard)this.getWizard()).getRunnableContext(), producerContainer);
        DBNDatabaseNode containerNode = settings.getContainerNode();
        if (containerNode != null) {
            try {
                this.containerPanel.checkValidContainerNode((DBNNode)containerNode);
                this.containerPanel.setContainerInfo(containerNode);
            }
            catch (DBException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
        ArrayList<DatabaseMappingContainer> model = new ArrayList<DatabaseMappingContainer>();
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            if (pipe.getProducer() == null) continue;
            DBSDataContainer sourceObject = (DBSDataContainer)pipe.getProducer().getDatabaseObject();
            DatabaseMappingContainer mapping = settings.getDataMapping(sourceObject);
            if (mapping == null) {
                if (pipe.getConsumer() instanceof DatabaseTransferConsumer && ((DatabaseTransferConsumer)pipe.getConsumer()).getTargetObject() != null) {
                    try {
                        mapping = new DatabaseMappingContainer(((DataTransferWizard)this.getWizard()).getRunnableContext(), this.getDatabaseConsumerSettings(), sourceObject, ((DatabaseTransferConsumer)pipe.getConsumer()).getTargetObject());
                    }
                    catch (DBException e) {
                        this.setMessage(e.getMessage(), 3);
                        mapping = new DatabaseMappingContainer(this.getDatabaseConsumerSettings(), sourceObject);
                    }
                } else {
                    mapping = new DatabaseMappingContainer(this.getDatabaseConsumerSettings(), sourceObject);
                }
                settings.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), sourceObject, mapping);
            }
            model.add(mapping);
        }
        this.mappingViewer.setInput(model);
        Tree table = this.mappingViewer.getTree();
        int totalWidth = table.getClientArea().width;
        TreeColumn[] columns = table.getColumns();
        columns[0].setWidth(totalWidth * 40 / 100);
        columns[1].setWidth(totalWidth * 40 / 100);
        columns[2].setWidth(totalWidth * 20 / 100);
        this.updatePageCompletion();
    }

    protected boolean determinePageCompletion() {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        if (settings.getContainerNode() == null) {
            this.setErrorMessage(DTUIMessages.database_consumer_page_mapping_error_message_set_target_container);
            return false;
        }
        if (!settings.isCompleted((Collection)((DataTransferWizard)this.getWizard()).getSettings().getDataPipes())) {
            this.setErrorMessage(DTUIMessages.database_consumer_page_mapping_error_message_set_all_tables_mappings);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
        this.updateAutoAssign();
    }

    private static abstract class MappingLabelProvider
    extends CellLabelProvider {
        private MappingLabelProvider() {
        }

        public void update(ViewerCell cell) {
        }
    }
}

