/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.DataSourcePropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IProgressControlProvider;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectEditorPageControl;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderListener;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderComposite;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderInfo;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorContributorManager;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorContributorUser;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabasePostSaveProcessor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorsRegistry;
import org.jkiss.dbeaver.ui.editors.entity.GlobalContributorManager;
import org.jkiss.dbeaver.ui.editors.entity.IEntityEditorContext;
import org.jkiss.dbeaver.ui.editors.entity.IEntityStructureEditor;
import org.jkiss.dbeaver.ui.editors.entity.properties.TabbedFolderPageEditor;
import org.jkiss.dbeaver.ui.editors.entity.properties.TabbedFolderPageForm;
import org.jkiss.dbeaver.ui.editors.entity.properties.TabbedFolderPageNode;
import org.jkiss.dbeaver.ui.editors.entity.properties.TabbedFolderPageProperties;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.utils.CommonUtils;

public class ObjectPropertiesEditor
extends AbstractDatabaseObjectEditor<DBSObject>
implements IEntityStructureEditor,
IRefreshablePart,
IProgressControlProvider,
ITabbedFolderContainer,
ISearchContextProvider,
INavigatorModelView,
IEntityEditorContext,
IDatabasePostSaveProcessor {
    private static final Log log = Log.getLog(ObjectPropertiesEditor.class);
    private TabbedFolderComposite folderComposite;
    private ObjectEditorPageControl pageControl;
    private final List<ITabbedFolderListener> folderListeners = new ArrayList<ITabbedFolderListener>();
    private String curFolderId;
    private final List<ISaveablePart> nestedSaveable = new ArrayList<ISaveablePart>();
    private final Map<ITabbedFolder, IEditorActionBarContributor> pageContributors = new HashMap<ITabbedFolder, IEditorActionBarContributor>();
    private SashForm sashForm;
    private boolean activated = false;
    private Composite propsPlaceholder;
    @Nullable
    private TabbedFolderPageForm propertiesPanel;
    private Composite mainComposite;

    public void createPartControl(Composite parent) {
        this.pageControl = new ObjectEditorPageControl(parent, 0x10000000, (IDatabaseEditor)this){

            public void fillCustomActions(IContributionManager contributionManager) {
                ObjectPropertiesEditor.this.createPropertyRefreshAction(contributionManager);
                super.fillCustomActions(contributionManager);
                if (ObjectPropertiesEditor.this.propertiesPanel != null && ObjectPropertiesEditor.this.folderComposite == null) {
                    DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)ObjectPropertiesEditor.this.getSite(), (IContributionManager)contributionManager);
                }
            }
        };
        CSSUtils.setCSSClass((Widget)this.pageControl, (String)"coloredByConnectionType");
        this.pageControl.setShowDivider(true);
        this.mainComposite = new Composite((Composite)this.pageControl, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 5;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.mainComposite.setLayout((Layout)gl);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.pageControl.createProgressPanel();
        this.curFolderId = this.getEditorInput().getDefaultFolderId();
    }

    private void createPropertyBrowser(Composite container) {
        this.pageControl.setRedraw(false);
        try {
            TabbedFolderInfo[] folders = this.collectFolders((IWorkbenchPart)this);
            if (folders.length == 0) {
                this.createPropertiesPanel(container);
            } else {
                Composite foldersParent = container;
                if (this.hasPropertiesEditor() && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("entity.editor.info.detach")) {
                    this.sashForm = UIUtils.createPartDivider((IWorkbenchPart)this.getSite().getPart(), (Composite)container, (int)512);
                    this.sashForm.setLayoutData((Object)new GridData(1808));
                    foldersParent = this.sashForm;
                    this.createPropertiesPanel((Composite)this.sashForm);
                }
                this.createFoldersPanel(foldersParent, folders);
            }
            if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("entity.editor.info.detach") && this.hasPropertiesEditor()) {
                this.propertiesPanel = new TabbedFolderPageForm((IWorkbenchPart)this, this.pageControl, this.getEditorInput());
                this.propertiesPanel.createControl(this.propsPlaceholder);
            }
            if (this.sashForm != null) {
                this.updateSashWidths();
            }
            this.pageControl.layout(true, true);
        }
        finally {
            this.pageControl.setRedraw(true);
        }
    }

    private void createPropertiesPanel(Composite container) {
        this.propsPlaceholder = new Composite(container, 0);
        this.propsPlaceholder.setLayout((Layout)new FillLayout());
    }

    private Composite createFoldersPanel(Composite parent, TabbedFolderInfo[] folders) {
        int n;
        boolean single;
        Composite foldersPlaceholder = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)0);
        foldersPlaceholder.setLayoutData((Object)new GridData(1808));
        boolean bl = single = folders.length < 4;
        if (single) {
            TabbedFolderInfo[] tabbedFolderInfoArray = folders;
            n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                TabbedFolderInfo fi = tabbedFolderInfoArray[n2];
                if (!fi.isEmbeddable()) {
                    single = false;
                }
                ++n2;
            }
        }
        this.folderComposite = new TabbedFolderComposite(foldersPlaceholder, 0x4000 | (single ? 4 : 2));
        this.folderComposite.setLayoutData((Object)new GridData(1808));
        String objectId = "PropertiesEditor." + this.getDatabaseObject().getClass().getName();
        this.folderComposite.setFolders(objectId, folders);
        GlobalContributorManager contributorManager = GlobalContributorManager.getInstance();
        TabbedFolderInfo[] tabbedFolderInfoArray = folders;
        int n3 = folders.length;
        n = 0;
        while (n < n3) {
            IEditorActionBarContributor contributor;
            TabbedFolderInfo folder = tabbedFolderInfoArray[n];
            ITabbedFolder page = folder.getContents();
            if (page instanceof IDatabaseEditorContributorUser && (contributor = ((IDatabaseEditorContributorUser)page).getContributor((IDatabaseEditorContributorManager)contributorManager)) != null) {
                contributorManager.addContributor(contributor, (IEditorPart)this);
                this.pageContributors.put(page, contributor);
            }
            if (page instanceof ISaveablePart) {
                this.nestedSaveable.add((ISaveablePart)page);
            }
            ++n;
        }
        this.folderComposite.switchFolder(this.curFolderId);
        this.folderComposite.addFolderListener(folderId1 -> {
            IEditorActionBarContributor activeFolderContributor;
            ITabbedFolder activeFolder;
            if (CommonUtils.equalObjects((Object)this.curFolderId, (Object)folderId1)) {
                return;
            }
            IActionBars actionBars = this.getEditorSite().getActionBars();
            MultiPageEditorPart mainEditor = ((MultiPageEditorSite)this.getSite()).getMultiPageEditor();
            IWorkbenchPartSite mainEditorSite = mainEditor.getSite();
            if (mainEditorSite instanceof PartSite) {
                ((PartSite)mainEditorSite).deactivateActionBars(true);
            }
            if ((activeFolder = this.folderComposite.getActiveFolder()) instanceof TabbedFolderPageEditor && (activeFolderContributor = this.pageContributors.get(activeFolder)) != null) {
                activeFolderContributor.setActiveEditor(((TabbedFolderPageEditor)activeFolder).getEditor());
            }
            actionBars.updateActionBars();
            List<ITabbedFolderListener> list = this.folderListeners;
            synchronized (list) {
                this.curFolderId = folderId1;
                for (ITabbedFolderListener listener : this.folderListeners) {
                    listener.folderSelected(folderId1);
                }
            }
        });
        return foldersPlaceholder;
    }

    public static Point getParentSize(Control control) {
        Composite composite = control.getParent();
        while (composite != null) {
            if (composite instanceof CTabFolder) {
                Point size = composite.getSize();
                if (size.x > 0 && size.y > 0) {
                    return size;
                }
            }
            composite = composite.getParent();
        }
        return new Point(0, 0);
    }

    private void updateSashWidths() {
        float ratio;
        int propsRatio;
        int[] newWeights;
        if (this.sashForm.isDisposed()) {
            return;
        }
        Point propsSize = this.propsPlaceholder.computeSize(-1, -1, true);
        propsSize.y += 10;
        Point sashSize = this.sashForm.getParent().getSize();
        if (sashSize.x <= 0 || sashSize.y <= 0) {
            sashSize = ObjectPropertiesEditor.getParentSize((Control)this.sashForm);
        }
        if (sashSize.x > 0 && sashSize.y > 0 && !Arrays.equals(newWeights = new int[]{propsRatio = Math.min(1000, (int)(1000.0f * (ratio = (float)propsSize.y / (float)sashSize.y))), 1000 - propsRatio}, this.sashForm.getWeights())) {
            this.sashForm.setWeights(newWeights);
        }
    }

    public void activatePart() {
        if (this.activated) {
            return;
        }
        UIUtils.asyncExec(() -> this.createPropertyBrowser(this.mainComposite));
        this.activated = true;
    }

    private boolean hasPropertiesEditor() {
        return !(this.getEditorInput().getDatabaseObject() instanceof DBNDatabaseFolder);
    }

    public void dispose() {
        GlobalContributorManager contributorManager = GlobalContributorManager.getInstance();
        for (IEditorActionBarContributor contributor : this.pageContributors.values()) {
            contributorManager.removeContributor(contributor, (IEditorPart)this);
        }
        this.pageContributors.clear();
        super.dispose();
    }

    public void setFocus() {
        if (this.folderComposite != null) {
            ITabbedFolder selectedPage = this.folderComposite.getActiveFolder();
            if (selectedPage != null) {
                selectedPage.setFocus();
            }
        } else if (this.pageControl != null) {
            this.pageControl.setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        for (ISaveablePart sp : this.nestedSaveable) {
            if (!sp.isDirty()) continue;
            sp.doSave(monitor);
        }
    }

    public void doSaveAs() {
        ITabbedFolder activeFolder = this.getActiveFolder();
        if (activeFolder instanceof ISaveablePart) {
            ((ISaveablePart)activeFolder).doSaveAs();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        for (ISaveablePart sp : this.nestedSaveable) {
            if (!sp.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Nullable
    public ProgressPageControl getProgressControl() {
        return this.pageControl;
    }

    @Nullable
    public ITabbedFolder getActiveFolder() {
        return this.getActiveFolder(true);
    }

    private ITabbedFolder getActiveFolder(boolean activate) {
        return this.folderComposite == null ? null : this.folderComposite.getActiveFolder(activate);
    }

    public boolean switchFolder(String folderId) {
        this.curFolderId = folderId;
        if (this.folderComposite != null) {
            return this.folderComposite.switchFolder(this.curFolderId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFolderListener(ITabbedFolderListener listener) {
        List<ITabbedFolderListener> list = this.folderListeners;
        synchronized (list) {
            this.folderListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderListener(ITabbedFolderListener listener) {
        List<ITabbedFolderListener> list = this.folderListeners;
        synchronized (list) {
            this.folderListeners.remove(listener);
        }
    }

    @Nullable
    private ISearchContextProvider getFolderSearch() {
        ITabbedFolder activeFolder = this.getActiveFolder();
        if (activeFolder instanceof ISearchContextProvider) {
            return (ISearchContextProvider)activeFolder;
        }
        return null;
    }

    public boolean isSearchPossible() {
        return true;
    }

    public boolean isSearchEnabled() {
        ISearchContextProvider provider = this.getFolderSearch();
        return provider != null && provider.isSearchEnabled();
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        ISearchContextProvider folderSearch = this.getFolderSearch();
        if (folderSearch != null) {
            return folderSearch.performSearch(searchType);
        }
        return false;
    }

    public void refreshPart(Object source, boolean force) {
        if (this.propertiesPanel != null) {
            this.propertiesPanel.refreshPart(source, force);
        }
        if (this.folderComposite != null && this.folderComposite.getFolders() != null) {
            TabbedFolderInfo[] tabbedFolderInfoArray = this.folderComposite.getFolders();
            int n = tabbedFolderInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                TabbedFolderInfo folder = tabbedFolderInfoArray[n2];
                if (folder.getContents() instanceof IRefreshablePart) {
                    ((IRefreshablePart)folder.getContents()).refreshPart(source, force);
                }
                ++n2;
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result = null;
        ITabbedFolder activeFolder = this.getActiveFolder(false);
        if (activeFolder != null) {
            if (activeFolder instanceof IAdaptable) {
                result = ((IAdaptable)activeFolder).getAdapter(adapter);
            } else if (adapter.isAssignableFrom(activeFolder.getClass())) {
                result = activeFolder;
            }
        }
        if (result != null) {
            return adapter.cast(result);
        }
        return null;
    }

    public TabbedFolderInfo[] collectFolders(IWorkbenchPart part) {
        ArrayList<TabbedFolderInfo> tabList = new ArrayList<TabbedFolderInfo>();
        this.makeStandardPropertiesTabs(tabList);
        if (part instanceof IDatabaseEditor) {
            this.makeDatabaseEditorTabs((IDatabaseEditor)part, tabList);
        }
        return tabList.toArray(new TabbedFolderInfo[0]);
    }

    private void makeStandardPropertiesTabs(List<TabbedFolderInfo> tabList) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("entity.editor.info.detach")) {
            tabList.add(new TabbedFolderInfo("standard", UINavigatorMessages.ui_properties_category_information, (DBPImage)DBIcon.TREE_INFO, UINavigatorMessages.ui_properties_category_information_tip, false, (ITabbedFolder)new TabbedFolderPageForm((IWorkbenchPart)this, this.pageControl, this.getEditorInput())));
        }
    }

    private void makeDatabaseEditorTabs(IDatabaseEditor part, List<TabbedFolderInfo> tabList) {
        List<EntityEditorDescriptor> editors;
        TabbedFolderPageProperties pageProperties;
        List<String> extraCategories;
        DBNDatabaseNode node;
        DBNDatabaseNode dBNDatabaseNode = node = part.getEditorInput() instanceof IDatabaseEditorInput ? ((IDatabaseEditorInput)part.getEditorInput()).getNavigatorNode() : null;
        if (node == null) {
            return;
        }
        DBSObject object = node.getObject();
        if (!node.getMeta().isStandaloneNode()) {
            DBRRunnableWithProgress tabsCollector = monitor -> ObjectPropertiesEditor.collectNavigatorTabs(monitor, part, (DBNNode)node, tabList);
            try {
                if (node.needsInitialization()) {
                    UIUtils.runInProgressService((DBRRunnableWithProgress)tabsCollector);
                } else {
                    tabsCollector.run((DBRProgressMonitor)new VoidProgressMonitor());
                }
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!(extraCategories = (pageProperties = new TabbedFolderPageProperties((IWorkbenchPart)this, this.getEditorInput())).getExtraCategories()).isEmpty()) {
            tabList.add(new TabbedFolderInfo("properties", String.valueOf(extraCategories.get(0)) + (extraCategories.size() == 1 ? "" : " / ... "), (DBPImage)DBIcon.TREE_INFO, String.join((CharSequence)", ", extraCategories), false, (ITabbedFolder)pageProperties));
        }
        if (!CommonUtils.isEmpty(editors = EntityEditorsRegistry.getInstance().getEntityEditors((DBPObject)object, this, null))) {
            for (EntityEditorDescriptor descriptor : editors) {
                if (descriptor.getType() != EntityEditorDescriptor.Type.folder) continue;
                tabList.add(new TabbedFolderInfo(descriptor.getId(), descriptor.getName(), descriptor.getIcon(), descriptor.getDescription(), descriptor.isEmbeddable(), (ITabbedFolder)new TabbedFolderPageEditor((IDatabaseEditor)this, descriptor)));
            }
        }
    }

    private static void collectNavigatorTabs(DBRProgressMonitor monitor, IDatabaseEditor part, DBNNode node, List<TabbedFolderInfo> tabList) {
        if ((!(node instanceof DBNDataSource) || ((DBNDataSource)node).getDataSourceContainer().isConnected()) && node != null) {
            DBNDatabaseNode databaseNode;
            List subNodes;
            try {
                DBNNode[] children = DBNUtils.getNodeChildrenFiltered((DBRProgressMonitor)monitor, (DBNNode)node, (boolean)false);
                if (node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getDataSourceContainer().getNavigatorSettings().isHideFolders() && children != null) {
                    LinkedHashMap<DBXTreeFolder, List> childMap = new LinkedHashMap<DBXTreeFolder, List>();
                    DBNNode[] dBNNodeArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBXTreeNode meta;
                        DBNNode child = dBNNodeArray[n2];
                        if (child instanceof DBNDatabaseNode && (meta = ((DBNDatabaseNode)child).getMeta()).getParent() instanceof DBXTreeFolder) {
                            List itemList = childMap.computeIfAbsent((DBXTreeFolder)meta.getParent(), dbxTreeFolder -> new ArrayList());
                            itemList.add(child);
                        }
                        ++n2;
                    }
                    for (Map.Entry fe : childMap.entrySet()) {
                        DBXTreeFolder folder = (DBXTreeFolder)fe.getKey();
                        String nodeName = folder.getChildrenTypeLabel(((DBNDatabaseNode)node).getObject().getDataSource(), null);
                        tabList.add(new TabbedFolderInfo(nodeName, nodeName, folder.getDefaultIcon(), folder.getDescription(), false, (ITabbedFolder)new TabbedFolderPageNode(part, node, (DBXTreeNode)folder)));
                    }
                }
                if (children != null) {
                    DBNNode[] folder = children;
                    int n = children.length;
                    int fe = 0;
                    while (fe < n) {
                        DBNNode child = folder[fe];
                        if (child instanceof DBNDatabaseFolder) {
                            DBNDatabaseFolder folder2 = (DBNDatabaseFolder)child;
                            monitor.subTask(String.valueOf(UINavigatorMessages.ui_properties_task_add_folder) + child.getNodeName() + "'");
                            tabList.add(new TabbedFolderInfo(folder2.getNodeName(), folder2.getNodeName(), folder2.getNodeIconDefault(), child.getNodeDescription(), false, (ITabbedFolder)new TabbedFolderPageNode(part, (DBNNode)folder2, null)));
                        }
                        ++fe;
                    }
                }
            }
            catch (DBException e) {
                log.error((Object)"Error initializing property tabs", (Throwable)e);
            }
            if (node instanceof DBNDatabaseNode && (subNodes = (databaseNode = (DBNDatabaseNode)node).getMeta().getChildren((DBNNode)databaseNode)) != null) {
                for (DBXTreeNode child : subNodes) {
                    if (!(child instanceof DBXTreeItem)) continue;
                    try {
                        if (((DBXTreeItem)child).isOptional() && !databaseNode.hasChildren(monitor, child)) continue;
                        monitor.subTask(String.valueOf(UINavigatorMessages.ui_properties_task_add_node) + node.getNodeName() + "'");
                        String nodeName = child.getChildrenTypeLabel(databaseNode.getObject().getDataSource(), null);
                        tabList.add(new TabbedFolderInfo(nodeName, nodeName, node.getNodeIconDefault(), node.getNodeDescription(), false, (ITabbedFolder)new TabbedFolderPageNode(part, node, child)));
                    }
                    catch (DBException e) {
                        log.debug((Object)"Can't add child items tab", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public DBNNode getRootNode() {
        ITabbedFolder activeFolder;
        ITabbedFolder iTabbedFolder = activeFolder = this.folderComposite == null ? null : this.folderComposite.getActiveFolder();
        if (activeFolder instanceof INavigatorModelView) {
            return ((INavigatorModelView)activeFolder).getRootNode();
        }
        return null;
    }

    @Override
    @Nullable
    public Viewer getNavigatorViewer() {
        ITabbedFolder activeFolder;
        ITabbedFolder iTabbedFolder = activeFolder = this.folderComposite == null ? null : this.folderComposite.getActiveFolder();
        if (activeFolder instanceof INavigatorModelView) {
            return ((INavigatorModelView)activeFolder).getNavigatorViewer();
        }
        return null;
    }

    @Override
    public boolean isEntityContainer(DBSObjectContainer object) {
        return false;
    }

    @Override
    public boolean isRelationalObject(DBSObject object) {
        DBPDataSource dataSource = object.getDataSource();
        return dataSource != null && dataSource.getInfo().supportsReferentialIntegrity();
    }

    public void runPostSaveCommands(Map<String, Object> context) {
        for (ISaveablePart sp : this.nestedSaveable) {
            IEditorPart editor;
            if (!(sp instanceof TabbedFolderPageEditor) || !((editor = ((TabbedFolderPageEditor)sp).getEditor()) instanceof IDatabasePostSaveProcessor)) continue;
            ((IDatabasePostSaveProcessor)editor).runPostSaveCommands(context);
        }
    }

    private void createPropertyRefreshAction(IContributionManager contributionManager) {
        DBSObject databaseObject = this.getDatabaseObject();
        if (!databaseObject.getDataSource().getContainer().getPreferenceStore().getBoolean("database.props.expensive")) {
            PropertyCollector collector = new PropertyCollector((Object)databaseObject, false);
            collector.setEnableFilters(false);
            collector.collectProperties();
            boolean hasExpensive = false;
            DBPPropertyDescriptor[] dBPPropertyDescriptorArray = collector.getProperties();
            int n = dBPPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
                if (prop instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)prop).isExpensive()) {
                    hasExpensive = true;
                    break;
                }
                ++n2;
            }
            if (hasExpensive) {
                contributionManager.add((IAction)new ReadExpensivePropsAction(databaseObject));
            }
        }
    }

    private class ReadExpensivePropsAction
    extends Action {
        private final DBSObject databaseObject;

        ReadExpensivePropsAction(DBSObject databaseObject) {
            super("Read row count and other expensive properties", 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_REFRESH));
            this.databaseObject = databaseObject;
        }

        public boolean isChecked() {
            return DataSourcePropertyFilter.isExpensivePropertiesReadEnabledFor((DBSObject)this.databaseObject);
        }

        public void run() {
            DataSourcePropertyFilter.readExpensivePropertiesFor((DBSObject)this.databaseObject, (!this.isChecked() ? 1 : 0) != 0);
            DBUtils.fireObjectUpdate((DBSObject)this.databaseObject, (boolean)true);
            MultiPageEditorPart mainEditor = ((MultiPageEditorSite)ObjectPropertiesEditor.this.getSite()).getMultiPageEditor();
            if (mainEditor instanceof IRefreshablePart) {
                ((IRefreshablePart)mainEditor).refreshPart((Object)this, true);
            }
        }
    }
}

