/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class VariablesHintLabel {
    private final String[][] variables;
    private IVariableResolver resolver;
    private CLabel infoLabel;

    public VariablesHintLabel(Composite parent, String hintLabel, String hintTitle, String[][] vars) {
        this(parent, hintLabel, hintTitle, vars, true);
    }

    public VariablesHintLabel(final Composite parent, String hintLabel, final String hintTitle, String[][] vars, boolean stretch) {
        this.variables = vars;
        final String varsText = GeneralUtils.generateVariablesLegend((String[][])vars);
        this.infoLabel = UIUtils.createInfoLabel(parent, hintLabel);
        Layout layout = parent.getLayout();
        GridData gd = new GridData(768);
        if (stretch && layout instanceof GridLayout) {
            gd.horizontalSpan = ((GridLayout)layout).numColumns;
        }
        this.infoLabel.setLayoutData((Object)gd);
        this.infoLabel.setCursor(this.infoLabel.getDisplay().getSystemCursor(21));
        this.infoLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (VariablesHintLabel.this.resolver != null) {
                    VariableListDialog dialog = new VariableListDialog(parent.getShell(), hintTitle);
                    dialog.open();
                } else {
                    EditTextDialog dialog = new EditTextDialog(parent.getShell(), hintTitle, varsText, true);
                    dialog.setMonospaceFont(true);
                    dialog.setAutoSize(true);
                    dialog.open();
                }
            }
        });
        this.infoLabel.setToolTipText(varsText);
    }

    public CLabel getInfoLabel() {
        return this.infoLabel;
    }

    public void setResolver(IVariableResolver resolver) {
        this.resolver = resolver;
    }

    class VariableListDialog
    extends BaseDialog {
        VariableListDialog(Shell parentShell, String title) {
            super(parentShell, title, null);
        }

        @Override
        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            Table table = new Table(composite, 67584);
            table.setHeaderVisible(true);
            table.setLayoutData((Object)new GridData(1808));
            UIUtils.createTableColumn(table, 16384, "Variable");
            UIUtils.createTableColumn(table, 16384, "Description");
            UIUtils.createTableColumn(table, 16384, "Value");
            String[][] stringArray = VariablesHintLabel.this.variables;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] var = stringArray[n2];
                String varName = var[0];
                boolean isSecure = "password".equals(varName);
                TableItem item = new TableItem(table, 0);
                item.setText(0, GeneralUtils.variablePattern((String)varName));
                item.setText(1, var[1]);
                item.setText(2, isSecure ? "********" : CommonUtils.notEmpty((String)VariablesHintLabel.this.resolver.get(varName)));
                ++n2;
            }
            UIUtils.packColumns(table);
            UIUtils.setControlContextMenu((Control)table, manager -> UIUtils.fillDefaultTableContextMenu((IContributionManager)manager, table));
            new TableEditor(table);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }
}

