/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IDocumentDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterSourceCode
extends StreamExporterAbstract
implements IDocumentDataExporter {
    private static final String PROP_FORMAT_DATE_ISO = "formatDateISOPHP";
    private static final String PROP_LANGUAGE = "language";
    private DBDAttributeBinding[] columns;
    private int rowNum = 0;
    private boolean formatDateISO = true;
    private ProgramLanguages language;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        Map<Object, Object> properties = site.getProperties();
        this.formatDateISO = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_FORMAT_DATE_ISO), (boolean)true);
        this.language = ProgramLanguages.fromValue(CommonUtils.toString((Object)properties.get(PROP_LANGUAGE)));
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        String tableName = this.getSite().getSource().getName();
        PrintWriter out = this.getWriter();
        out.write("<?php\n");
        out.write("$" + tableName + " = ");
        if (this.language == ProgramLanguages.PHP_VERSION_LESS_5_and_4) {
            out.write("array(\n");
        } else {
            out.write("[\n");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        out = this.getWriter();
        if (this.rowNum > 0) {
            out.write(",\n");
        }
        ++this.rowNum;
        if (this.language == ProgramLanguages.PHP_VERSION_LESS_5_and_4) {
            out.write("\tarray(\n");
        } else {
            out.write("\t[\n");
        }
        i = 0;
        while (i < this.columns.length) {
            column = this.columns[i];
            columnName = column.getLabel();
            if (CommonUtils.isEmpty((String)columnName)) {
                columnName = column.getName();
            }
            out.write("\t\t\"" + JSONUtils.escapeJsonString((String)columnName) + "\" => ");
            cellValue = row[column.getOrdinalPosition()];
            if (DBUtils.isNullValue((Object)cellValue)) {
                this.writeTextCell(null);
            } else if (cellValue instanceof DBDContent) {
                content = (DBDContent)cellValue;
                try {
                    cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) ** GOTO lbl58
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        var11_11 = null;
                        var12_13 = null;
                        try {
                            in = cs.getContentReader();
                            try {
                                out.write("\"");
                                this.writeCellValue(in);
                                out.write("\"");
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                        }
                        catch (Throwable var12_14) {
                            if (var11_11 == null) {
                                var11_11 = var12_14;
                            } else if (var11_11 != var12_14) {
                                var11_11.addSuppressed(var12_14);
                            }
                            throw var11_11;
                        }
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    content.release();
                }
            } else if (cellValue instanceof Number || cellValue instanceof Boolean) {
                out.write(cellValue.toString());
            } else if (cellValue instanceof Date && this.formatDateISO) {
                this.writeTextCell(JSONUtils.formatDate((Date)((Date)cellValue)));
            } else {
                this.writeTextCell(super.getValueDisplayString(column, cellValue));
            }
lbl58:
            // 7 sources

            if (i < this.columns.length - 1) {
                out.write(",");
            }
            out.write("\n");
            ++i;
        }
        if (this.language == ProgramLanguages.PHP_VERSION_LESS_5_and_4) {
            out.write("\t)");
        } else {
            out.write("\t]");
        }
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
        PrintWriter out = this.getWriter();
        if (this.language == ProgramLanguages.PHP_VERSION_LESS_5_and_4) {
            out.write("\n);");
        } else {
            out.write("\n];");
        }
        out.write("\n?>");
    }

    private void writeTextCell(@Nullable String value) {
        if (value != null) {
            this.getWriter().write("\"" + JSONUtils.escapeJsonString((String)value) + "\"");
        } else {
            this.getWriter().write("null");
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            this.getWriter().write(JSONUtils.escapeJsonString((String)new String(buffer, 0, count)));
        }
    }

    static enum ProgramLanguages {
        PHP_VERSION_LESS_5_and_4("php version less 5.4"),
        PHP_VERSION_AT_LEAST_5_AND_4("php version at least 5.4");

        private final String value;

        private ProgramLanguages(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ProgramLanguages fromValue(String v) {
            ProgramLanguages[] programLanguagesArray = ProgramLanguages.values();
            int n = programLanguagesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProgramLanguages s = programLanguagesArray[n2];
                if (s.value.equals(v)) {
                    return s;
                }
                ++n2;
            }
            return PHP_VERSION_LESS_5_and_4;
        }
    }
}

