/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.stream;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.utils.CommonUtils;

public class StreamProducerPagePreview
extends ActiveWizardPage<DataTransferWizard> {
    private static final Log log = Log.getLog(StreamProducerPagePreview.class);
    private List<DataTransferPipe> pipeList = new ArrayList<DataTransferPipe>();
    private Table tableList;
    private Table mappingsTable;
    private Table previewTable;
    private DBSObject currentObject;
    private boolean activated;

    public StreamProducerPagePreview() {
        super(DTMessages.data_transfer_wizard_page_preview_name);
        this.setTitle(DTMessages.data_transfer_wizard_page_preview_title);
        this.setDescription(DTMessages.data_transfer_wizard_page_preview_description);
        this.setPageComplete(false);
    }

    private StreamProducerSettings getProducerSettings() {
        return ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
    }

    private StreamProducerSettings.EntityMapping getCurrentEntityMappings() {
        DBSEntity entity = (DBSEntity)this.currentObject;
        StreamProducerSettings settings = this.getProducerSettings();
        return settings.getEntityMapping(entity);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        SashForm previewSash = new SashForm(composite, 512);
        previewSash.setLayoutData((Object)new GridData(1808));
        Composite mappingGroup = new Composite((Composite)previewSash, 0);
        mappingGroup.setLayoutData((Object)new GridData(1808));
        mappingGroup.setLayout((Layout)new GridLayout(1, false));
        UIUtils.createControlLabel((Composite)mappingGroup, (String)DTMessages.data_transfer_wizard_settings_group_column_mappings);
        SashForm mapSash = new SashForm(mappingGroup, 256);
        mapSash.setLayoutData((Object)new GridData(1808));
        Composite tableComposite = UIUtils.createPlaceholder((Composite)mapSash, (int)1);
        tableComposite.setLayoutData((Object)new GridData(1040));
        UIUtils.createControlLabel((Composite)tableComposite, (String)DTMessages.data_transfer_wizard_settings_group_preview_table);
        this.tableList = new Table(tableComposite, 2052);
        this.tableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamProducerPagePreview.this.loadEntityMappingPreview();
            }
        });
        this.tableList.setLayoutData((Object)new GridData(1808));
        Composite mappingComposite = UIUtils.createPlaceholder((Composite)mapSash, (int)1);
        mappingComposite.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)mappingComposite, (String)DTMessages.data_transfer_wizard_settings_group_preview_columns);
        this.mappingsTable = new Table(mappingComposite, 67588);
        this.mappingsTable.setLayoutData((Object)new GridData(1808));
        this.mappingsTable.setHeaderVisible(true);
        this.mappingsTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.mappingsTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_target);
        UIUtils.createTableColumn((Table)this.mappingsTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_source);
        UIUtils.createTableColumn((Table)this.mappingsTable, (int)16384, (String)DTMessages.data_transfer_wizard_settings_column_mapping_type);
        new CustomTableEditor(this.mappingsTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                StreamProducerSettings.AttributeMapping am = (StreamProducerSettings.AttributeMapping)item.getData();
                StreamProducerSettings.EntityMapping entityMappings = StreamProducerPagePreview.this.getCurrentEntityMappings();
                if (index == 1) {
                    if (am.getMappingType() == StreamProducerSettings.AttributeMapping.MappingType.DEFAULT_VALUE) {
                        Text textValue = new Text((Composite)table, 2048);
                        textValue.setText(CommonUtils.notEmpty((String)am.getDefaultValue()));
                        return textValue;
                    }
                    CCombo sourceCombo = new CCombo((Composite)table, 12);
                    sourceCombo.add("");
                    for (StreamDataImporterColumnInfo ci : entityMappings.getStreamColumns()) {
                        String columnName = ci.getColumnName();
                        if (CommonUtils.isEmpty((String)columnName)) {
                            columnName = String.valueOf(ci.getColumnIndex());
                        }
                        sourceCombo.add(columnName);
                    }
                    if (!CommonUtils.isEmpty((String)am.getSourceAttributeName())) {
                        sourceCombo.setText(am.getSourceAttributeName());
                    } else if (am.getSourceAttributeIndex() >= 0) {
                        sourceCombo.setText(String.valueOf(am.getSourceAttributeIndex()));
                    } else {
                        sourceCombo.select(0);
                    }
                    return sourceCombo;
                }
                if (index == 2) {
                    CCombo mappingCombo = new CCombo((Composite)table, 12);
                    StreamProducerSettings.AttributeMapping.MappingType[] mappingTypeArray = StreamProducerSettings.AttributeMapping.MappingType.values();
                    int n = mappingTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StreamProducerSettings.AttributeMapping.MappingType mapping = mappingTypeArray[n2];
                        if (mapping != StreamProducerSettings.AttributeMapping.MappingType.NONE) {
                            mappingCombo.add(mapping.getTitle());
                        }
                        ++n2;
                    }
                    if (am.getMappingType() == StreamProducerSettings.AttributeMapping.MappingType.NONE) {
                        mappingCombo.setText(StreamProducerSettings.AttributeMapping.MappingType.SKIP.getTitle());
                    } else {
                        mappingCombo.setText(am.getMappingType().getTitle());
                    }
                    return mappingCombo;
                }
                return null;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                StreamProducerSettings.AttributeMapping am = (StreamProducerSettings.AttributeMapping)item.getData();
                if (index == 1) {
                    if (am.getMappingType() == StreamProducerSettings.AttributeMapping.MappingType.DEFAULT_VALUE) {
                        String newValue = ((Text)control).getText();
                        if (CommonUtils.equalObjects((Object)newValue, (Object)am.getDefaultValue())) {
                            return;
                        }
                        am.setDefaultValue(newValue);
                    } else {
                        CCombo sourceCombo = (CCombo)control;
                        if (sourceCombo.getSelectionIndex() == 0) {
                            if (am.getMappingType() == StreamProducerSettings.AttributeMapping.MappingType.SKIP) {
                                return;
                            }
                            am.setSourceAttributeIndex(-1);
                            am.setSourceAttributeName(null);
                            am.setMappingType(StreamProducerSettings.AttributeMapping.MappingType.SKIP);
                        } else {
                            String srcAttrName = sourceCombo.getText();
                            StreamDataImporterColumnInfo streamColumn = StreamProducerPagePreview.this.getCurrentEntityMappings().getStreamColumn(srcAttrName);
                            if (streamColumn == null) {
                                int selectionIndex = sourceCombo.getSelectionIndex();
                                if (selectionIndex >= 0) {
                                    streamColumn = (StreamDataImporterColumnInfo)StreamProducerPagePreview.this.getCurrentEntityMappings().getStreamColumns().get(selectionIndex - 1);
                                } else {
                                    return;
                                }
                            }
                            if (CommonUtils.equalObjects((Object)am.getSourceAttributeName(), (Object)streamColumn.getColumnName()) && am.getSourceAttributeIndex() == streamColumn.getColumnIndex()) {
                                return;
                            }
                            am.setSourceAttributeName(streamColumn.getColumnName());
                            am.setSourceAttributeIndex(streamColumn.getColumnIndex());
                            am.setMappingType(StreamProducerSettings.AttributeMapping.MappingType.IMPORT);
                        }
                    }
                } else if (index == 2) {
                    CCombo mappingCombo = (CCombo)control;
                    StreamProducerSettings.AttributeMapping.MappingType newMapping = null;
                    String newTypeTitle = mappingCombo.getText();
                    StreamProducerSettings.AttributeMapping.MappingType[] mappingTypeArray = StreamProducerSettings.AttributeMapping.MappingType.values();
                    int n = mappingTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StreamProducerSettings.AttributeMapping.MappingType mapping = mappingTypeArray[n2];
                        if (newTypeTitle.equals(mapping.getTitle())) {
                            newMapping = mapping;
                            break;
                        }
                        ++n2;
                    }
                    if (newMapping != null && newMapping != am.getMappingType()) {
                        am.setMappingType(newMapping);
                    } else {
                        return;
                    }
                }
                UIUtils.asyncExec(() -> {
                    StreamProducerPagePreview.this.updateAttributeMappingItem(am, item);
                    StreamProducerPagePreview.this.updatePageCompletion();
                    StreamProducerPagePreview.this.refreshPreviewTable(StreamProducerPagePreview.this.getCurrentEntityMappings());
                });
            }
        };
        mapSash.setWeights(new int[]{300, 700});
        Composite previewGroup = new Composite((Composite)previewSash, 0);
        previewGroup.setLayoutData((Object)new GridData(1808));
        previewGroup.setLayout((Layout)new GridLayout(1, false));
        UIUtils.createControlLabel((Composite)previewGroup, (String)DTMessages.data_transfer_wizard_settings_group_preview);
        this.previewTable = new Table(previewGroup, 67588);
        this.previewTable.setLayoutData((Object)new GridData(1808));
        this.previewTable.setHeaderVisible(true);
        this.previewTable.setLinesVisible(true);
        this.setControl((Control)composite);
        this.determinePageCompletion();
    }

    public void activatePage() {
        this.activated = true;
        this.tableList.removeAll();
        this.pipeList.clear();
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            if (pipe.getConsumer() == null || pipe.getConsumer().getDatabaseObject() == null) continue;
            this.pipeList.add(pipe);
            TableItem tableItem = new TableItem(this.tableList, 0);
            tableItem.setData((Object)pipe);
            tableItem.setImage(DBeaverIcons.getImage((DBPImage)((DataTransferWizard)this.getWizard()).getSettings().getConsumer().getIcon()));
            tableItem.setText(pipe.getConsumer().getObjectName());
            if (this.currentObject == null || this.currentObject != pipe.getConsumer().getDatabaseObject()) continue;
            this.tableList.select(this.tableList.getItemCount() - 1);
        }
        if (this.tableList.getSelectionIndex() < 0) {
            this.tableList.select(0);
        }
        this.currentObject = null;
        this.loadEntityMappingPreview();
        this.updatePageCompletion();
    }

    private void loadEntityMappingPreview() {
        int selectionIndex = this.tableList.getSelectionIndex();
        if (selectionIndex < 0) {
            return;
        }
        TableItem tableItem = this.tableList.getItem(selectionIndex);
        String objectName = tableItem.getText();
        DataTransferPipe pipe = (DataTransferPipe)tableItem.getData();
        if (pipe.getConsumer() != null && objectName.equals(pipe.getConsumer().getObjectName())) {
            if (this.currentObject == pipe.getConsumer().getDatabaseObject()) {
                return;
            }
            this.currentObject = pipe.getConsumer().getDatabaseObject();
        }
        this.previewTable.removeAll();
        TableColumn[] tableColumnArray = this.previewTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        this.mappingsTable.removeAll();
        if (this.currentObject == null) {
            log.error((Object)("Can't find object '" + objectName + "'"));
            return;
        }
        if (!(this.currentObject instanceof DBSEntity)) {
            log.error((Object)("Object '" + objectName + "' is not an entity. Can't map"));
            return;
        }
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
        DBSEntity entity = (DBSEntity)this.currentObject;
        StreamProducerSettings.EntityMapping entityMapping = this.getCurrentEntityMappings();
        DataTransferPipe currentPipe = this.getCurrentPipe();
        StreamTransferProducer currentProducer = (StreamTransferProducer)currentPipe.getProducer();
        Throwable error = null;
        try {
            ((DataTransferWizard)this.getWizard()).getContainer().run(true, true, mon -> {
                IDataTransferProcessor importer = processor.getInstance();
                DefaultProgressMonitor monitor = new DefaultProgressMonitor(mon);
                monitor.beginTask("Load mappings", 4);
                try {
                    monitor.subTask("Load attributes form target object");
                    for (DBSEntityAttribute attr : CommonUtils.safeCollection((Collection)entity.getAttributes((DBRProgressMonitor)monitor))) {
                        if (DBUtils.isPseudoAttribute((DBSAttributeBase)attr) || DBUtils.isHiddenObject((Object)attr)) continue;
                        entityMapping.getAttributeMapping(attr);
                    }
                    monitor.worked(1);
                    monitor.subTask("Update mappings from stream");
                    this.getProducerSettings().updateMappingsFromStream(((DataTransferWizard)this.getWizard()).getSettings());
                    monitor.worked(1);
                    UIUtils.syncExec(() -> this.updateAttributeMappings(entityMapping));
                    monitor.worked(1);
                    monitor.subTask("Load import preview");
                    if (importer instanceof IStreamDataImporter) {
                        this.loadImportPreview((DBRProgressMonitor)monitor, (IStreamDataImporter)importer, entity, currentProducer);
                    }
                    monitor.worked(1);
                    monitor.done();
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException interruptedException) {}
        this.determinePageCompletion();
        Throwable finalError = error;
        UIUtils.asyncExec(() -> {
            UIUtils.packColumns((Table)this.mappingsTable, (boolean)true);
            UIUtils.packColumns((Table)this.previewTable, (boolean)false);
            if (finalError != null) {
                log.error((Object)finalError);
                DBWorkbench.getPlatformUI().showError(DTUIMessages.stream_producer_page_preview_title_load_entity_meta, DTUIMessages.stream_producer_page_preview_message_entity_attributes, finalError);
            }
        });
    }

    private void refreshPreviewTable(StreamProducerSettings.EntityMapping entityMapping) {
        this.previewTable.removeAll();
        TableColumn[] tableColumnArray = this.previewTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        for (StreamProducerSettings.AttributeMapping am : entityMapping.getAttributeMappings()) {
            if (!am.isValuable()) continue;
            UIUtils.createTableColumn((Table)this.previewTable, (int)16384, (String)am.getTargetAttributeName());
        }
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
        DBSEntity entity = (DBSEntity)this.currentObject;
        StreamTransferProducer currentProducer = (StreamTransferProducer)this.getCurrentPipe().getProducer();
        Throwable error = null;
        try {
            ((DataTransferWizard)this.getWizard()).getContainer().run(true, true, mon -> {
                try {
                    IDataTransferProcessor importer = processor.getInstance();
                    DefaultProgressMonitor monitor = new DefaultProgressMonitor(mon);
                    monitor.beginTask("Load preview", 1);
                    monitor.subTask("Load import preview");
                    if (importer instanceof IStreamDataImporter) {
                        this.loadImportPreview((DBRProgressMonitor)monitor, (IStreamDataImporter)importer, entity, currentProducer);
                    }
                    monitor.worked(1);
                    monitor.done();
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException interruptedException) {}
        Throwable finalError = error;
        UIUtils.asyncExec(() -> {
            UIUtils.packColumns((Table)this.previewTable, (boolean)false);
            if (finalError != null) {
                DBWorkbench.getPlatformUI().showError(DTUIMessages.stream_producer_page_preview_title_preview_data, DTUIMessages.stream_producer_page_preview_message_preview_data, finalError);
            }
        });
    }

    private void updateAttributeMappings(StreamProducerSettings.EntityMapping entityMapping) {
        for (StreamProducerSettings.AttributeMapping am : entityMapping.getAttributeMappings()) {
            TableItem mappingItem = new TableItem(this.mappingsTable, 0);
            mappingItem.setData((Object)am);
            mappingItem.setImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)am.getTargetAttribute())));
            this.updateAttributeMappingItem(am, mappingItem);
            if (!am.isValuable()) continue;
            UIUtils.createTableColumn((Table)this.previewTable, (int)16384, (String)am.getTargetAttributeName());
        }
    }

    private void updateAttributeMappingItem(StreamProducerSettings.AttributeMapping am, TableItem mappingItem) {
        mappingItem.setText(0, am.getTargetAttributeName());
        StreamProducerSettings.AttributeMapping.MappingType mappingType = am.getMappingType();
        String sourceName = "";
        switch (mappingType) {
            case IMPORT: {
                if (!CommonUtils.isEmpty((String)am.getSourceAttributeName())) {
                    sourceName = am.getSourceAttributeName();
                    break;
                }
                if (am.getSourceAttributeIndex() < 0) break;
                sourceName = String.valueOf(am.getSourceAttributeIndex());
                break;
            }
            case DEFAULT_VALUE: {
                sourceName = CommonUtils.notEmpty((String)am.getDefaultValue());
                break;
            }
            case SKIP: {
                sourceName = "-";
            }
        }
        mappingItem.setText(1, sourceName);
        mappingItem.setText(2, mappingType.getTitle());
    }

    public DataTransferPipe getCurrentPipe() {
        return this.pipeList.get(this.tableList.getSelectionIndex());
    }

    private void loadImportPreview(DBRProgressMonitor monitor, IStreamDataImporter importer, DBSEntity entity, StreamTransferProducer currentProducer) throws DBException {
        StreamProducerSettings settings = this.getProducerSettings();
        PreviewConsumer previewConsumer = new PreviewConsumer(settings, entity);
        settings.setProcessorProperties(((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        settings.setMaxRows(10);
        try {
            currentProducer.transferData(monitor, (IDataTransferConsumer)previewConsumer, (IDataTransferProcessor)importer, settings, null);
        }
        finally {
            previewConsumer.close();
            settings.setMaxRows(-1);
        }
        List<Object[]> rows = previewConsumer.getRows();
        ArrayList<String[]> strRows = new ArrayList<String[]>(rows.size());
        Throwable throwable = null;
        Object var10_12 = null;
        try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)previewConsumer.getEntityMapping().getEntity(), (String)"Generate preview values");){
            List attributeMappings = previewConsumer.getEntityMapping().getValuableAttributeMappings();
            for (Object[] row : rows) {
                String[] strRow = new String[row.length];
                int i = 0;
                while (i < attributeMappings.size()) {
                    String valueStr;
                    StreamProducerSettings.AttributeMapping attr = (StreamProducerSettings.AttributeMapping)attributeMappings.get(i);
                    Object srcValue = row[i];
                    Object value = attr.getTargetValueHandler().getValueFromObject(session, (DBSTypedObject)attr.getTargetAttribute(), srcValue, false, this.activated);
                    strRow[i] = valueStr = attr.getTargetValueHandler().getValueDisplayString((DBSTypedObject)attr.getTargetAttribute(), value, DBDDisplayFormat.UI);
                    ++i;
                }
                strRows.add(strRow);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        UIUtils.asyncExec(() -> {
            this.previewTable.removeAll();
            for (String[] row : strRows) {
                TableItem previewItem = new TableItem(this.previewTable, 0);
                int i = 0;
                while (i < row.length) {
                    if (row[i] != null) {
                        previewItem.setText(i, row[i]);
                    }
                    ++i;
                }
            }
        });
    }

    public void deactivatePage() {
        super.deactivatePage();
        StreamProducerSettings settings = this.getProducerSettings();
        settings.setProcessorProperties(((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
    }

    protected boolean determinePageCompletion() {
        if (!this.activated) {
            return false;
        }
        StreamProducerSettings settings = this.getProducerSettings();
        List dataPipes = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes();
        if (dataPipes.isEmpty()) {
            this.setErrorMessage(DTUIMessages.stream_producer_page_preview_error_message_no_entities_specified);
            return false;
        }
        for (DataTransferPipe pipe : dataPipes) {
            DBSObject databaseObject = pipe.getConsumer().getDatabaseObject();
            if (!(databaseObject instanceof DBSEntity)) {
                this.setErrorMessage(DTUIMessages.stream_producer_page_preview_error_message_wrong_input_object);
                return false;
            }
            StreamProducerSettings.EntityMapping entityMapping = settings.getEntityMapping((DBSEntity)databaseObject);
            if (entityMapping.isComplete()) continue;
            this.setErrorMessage(DTUIMessages.stream_producer_page_preview_error_message_set_mappings_for_all_columns);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private static class PreviewConsumer
    implements IDataTransferConsumer {
        private List<Object[]> rows = new ArrayList<Object[]>();
        private StreamProducerSettings settings;
        private DBSEntity sampleObject;
        private final StreamProducerSettings.EntityMapping entityMapping;
        private DBCResultSetMetaData meta;
        private final List<StreamProducerSettings.AttributeMapping> attributes;

        public PreviewConsumer(StreamProducerSettings settings, DBSEntity sampleObject) {
            this.settings = settings;
            this.sampleObject = sampleObject;
            this.entityMapping = this.settings.getEntityMapping(sampleObject);
            this.attributes = this.entityMapping.getValuableAttributeMappings();
        }

        public StreamProducerSettings.EntityMapping getEntityMapping() {
            return this.entityMapping;
        }

        public List<Object[]> getRows() {
            return this.rows;
        }

        public void initTransfer(DBSObject sourceObject, IDataTransferSettings settings, IDataTransferConsumer.TransferParameters parameters, IDataTransferProcessor processor, Map processorProperties) {
        }

        public void startTransfer(DBRProgressMonitor monitor) throws DBException {
        }

        public void finishTransfer(DBRProgressMonitor monitor, boolean last) {
        }

        public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
            this.meta = resultSet.getMeta();
            if (this.meta.getAttributes().size() != this.entityMapping.getValuableAttributeMappings().size()) {
                throw new DBCException("Corrupted stream source metadata. Attribute number (" + this.meta.getAttributes().size() + ") doesn't match target entity attribute number (" + this.entityMapping.getAttributeMappings().size() + ")");
            }
        }

        public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
            Object[] row = new Object[this.attributes.size()];
            int i = 0;
            while (i < this.attributes.size()) {
                switch (this.attributes.get(i).getMappingType()) {
                    case DEFAULT_VALUE: {
                        row[i] = this.attributes.get(i).getDefaultValue();
                        break;
                    }
                    default: {
                        row[i] = this.attributes.get(i).getMappingType() != StreamProducerSettings.AttributeMapping.MappingType.IMPORT ? null : resultSet.getAttributeValue(i);
                    }
                }
                ++i;
            }
            this.rows.add(row);
        }

        public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        }

        public void close() {
        }

        public DBSObject getDatabaseObject() {
            return this.sampleObject;
        }

        public String getObjectName() {
            return DBUtils.getObjectFullName((DBPNamedObject)this.sampleObject, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }

        public DBPImage getObjectIcon() {
            return null;
        }

        public String getObjectContainerName() {
            return "N/A";
        }

        public DBPImage getObjectContainerIcon() {
            return UIIcon.SQL_PREVIEW;
        }
    }
}

