/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableCheckConstraint;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class MySQLCheckConstraintManager
extends SQLConstraintManager<MySQLTableCheckConstraint, MySQLTable> {
    protected MySQLTableCheckConstraint createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new MySQLTableCheckConstraint((MySQLTable)container, "NewConstraint", null, DBSEntityConstraintType.CHECK, false);
    }

    public DBSObjectCache<MySQLCatalog, MySQLTableCheckConstraint> getObjectsCache(MySQLTableCheckConstraint object) {
        return ((MySQLCatalog)((MySQLTable)object.getTable()).getContainer()).getCheckConstraintCache();
    }

    protected void appendConstraintDefinition(StringBuilder decl, DBECommandAbstract<MySQLTableCheckConstraint> command) {
        if (((MySQLTableCheckConstraint)command.getObject()).getConstraintType() == DBSEntityConstraintType.CHECK) {
            decl.append(" (").append(((MySQLTableCheckConstraint)command.getObject()).getClause()).append(")");
        } else {
            super.appendConstraintDefinition(decl, command);
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        MySQLTableCheckConstraint constraint = (MySQLTableCheckConstraint)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_constraint, "ALTER TABLE " + ((MySQLTable)constraint.getParentObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " DROP CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)constraint)));
    }
}

