/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.util.Locale;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.data.DBDCellValue;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class DatabaseProducerPageExtractSettings
extends ActiveWizardPage<DataTransferWizard> {
    private static final int EXTRACT_TYPE_SINGLE_QUERY = 0;
    private static final int EXTRACT_TYPE_SEGMENTS = 1;
    private Text threadsNumText;
    private Combo rowsExtractType;
    private Label segmentSizeLabel;
    private Text segmentSizeText;
    private Button newConnectionCheckbox;
    private Button rowCountCheckbox;
    private Button selectedColumnsOnlyCheckbox;
    private Button selectedRowsOnlyCheckbox;
    private Text fetchSizeText;

    public DatabaseProducerPageExtractSettings() {
        super(DTUIMessages.database_producer_page_extract_settings_name_and_title);
        this.setTitle(DTUIMessages.database_producer_page_extract_settings_name_and_title);
        this.setDescription(DTUIMessages.database_producer_page_extract_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        boolean hasSelection;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final DatabaseProducerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseProducerSettings.class);
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)DTMessages.data_transfer_wizard_output_group_progress, (int)4, (int)768, (int)0);
        Label threadsNumLabel = UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_max_threads);
        this.threadsNumText = new Text((Composite)generalSettings, 2048);
        this.threadsNumText.setToolTipText(DTUIMessages.database_producer_page_extract_settings_threads_num_text_tooltip);
        this.threadsNumText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        this.threadsNumText.addModifyListener(e -> {
            try {
                ((DataTransferWizard)this.getWizard()).getSettings().setMaxJobCount(Integer.parseInt(this.threadsNumText.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        });
        if (((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().size() < 2) {
            threadsNumLabel.setEnabled(false);
            this.threadsNumText.setEnabled(false);
        }
        this.threadsNumText.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_extract_type);
        this.rowsExtractType = new Combo((Composite)generalSettings, 12);
        this.rowsExtractType.setItems(new String[]{DTMessages.data_transfer_wizard_output_combo_extract_type_item_single_query, DTMessages.data_transfer_wizard_output_combo_extract_type_item_by_segments});
        this.rowsExtractType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (DatabaseProducerPageExtractSettings.this.rowsExtractType.getSelectionIndex()) {
                    case 1: {
                        settings.setExtractType(DatabaseProducerSettings.ExtractType.SEGMENTS);
                        break;
                    }
                    case 0: {
                        settings.setExtractType(DatabaseProducerSettings.ExtractType.SINGLE_QUERY);
                    }
                }
                DatabaseProducerPageExtractSettings.this.updatePageCompletion();
            }
        });
        this.segmentSizeLabel = UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_segment_size);
        this.segmentSizeLabel.setLayoutData((Object)new GridData(128, 2, false, false, 1, 1));
        this.segmentSizeText = new Text((Composite)generalSettings, 2048);
        this.segmentSizeText.addModifyListener(e -> {
            try {
                settings.setSegmentSize(Integer.parseInt(this.segmentSizeText.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        });
        this.segmentSizeText.setLayoutData((Object)new GridData(128, 2, false, false, 1, 1));
        this.newConnectionCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_new_connection, (String)DTUIMessages.database_producer_page_extract_settings_new_connection_checkbox_tooltip, (boolean)true, (int)4);
        this.newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(DatabaseProducerPageExtractSettings.this.newConnectionCheckbox.getSelection());
            }
        });
        this.rowCountCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_select_row_count, (String)DTUIMessages.database_producer_page_extract_settings_row_count_checkbox_tooltip, (boolean)true, (int)4);
        this.rowCountCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setQueryRowCount(DatabaseProducerPageExtractSettings.this.rowCountCheckbox.getSelection());
            }
        });
        this.fetchSizeText = UIUtils.createLabelText((Composite)generalSettings, (String)DTUIMessages.database_producer_page_extract_settings_text_fetch_size_label, (String)"", (int)2048);
        this.fetchSizeText.setToolTipText(DTUIMessages.database_producer_page_extract_settings_text_fetch_size_tooltip);
        this.fetchSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        this.fetchSizeText.addModifyListener(e -> settings.setFetchSize(Integer.parseInt(this.fetchSizeText.getText())));
        IStructuredSelection curSelection = ((DataTransferWizard)this.getWizard()).getCurrentSelection();
        boolean bl = hasSelection = curSelection != null && !curSelection.isEmpty() && curSelection.getFirstElement() instanceof DBDCellValue;
        if (hasSelection) {
            this.selectedColumnsOnlyCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_selected_columns_only, null, (boolean)false, (int)4);
            this.selectedColumnsOnlyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    settings.setSelectedColumnsOnly(DatabaseProducerPageExtractSettings.this.selectedColumnsOnlyCheckbox.getSelection());
                }
            });
            this.selectedRowsOnlyCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_selected_rows_only, null, (boolean)false, (int)4);
            this.selectedRowsOnlyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    settings.setSelectedRowsOnly(DatabaseProducerPageExtractSettings.this.selectedRowsOnlyCheckbox.getSelection());
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selection = DatabaseProducerPageExtractSettings.this.selectedColumnsOnlyCheckbox.getSelection() || DatabaseProducerPageExtractSettings.this.selectedRowsOnlyCheckbox.getSelection();
                    DatabaseProducerPageExtractSettings.this.newConnectionCheckbox.setEnabled(!selection);
                }
            };
            this.selectedColumnsOnlyCheckbox.addSelectionListener((SelectionListener)listener);
            this.selectedRowsOnlyCheckbox.addSelectionListener((SelectionListener)listener);
        }
        this.setControl((Control)composite);
    }

    public void activatePage() {
        DatabaseProducerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseProducerSettings.class);
        this.threadsNumText.setText(String.valueOf(((DataTransferWizard)this.getWizard()).getSettings().getMaxJobCount()));
        this.newConnectionCheckbox.setSelection(settings.isOpenNewConnections());
        this.rowCountCheckbox.setSelection(settings.isQueryRowCount());
        if (this.segmentSizeText != null) {
            this.segmentSizeText.setText(String.valueOf(settings.getSegmentSize()));
            switch (settings.getExtractType()) {
                case SINGLE_QUERY: {
                    this.rowsExtractType.select(0);
                    break;
                }
                case SEGMENTS: {
                    this.rowsExtractType.select(1);
                }
            }
        }
        this.fetchSizeText.setText(String.valueOf(settings.getFetchSize()));
        if (this.selectedColumnsOnlyCheckbox != null) {
            this.selectedColumnsOnlyCheckbox.setSelection(settings.isSelectedColumnsOnly());
        }
        if (this.selectedRowsOnlyCheckbox != null) {
            this.selectedRowsOnlyCheckbox.setSelection(settings.isSelectedRowsOnly());
        }
        this.updatePageCompletion();
    }

    protected boolean determinePageCompletion() {
        if (this.rowsExtractType != null) {
            int selectionIndex = this.rowsExtractType.getSelectionIndex();
            if (selectionIndex == 1) {
                this.segmentSizeLabel.setVisible(true);
                this.segmentSizeText.setVisible(true);
            } else {
                this.segmentSizeLabel.setVisible(false);
                this.segmentSizeText.setVisible(false);
            }
        }
        return true;
    }
}

