/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCellRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumnRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.utils.CommonUtils;

class GridColumn {
    private static final int DEFAULT_WIDTH = 10;
    static final int topMargin = 6;
    static final int bottomMargin = 6;
    private static final int leftMargin = 6;
    private static final int rightMargin = 6;
    private static final int imageSpacing = 3;
    private static final int insideMargin = 3;
    private final LightGrid grid;
    private final Object element;
    private final GridColumn parent;
    private List<GridColumn> children;
    private int level;
    private int width = 10;
    private int height = -1;
    private int pinIndex = -1;

    public GridColumn(LightGrid grid, Object element) {
        this.grid = grid;
        this.element = element;
        this.parent = null;
        this.level = 0;
        grid.newColumn(this, -1);
    }

    public GridColumn(GridColumn parent, Object element) {
        this.grid = parent.grid;
        this.element = element;
        this.parent = parent;
        this.level = parent.level + 1;
        parent.addChild(this);
        this.grid.newColumn(this, -1);
    }

    public Object getElement() {
        return this.element;
    }

    public int getIndex() {
        return this.grid.indexOf(this);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.setWidth(width, true);
    }

    void setWidth(int width, boolean redraw) {
        int delta = width - this.width;
        this.width = width;
        if (this.parent != null) {
            this.parent.width += delta;
        }
        if (redraw) {
            this.grid.setScrollValuesObsolete();
            this.grid.redraw();
        }
    }

    public boolean isPinned() {
        return this.pinIndex >= 0 || this.parent != null && this.parent.isPinned();
    }

    public int getPinIndex() {
        return this.parent == null ? this.pinIndex : this.parent.getPinIndex();
    }

    public void setPinIndex(int pinIndex) {
        this.pinIndex = pinIndex;
    }

    public boolean isOverFilterButton(int x, int y) {
        if (!this.isFilterable()) {
            return false;
        }
        Rectangle bounds = this.getBounds();
        if (y < bounds.y || y > bounds.y + bounds.height) {
            return false;
        }
        Rectangle sortBounds = this.isSortable() ? GridColumnRenderer.getSortControlBounds() : null;
        Rectangle filterBounds = GridColumnRenderer.getFilterControlBounds();
        int filterEnd = bounds.width - (sortBounds == null ? 6 : sortBounds.width + 3);
        int filterBegin = filterEnd - filterBounds.width;
        return x >= filterBegin && x <= filterEnd && y < bounds.y + (filterBounds == null ? 0 : filterBounds.height) + 6;
    }

    public boolean isOverSortArrow(int x, int y) {
        if (!this.isSortable()) {
            return false;
        }
        Rectangle bounds = this.getBounds();
        if (y < bounds.y || y > bounds.y + bounds.height) {
            return false;
        }
        int arrowEnd = bounds.width - 6 + 3;
        Rectangle sortBounds = GridColumnRenderer.getSortControlBounds();
        int arrowBegin = arrowEnd - sortBounds.width;
        return x >= arrowBegin && x <= arrowEnd && y <= bounds.y + sortBounds.height + 6;
    }

    public boolean isOverIcon(int x, int y) {
        Rectangle bounds = this.getBounds();
        if (y < bounds.y || y > bounds.y + bounds.height) {
            return false;
        }
        Image image = this.grid.getLabelProvider().getImage(this.element);
        if (image == null) {
            return false;
        }
        Rectangle imgBounds = image.getBounds();
        return x >= bounds.x + 6 && x <= bounds.x + 6 + imgBounds.width + 3 && y > bounds.y + 6 && y <= bounds.y + 6 + imgBounds.height;
    }

    int getHeaderHeight(boolean includeChildren, boolean forceRefresh) {
        if (forceRefresh) {
            this.height = -1;
        }
        if (this.height < 0) {
            String description;
            this.height = 6 + this.grid.fontMetrics.getHeight() + 6;
            Image image = this.grid.getLabelProvider().getImage(this.element);
            if (image != null) {
                this.height = Math.max(this.height, 6 + image.getBounds().height + 6);
            }
            if (!CommonUtils.isEmpty((String)(description = this.grid.getLabelProvider().getDescription(this.element)))) {
                this.height += 6 + this.grid.fontMetrics.getHeight();
            }
        }
        int childHeight = 0;
        if (includeChildren && !CommonUtils.isEmpty(this.children)) {
            for (GridColumn child : this.children) {
                childHeight = Math.max(childHeight, child.getHeaderHeight(true, false));
            }
        }
        return this.height + childHeight;
    }

    int computeHeaderWidth() {
        int textWidth;
        int x = 6;
        IGridLabelProvider labelProvider = this.grid.getLabelProvider();
        Image image = labelProvider.getImage(this.element);
        if (image != null) {
            x += image.getBounds().width + 3;
        }
        if (Boolean.TRUE.equals(labelProvider.getGridOption("OPTION_EXCLUDE_COLUMN_NAME_FOR_WIDTH_CALC"))) {
            textWidth = this.grid.sizingGC.stringExtent((String)"X").x;
        } else {
            int descWidth;
            String text = labelProvider.getText(this.element);
            String description = labelProvider.getDescription(this.element);
            textWidth = this.grid.sizingGC.stringExtent((String)text).x;
            if (!CommonUtils.isEmpty((String)description) && (descWidth = this.grid.sizingGC.stringExtent((String)description).x) > textWidth) {
                textWidth = descWidth;
            }
        }
        x += textWidth + 6;
        if (this.isSortable()) {
            x += 6 + GridColumnRenderer.getSortControlBounds().width + 3;
        }
        x += GridColumnRenderer.getFilterControlBounds().width;
        if (!CommonUtils.isEmpty(this.children)) {
            int childWidth = 0;
            for (GridColumn child : this.children) {
                childWidth += child.computeHeaderWidth();
            }
            return Math.max(x, childWidth);
        }
        return x;
    }

    public boolean isSortable() {
        return this.grid.getContentProvider().getSortOrder(this.element) != 0;
    }

    public boolean isFilterable() {
        return this.grid.getContentProvider().isElementSupportsFilter(this.element);
    }

    void pack(boolean reflect) {
        int newWidth = this.computeHeaderWidth();
        if (CommonUtils.isEmpty(this.children)) {
            int topIndex = this.grid.getTopIndex();
            int bottomIndex = this.grid.getBottomIndex();
            if (topIndex >= 0 && bottomIndex >= topIndex) {
                int itemCount = this.grid.getItemCount();
                int i = topIndex;
                while (i <= bottomIndex && i < itemCount) {
                    newWidth = Math.max(newWidth, this.computeCellWidth(this.element, this.grid.getRowElement(i)));
                    ++i;
                }
            }
        } else {
            int childrenWidth = 0;
            for (GridColumn child : this.children) {
                child.pack(reflect);
                childrenWidth += child.getWidth();
            }
            if (newWidth > childrenWidth) {
                GridColumn lastChild = this.children.get(this.children.size() - 1);
                lastChild.setWidth(lastChild.getWidth() + newWidth - childrenWidth);
            } else {
                newWidth = childrenWidth;
            }
        }
        if (reflect) {
            this.setWidth(newWidth, false);
        } else {
            this.width = newWidth;
        }
    }

    private int computeCellWidth(Object col, Object row) {
        Rectangle imageBounds;
        int x = 0;
        x += 6;
        String cellText = this.grid.getCellText(col, row);
        int state = this.grid.getContentProvider().getCellState(col, row, cellText);
        if (GridCellRenderer.isLinkState(state)) {
            imageBounds = GridCellRenderer.LINK_IMAGE_BOUNDS;
        } else {
            DBPImage image = this.grid.getContentProvider().getCellImage(col, row);
            Rectangle rectangle = imageBounds = image == null ? null : DBeaverIcons.getImage((DBPImage)image).getBounds();
        }
        if (imageBounds != null) {
            x += imageBounds.width + 3;
        }
        return x += this.grid.sizingGC.textExtent((String)cellText).x + 6;
    }

    Rectangle getBounds() {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        Point loc = this.grid.getOrigin(this, -1);
        bounds.x = loc.x;
        bounds.y = loc.y;
        bounds.width = this.getWidth();
        bounds.height = this.grid.getHeaderHeight();
        return bounds;
    }

    public LightGrid getGrid() {
        return this.grid;
    }

    @Nullable
    public String getHeaderTooltip() {
        String tip = this.grid.getLabelProvider().getToolTipText(this.element);
        if (tip == null) {
            tip = this.grid.getLabelProvider().getText(this.element);
        }
        return tip;
    }

    public GridColumn getParent() {
        return this.parent;
    }

    public List<GridColumn> getChildren() {
        return this.children;
    }

    private void addChild(GridColumn gridColumn) {
        if (this.children == null) {
            this.children = new ArrayList<GridColumn>();
        }
        this.children.add(gridColumn);
    }

    private void removeChild(GridColumn column) {
        this.children.remove(column);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isParent(GridColumn col) {
        GridColumn p = this.parent;
        while (p != null) {
            if (p == col) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public GridColumn getFirstLeaf() {
        if (this.children == null) {
            return this;
        }
        return this.children.get(0).getFirstLeaf();
    }

    public String toString() {
        return CommonUtils.toString((Object)this.element);
    }
}

