/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskSettingsInput;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.registry.TaskUIRegistry;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageTask;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardStub;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class TaskConfigurationWizardDialog
extends ActiveWizardDialog {
    private static final Log log = Log.getLog(TaskConfigurationWizardDialog.class);
    private TaskConfigurationWizard nestedTaskWizard;
    private TaskConfigurationWizardPageTask taskEditPage;
    private boolean editMode;
    private boolean selectorMode;

    public TaskConfigurationWizardDialog(IWorkbenchWindow window, TaskConfigurationWizard wizard) {
        this(window, wizard, null);
    }

    public TaskConfigurationWizardDialog(IWorkbenchWindow window, TaskConfigurationWizard wizard, IStructuredSelection selection) {
        super(window, (IWizard)wizard, selection);
        this.setFinishButtonLabel(UIMessages.button_start);
        if (selection != null && !selection.isEmpty() && wizard.getSettings() instanceof DBTTaskSettingsInput) {
            ArrayList<Object> inputObjects = new ArrayList<Object>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object so = objectArray[n2];
                if (wizard.getTaskType().isObjectApplicable(so)) {
                    inputObjects.add(so);
                }
                ++n2;
            }
            ((DBTTaskSettingsInput)wizard.getSettings()).loadSettingsFromInput(inputObjects);
        }
    }

    public TaskConfigurationWizardDialog(IWorkbenchWindow window) {
        this(window, new TaskConfigurationWizardStub(), null);
    }

    protected boolean isModalWizard() {
        return false;
    }

    protected TaskConfigurationWizard getWizard() {
        return (TaskConfigurationWizard)super.getWizard();
    }

    protected TaskConfigurationWizard getTaskWizard() {
        return (TaskConfigurationWizard)super.getWizard();
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        return super.createDialogArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ++((GridLayout)parent.getLayout()).numColumns;
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 15 && this.getWizard() instanceof TaskConfigurationWizardStub && ((TaskConfigurationWizardStub)this.getWizard()).isLastTaskPreconfigPage(this.getCurrentPage())) {
            this.taskEditPage = this.getTaskPage();
            try {
                TaskConfigurationWizard nextTaskWizard = this.taskEditPage.getTaskWizard();
                if (nextTaskWizard != this.nestedTaskWizard) {
                    this.nestedTaskWizard = nextTaskWizard;
                    this.nestedTaskWizard.addPages();
                    this.setWizard((IWizard)this.nestedTaskWizard);
                }
            }
            catch (Exception e) {
                this.setErrorMessage("Configuration error: " + e.getMessage());
                log.error((Object)("Can't create task " + this.taskEditPage.getSelectedTaskType().getName() + " configuration wizard"), (Throwable)e);
                return;
            }
            this.showPage(this.nestedTaskWizard.getStartingPage());
            return;
        }
        super.buttonPressed(buttonId);
    }

    public void updateButtons() {
        super.updateButtons();
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    TaskConfigurationWizardPageTask getTaskPage() {
        if (this.taskEditPage != null) {
            return this.taskEditPage;
        }
        IWizardPage[] pages = this.getWizard().getPages();
        if (pages.length > 0 && pages[0] instanceof TaskConfigurationWizardPageTask) {
            return (TaskConfigurationWizardPageTask)pages[0];
        }
        return null;
    }

    public DBTTask getTask() {
        return this.getWizard().getCurrentTask();
    }

    public boolean isSelectorMode() {
        return this.selectorMode;
    }

    public void setSelectorMode(boolean selectorMode) {
        this.selectorMode = selectorMode;
        if (selectorMode) {
            this.setFinishButtonLabel(TaskUIMessages.task_config_wizard_dialog_button_save);
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public static int openNewTaskDialog(IWorkbenchWindow window, DBPProject project, String taskTypeId, IStructuredSelection selection) {
        TaskTypeDescriptor taskType = TaskRegistry.getInstance().getTaskType(taskTypeId);
        if (taskType == null) {
            DBWorkbench.getPlatformUI().showError("Bad task type", "Task type '" + taskTypeId + "' not found");
            return 1;
        }
        try {
            DBTTask task = project.getTaskManager().createTemporaryTask((DBTTaskType)taskType, taskType.getName());
            task.setProperties(new HashMap());
            DBTTaskConfigurator configurator = TaskUIRegistry.getInstance().createConfigurator((DBTTaskType)taskType);
            TaskConfigurationWizard configWizard = configurator.createTaskConfigWizard(task);
            TaskConfigurationWizardDialog dialog = new TaskConfigurationWizardDialog(window, configWizard, selection);
            return dialog.open();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Task create error", "Error creating task '" + taskTypeId + "'", (Throwable)e);
            return 1;
        }
    }
}

