/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class PostgreLanguage
extends PostgreInformation {
    private long oid;
    private String name;
    private long ownerId;
    private boolean userDefined;
    private boolean trusted;
    private String handlerId;
    private String inlineHandlerId;
    private String validatorId;

    public PostgreLanguage(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        super(database);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"lanname");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"lanowner");
        this.userDefined = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"lanispl");
        this.trusted = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"lanpltrusted");
        this.handlerId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"lanplcallfoid");
        this.inlineHandlerId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"laninline");
        this.validatorId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"lanvalidator");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=3)
    public long getOwnerId() {
        return this.ownerId;
    }

    @Property(order=10)
    public boolean isUserDefined() {
        return this.userDefined;
    }

    @Property(order=11)
    public boolean isTrusted() {
        return this.trusted;
    }

    @Property(order=12)
    public String getHandlerId() {
        return this.handlerId;
    }

    @Property(order=13)
    public String getInlineHandlerId() {
        return this.inlineHandlerId;
    }

    @Property(order=14)
    public String getValidatorId() {
        return this.validatorId;
    }
}

