/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentAbstract;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class JDBCContentChars
extends JDBCContentAbstract
implements DBDContentStorage,
DBDContentCached {
    private String originalData;
    protected String data;

    public JDBCContentChars(DBPDataSource dataSource, String data) {
        super(dataSource);
        this.data = this.originalData = data;
    }

    public JDBCContentChars(JDBCContentChars copyFrom) {
        super(copyFrom);
        this.originalData = copyFrom.originalData;
        this.data = copyFrom.data;
    }

    @Override
    public InputStream getContentStream() throws IOException {
        if (this.data == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.data.getBytes(this.getCharset()));
    }

    @Override
    public Reader getContentReader() throws IOException {
        if (this.data == null) {
            return new StringReader("");
        }
        return new StringReader(this.data);
    }

    @Override
    public long getContentLength() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.length();
    }

    @Override
    @NotNull
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        return this;
    }

    @Override
    public boolean updateContents(DBRProgressMonitor monitor, DBDContentStorage storage) throws DBException {
        if (storage == null) {
            this.data = null;
        } else {
            try {
                Reader reader = storage.getContentReader();
                try {
                    StringWriter sw = new StringWriter((int)storage.getContentLength());
                    ContentUtils.copyStreams(reader, storage.getContentLength(), sw, monitor);
                    this.data = sw.toString();
                }
                finally {
                    ContentUtils.close(reader);
                }
            }
            catch (IOException e) {
                throw new DBCException("IO error while reading content", e);
            }
        }
        this.modified = true;
        return false;
    }

    @Override
    public void resetContents() {
        this.data = this.originalData;
        this.modified = false;
    }

    @Override
    public String getCharset() {
        return DBValueFormatting.getDefaultBinaryFileEncoding(this.dataSource);
    }

    @Override
    public JDBCContentChars cloneStorage(DBRProgressMonitor monitor) {
        return this.cloneValue(monitor);
    }

    @Override
    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        try {
            if (this.data != null) {
                preparedStatement.setString(paramIndex, this.data);
            } else {
                preparedStatement.setNull(paramIndex, columnType.getTypeID());
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @Override
    public Object getRawValue() {
        return this.data;
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void release() {
        this.data = this.originalData;
    }

    public boolean equals(Object obj) {
        return obj instanceof JDBCContentChars && CommonUtils.equalObjects((Object)this.data, (Object)((JDBCContentChars)obj).data);
    }

    public int hashCode() {
        return this.data == null ? 0 : this.data.hashCode();
    }

    @Override
    public String getDisplayString(DBDDisplayFormat format) {
        return this.data;
    }

    @Override
    public JDBCContentChars cloneValue(DBRProgressMonitor monitor) {
        return new JDBCContentChars(this.dataSource, this.data);
    }

    @Override
    public Object getCachedValue() {
        return this.data;
    }
}

