/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.task;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;

public abstract class SQLToolExecuteHandler
implements DBTTaskHandler {
    public void executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull Writer logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        SQLToolExecuteSettings settings = new SQLToolExecuteSettings();
        settings.loadConfiguration(runnableContext, task.getProperties());
        this.executeWithSettings(runnableContext, task, locale, log, logStream, listener, settings);
    }

    private void executeWithSettings(@NotNull DBRRunnableContext runnableContext, DBTTask task, @NotNull Locale locale, @NotNull Log log, Writer logStream, @NotNull DBTTaskExecutionListener listener, SQLToolExecuteSettings settings) throws DBException {
        listener.taskStarted((Object)settings);
        Throwable error = null;
        try {
            runnableContext.run(true, true, monitor -> {
                try {
                    this.executeTool(monitor, task, settings, log, logStream);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException interruptedException) {
            log.debug((Object)"SQL tools canceled");
        }
        if (error != null) {
            log.error((Object)error);
        }
        listener.taskFinished((Object)settings, error);
    }

    private void executeTool(DBRProgressMonitor monitor, DBTTask task, SQLToolExecuteSettings settings, Log log, Writer logStream) throws DBException {
        settings.getObjectList();
    }
}

