/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.cache.DBSCompositeCache;

public abstract class JDBCCompositeCache<OWNER extends DBSObject, PARENT extends DBSObject, OBJECT extends DBSObject, ROW_REF extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT>
implements DBSCompositeCache<PARENT, OBJECT> {
    protected static final Log log = Log.getLog(JDBCCompositeCache.class);
    private static final String DEFAULT_OBJECT_NAME = "#DBOBJ";
    private final JDBCStructCache<OWNER, ?, ?> parentCache;
    private final Class<PARENT> parentType;
    private final Object parentColumnName;
    private final Object objectColumnName;
    private final Map<PARENT, List<OBJECT>> objectCache = new IdentityHashMap<PARENT, List<OBJECT>>();

    protected JDBCCompositeCache(JDBCStructCache<OWNER, ?, ?> parentCache, Class<PARENT> parentType, Object parentColumnName, Object objectColumnName) {
        this.parentCache = parentCache;
        this.parentType = parentType;
        this.parentColumnName = parentColumnName;
        this.objectColumnName = objectColumnName;
    }

    @NotNull
    protected abstract JDBCStatement prepareObjectsStatement(JDBCSession var1, OWNER var2, PARENT var3) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(JDBCSession var1, OWNER var2, PARENT var3, String var4, JDBCResultSet var5) throws SQLException, DBException;

    @Nullable
    protected abstract ROW_REF[] fetchObjectRow(JDBCSession var1, PARENT var2, OBJECT var3, JDBCResultSet var4) throws SQLException, DBException;

    protected PARENT getParent(OBJECT object) {
        return (PARENT)object.getParentObject();
    }

    protected abstract void cacheChildren(DBRProgressMonitor var1, OBJECT var2, List<ROW_REF> var3);

    protected void cacheChildren2(DBRProgressMonitor monitor, OBJECT object, List<ROW_REF> children) {
    }

    @Override
    @NotNull
    public List<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        return this.getObjects(monitor, owner, null);
    }

    public List<OBJECT> getObjects(DBRProgressMonitor monitor, OWNER owner, PARENT forParent) throws DBException {
        this.loadObjects(monitor, owner, forParent);
        return this.getCachedObjects(forParent);
    }

    public <TYPE extends OBJECT> List<TYPE> getTypedObjects(DBRProgressMonitor monitor, OWNER owner, PARENT forParent, Class<TYPE> type) throws DBException {
        ArrayList<DBSObject> result = new ArrayList<DBSObject>();
        List<OBJECT> objects = this.getObjects(monitor, owner, forParent);
        if (objects != null) {
            for (DBSObject object : objects) {
                if (!type.isInstance(object)) continue;
                result.add((DBSObject)type.cast(object));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OBJECT> getCachedObjects(PARENT forParent) {
        if (forParent == null) {
            return this.getCachedObjects();
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return this.objectCache.get(forParent);
        }
    }

    @Override
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner, @NotNull String objectName) throws DBException {
        this.loadObjects(monitor, owner, null);
        return this.getCachedObject(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBJECT getObject(DBRProgressMonitor monitor, OWNER owner, PARENT forParent, String objectName) throws DBException {
        this.loadObjects(monitor, owner, forParent);
        if (forParent == null) {
            return this.getCachedObject(objectName);
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return (OBJECT)((DBSObject)DBUtils.findObject((Collection)this.objectCache.get(forParent), objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheObject(@NotNull OBJECT object) {
        super.cacheObject(object);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            List<OBJECT> objects = this.objectCache.get(parent);
            if (objects == null) {
                objects = new ArrayList<OBJECT>();
                this.objectCache.put(parent, objects);
            }
            objects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        super.removeObject(object, resetFullCache);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            if (resetFullCache) {
                this.objectCache.remove(parent);
            } else {
                List<OBJECT> subCache = this.objectCache.get(parent);
                if (subCache != null) {
                    subCache.remove(object);
                }
            }
        }
    }

    @Override
    public void clearObjectCache(PARENT forParent) {
        if (forParent == null) {
            super.clearCache();
            this.objectCache.clear();
        } else {
            List<OBJECT> removedObjects = this.objectCache.remove(forParent);
            if (removedObjects != null) {
                for (DBSObject obj : removedObjects) {
                    super.removeObject(obj, false);
                }
            }
        }
    }

    public void setObjectCache(PARENT forParent, List<OBJECT> objects) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
            super.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCache(List<OBJECT> objects) {
        super.setCache(objects);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
            for (DBSObject object : objects) {
                PARENT parent = this.getParent(object);
                List<OBJECT> parentObjects = this.objectCache.get(parent);
                if (parentObjects == null) {
                    parentObjects = new ArrayList<OBJECT>();
                    this.objectCache.put(parent, parentObjects);
                }
                parentObjects.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadObjects(DBRProgressMonitor monitor, OWNER owner, PARENT forParent) throws DBException {
        Map<PARENT, List<OBJECT>> map;
        Object object;
        LinkedHashMap parentObjectMap;
        block52: {
            Map<PARENT, List<OBJECT>> map2 = this.objectCache;
            synchronized (map2) {
                if (forParent == null && this.isFullyCached() || forParent != null && (!forParent.isPersisted() || this.objectCache.containsKey(forParent))) {
                    return;
                }
            }
            if (forParent == null) {
                this.parentCache.loadObjects(monitor, owner);
                this.parentCache.loadChildren(monitor, owner, null);
            }
            parentObjectMap = new LinkedHashMap();
            DBPDataSource dataSource = owner.getDataSource();
            assert (dataSource != null);
            try {
                object = null;
                map = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession(monitor, owner, "Load composite objects");){
                    jDBCStatement.setFetchSize(1000);
                    try (JDBCStatement jDBCStatement = this.prepareObjectsStatement(session, owner, forParent);){
                        jDBCStatement.executeStatement();
                        Iterator<List<OBJECT>> dbResult = jDBCStatement.getResultSet();
                        if (dbResult == null) break block52;
                        try {
                            if (dbResult.next()) {
                            }
                        }
                        finally {
                            dbResult.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (SQLException ex) {
                if (ex instanceof SQLFeatureNotSupportedException) {
                    log.debug("Error reading cache: feature not supported", ex);
                }
                throw new DBException(ex, dataSource);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        object = this;
        synchronized (object) {
            map = this.objectCache;
            synchronized (map) {
                if (!(forParent == null && parentObjectMap.isEmpty() || forParent != null)) {
                    ArrayList<OBJECT> globalCache = new ArrayList<OBJECT>();
                    for (Map map2 : parentObjectMap.values()) {
                        if (map2 == null) continue;
                        for (ObjectInfo info : map2.values()) {
                            if (info.broken) continue;
                            globalCache.add(info.object);
                        }
                    }
                    for (List<OBJECT> list : this.objectCache.values()) {
                        globalCache.addAll(list);
                    }
                    super.setCache(globalCache);
                    this.invalidateObjects(monitor, owner, new AbstractObjectCache.CacheIterator());
                }
                for (Map.Entry colEntry : parentObjectMap.entrySet()) {
                    if (colEntry.getValue() == null || this.objectCache.containsKey(colEntry.getKey())) continue;
                    Collection objectInfos = ((Map)colEntry.getValue()).values();
                    ArrayList objects = new ArrayList(objectInfos.size());
                    for (ObjectInfo objectInfo : objectInfos) {
                        objectInfo.needsCaching = true;
                        objects.add(objectInfo.object);
                    }
                    this.objectCache.put((DBSObject)colEntry.getKey(), objects);
                }
                if (forParent == null) {
                    for (DBSObject tmpParent : this.parentCache.getTypedObjects(monitor, owner, this.parentType)) {
                        if (parentObjectMap.containsKey(tmpParent) || this.objectCache.containsKey(tmpParent)) continue;
                        this.objectCache.put(tmpParent, new ArrayList());
                    }
                } else if (!parentObjectMap.containsKey(forParent) && !this.objectCache.containsKey(forParent)) {
                    this.objectCache.put(forParent, new ArrayList());
                }
            }
            for (Map.Entry colEntry : parentObjectMap.entrySet()) {
                for (ObjectInfo objectInfo : ((Map)colEntry.getValue()).values()) {
                    if (!objectInfo.needsCaching) continue;
                    this.cacheChildren(monitor, objectInfo.object, objectInfo.rows);
                }
            }
            for (Map.Entry colEntry : parentObjectMap.entrySet()) {
                for (ObjectInfo objectInfo : ((Map)colEntry.getValue()).values()) {
                    if (!objectInfo.needsCaching) continue;
                    this.cacheChildren2(monitor, objectInfo.object, objectInfo.rows);
                }
            }
        }
    }

    protected String getDefaultObjectName(JDBCResultSet dbResult, String parentName) {
        return parentName == null ? DEFAULT_OBJECT_NAME : String.valueOf(parentName.toUpperCase()) + "_" + DEFAULT_OBJECT_NAME;
    }

    private static class ObjectInfo {
        final OBJECT object;
        final List<ROW_REF> rows = new ArrayList();
        public boolean broken;
        public boolean needsCaching;
        final /* synthetic */ JDBCCompositeCache this$0;

        public ObjectInfo(OBJECT object) {
            this.this$0 = var1_1;
            this.object = object;
        }
    }
}

