/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.config;

import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.ext.mysql.ui.config.UserPropertyHandler;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandFilter;
import org.jkiss.dbeaver.model.edit.DBECommandQueue;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.AbstractObjectManager;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLScriptCommand;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class MySQLUserManager
extends AbstractObjectManager<MySQLUser>
implements DBEObjectMaker<MySQLUser, MySQLDataSource>,
DBECommandFilter<MySQLUser> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLUser> getObjectsCache(MySQLUser object) {
        return null;
    }

    public boolean canCreateObject(Object container) {
        return true;
    }

    public boolean canDeleteObject(MySQLUser object) {
        return true;
    }

    public MySQLUser createNewObject(DBRProgressMonitor monitor, DBECommandContext commandContext, Object container, Object copyFrom, Map<String, Object> options) {
        MySQLUser newUser = new MySQLUser((MySQLDataSource)container, null);
        if (copyFrom instanceof MySQLUser) {
            MySQLUser tplUser = (MySQLUser)copyFrom;
            newUser.setUserName(tplUser.getUserName());
            newUser.setHost(tplUser.getHost());
            newUser.setMaxQuestions(tplUser.getMaxQuestions());
            newUser.setMaxUpdates(tplUser.getMaxUpdates());
            newUser.setMaxConnections(tplUser.getMaxConnections());
            newUser.setMaxUserConnections(tplUser.getMaxUserConnections());
        }
        commandContext.addCommand((DBECommand)new CommandCreateUser(newUser), (DBECommandReflector)new AbstractObjectManager.CreateObjectReflector((DBEObjectMaker)this), true);
        return newUser;
    }

    public void deleteObject(DBECommandContext commandContext, MySQLUser user, Map<String, Object> options) {
        commandContext.addCommand((DBECommand)new CommandDropUser(user), (DBECommandReflector)new AbstractObjectManager.DeleteObjectReflector((DBEObjectMaker)this), true);
    }

    public void filterCommands(DBECommandQueue<MySQLUser> queue) {
        if (!queue.isEmpty()) {
            queue.add((Object)new SQLScriptCommand((DBSObject)((MySQLUser)queue.getObject()), MySQLUIMessages.edit_user_manager_command_flush_privileges, "FLUSH PRIVILEGES"));
        }
    }

    private static class CommandCreateUser
    extends DBECommandAbstract<MySQLUser> {
        protected CommandCreateUser(MySQLUser user) {
            super((DBPObject)user, MySQLUIMessages.edit_user_manager_command_create_user);
        }

        public void validateCommand(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
            if (CommonUtils.isEmpty((String)((MySQLUser)this.getObject()).getUserName())) {
                throw new DBException("Can't create user with empty name");
            }
            if (CommonUtils.isEmpty((String)((MySQLUser)this.getObject()).getHost())) {
                throw new DBException("Can't create user with empty host name");
            }
            super.validateCommand(monitor, options);
        }
    }

    private static class CommandDropUser
    extends DBECommandComposite<MySQLUser, UserPropertyHandler> {
        protected CommandDropUser(MySQLUser user) {
            super((DBPObject)user, MySQLUIMessages.edit_user_manager_command_drop_user);
        }

        public DBEPersistAction[] getPersistActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, Map<String, Object> options) {
            return new DBEPersistAction[]{new SQLDatabasePersistAction(MySQLUIMessages.edit_user_manager_command_drop_user, "DROP USER " + ((MySQLUser)this.getObject()).getFullName()){

                public void afterExecute(DBCSession session, Throwable error) {
                    if (error == null) {
                        ((MySQLUser)this.getObject()).setPersisted(false);
                    }
                }
            }};
        }
    }
}

