/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.struct.ContextDefaultObjectsReader;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDatabaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;

public class SelectActiveSchemaHandler
extends AbstractDataSourceHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBPDataSourceContainer dataSourceContainer = DataSourceToolbarUtils.getCurrentDataSource(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
        if (dataSourceContainer == null) {
            log.debug((Object)"No active connection. Action is in disabled state.");
            return null;
        }
        DBCExecutionContext executionContext = SelectActiveSchemaHandler.getExecutionContextFromPart((IWorkbenchPart)HandlerUtil.getActiveEditor((ExecutionEvent)event));
        ContextDefaultObjectsReader contextDefaultObjectsReader = new ContextDefaultObjectsReader(dataSourceContainer.getDataSource(), executionContext);
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)contextDefaultObjectsReader);
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Schema list", "Error reading schema list", e.getTargetException());
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        DBSObject selectedDB = null;
        DBSObject defaultObject = contextDefaultObjectsReader.getDefaultObject();
        if (defaultObject != null) {
            for (DBSObject object : contextDefaultObjectsReader.getObjectList()) {
                if (object != defaultObject && object != defaultObject.getParentObject()) continue;
                selectedDB = object;
            }
        }
        DBNDatabaseNode selectedNode = selectedDB == null ? null : DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(selectedDB);
        SelectDatabaseDialog dialog = new SelectDatabaseDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), dataSourceContainer, contextDefaultObjectsReader.getDefaultCatalogName(), contextDefaultObjectsReader.getNodeList(), selectedNode == null ? null : Collections.singletonList(selectedNode));
        dialog.setModeless(true);
        if (dialog.open() == 1) {
            return null;
        }
        DBNDatabaseNode node = (DBNDatabaseNode)dialog.getSelectedObject();
        if (node != null && node.getObject() != defaultObject) {
            SelectActiveSchemaHandler.changeDataBaseSelection(dataSourceContainer, executionContext, contextDefaultObjectsReader.getDefaultCatalogName(), dialog.getCurrentInstanceName(), node.getNodeName());
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        if ("true".equals(parameters.get("noCustomLabel"))) {
            return;
        }
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        final IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        String schemaName = "< N/A >";
        DBIcon schemaIcon = DBIcon.TREE_SCHEMA;
        String schemaTooltip = UINavigatorMessages.toolbar_datasource_selector_combo_database_tooltip;
        DBPDataSourceContainer dataSource = DataSourceToolbarUtils.getCurrentDataSource(workbenchWindow);
        if (dataSource != null && dataSource.isConnected()) {
            IEditorInput editorInput = activeEditor.getEditorInput();
            if (editorInput instanceof IDatabaseEditorInput) {
                DBSObject schemaObject;
                DBCExecutionContext executionContext;
                if (editorInput instanceof DatabaseLazyEditorInput) {
                    activeEditor.addPropertyListener(new IPropertyListener(){

                        public void propertyChanged(Object source, int propId) {
                            if (1 == propId) {
                                DataSourceToolbarUtils.updateCommandsUI();
                                activeEditor.removePropertyListener((IPropertyListener)this);
                            }
                        }
                    });
                }
                if ((executionContext = ((IDatabaseEditorInput)editorInput).getExecutionContext()) != null && (schemaObject = DBUtils.getSelectedObject((DBCExecutionContext)executionContext)) != null && DBUtils.getPublicObjectContainer((DBSObject)schemaObject) != dataSource) {
                    DBSObject schemaParent = schemaObject.getParentObject();
                    schemaName = schemaParent instanceof DBSObjectContainer && !(schemaParent instanceof DBPDataSource) ? String.valueOf(schemaObject.getName()) + "@" + schemaParent.getName() : schemaObject.getName();
                }
            } else {
                DBCExecutionContext executionContext = SelectActiveSchemaHandler.getExecutionContextFromPart((IWorkbenchPart)activeEditor);
                DBCExecutionContextDefaults contextDefaults = null;
                if (executionContext != null) {
                    contextDefaults = executionContext.getContextDefaults();
                }
                if (contextDefaults != null) {
                    DBSCatalog defaultCatalog = contextDefaults.getDefaultCatalog();
                    DBSSchema defaultSchema = contextDefaults.getDefaultSchema();
                    if (defaultCatalog != null && (defaultSchema != null || contextDefaults.supportsSchemaChange())) {
                        schemaName = defaultSchema == null ? "?" : String.valueOf(defaultSchema.getName()) + "@" + defaultCatalog.getName();
                        schemaIcon = DBIcon.TREE_SCHEMA;
                    } else if (defaultCatalog != null) {
                        schemaName = defaultCatalog.getName();
                        schemaIcon = DBIcon.TREE_DATABASE;
                    } else if (defaultSchema != null) {
                        schemaName = defaultSchema.getName();
                        schemaIcon = DBIcon.TREE_SCHEMA;
                    }
                }
            }
        }
        element.setText(schemaName);
        element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)schemaIcon));
        element.setTooltip(schemaTooltip);
    }

    private static void changeDataBaseSelection(DBPDataSourceContainer dsContainer, final DBCExecutionContext executionContext, final @Nullable String curInstanceName, final @Nullable String newInstanceName, final @Nullable String newObjectName) {
        if (dsContainer != null && dsContainer.isConnected()) {
            final DBPDataSource dataSource = dsContainer.getDataSource();
            new AbstractJob("Change active database"){
                {
                    super($anonymous0);
                    this.setUser(true);
                }

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (DBCExecutionContext)executionContext, (String)newInstanceName, (String)curInstanceName, (String)newObjectName);
                        return Status.OK_STATUS;
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                }
            }.schedule();
        }
    }

    public static class MenuContributor
    extends DataSourceMenuContributor {
        static final int DB_LIST_READ_TIMEOUT = 3000;

        @Override
        protected void fillContributionItems(List<IContributionItem> menuItems) {
            DBCExecutionContextDefaults contextDefaults;
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            final DBPDataSourceContainer dataSourceContainer = DataSourceToolbarUtils.getCurrentDataSource(workbenchWindow);
            if (dataSourceContainer == null) {
                return;
            }
            final DBCExecutionContext executionContext = SelectActiveSchemaHandler.getExecutionContextFromPart((IWorkbenchPart)workbenchWindow.getActivePage().getActiveEditor());
            final ContextDefaultObjectsReader contextDefaultObjectsReader = new ContextDefaultObjectsReader(dataSourceContainer.getDataSource(), executionContext);
            contextDefaultObjectsReader.setReadNodes(true);
            RuntimeUtils.runTask((DBRRunnableWithProgress)contextDefaultObjectsReader, (String)"Read database list", (long)3000L);
            DBSObject[] defObjects = null;
            if (executionContext != null && (contextDefaults = executionContext.getContextDefaults()) != null) {
                defObjects = new DBSObject[]{contextDefaults.getDefaultCatalog(), contextDefaults.getDefaultSchema()};
            }
            if (defObjects == null) {
                defObjects = new DBSObject[]{};
            }
            final DBSObject[] finalDefObjects = defObjects;
            for (final DBNDatabaseNode node : contextDefaultObjectsReader.getNodeList()) {
                menuItems.add((IContributionItem)new ActionContributionItem((IAction)new Action(node.getName(), 2){
                    private final DBSObject object;
                    {
                        super($anonymous0, $anonymous1);
                        this.object = dBNDatabaseNode.getObject();
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)dBNDatabaseNode.getNodeIcon()));
                    }

                    public boolean isChecked() {
                        return ArrayUtils.contains((Object[])finalDefObjects, (Object)this.object);
                    }

                    public void run() {
                        SelectActiveSchemaHandler.changeDataBaseSelection(dataSourceContainer, executionContext, contextDefaultObjectsReader.getDefaultCatalogName(), this.object instanceof DBSCatalog ? this.object.getName() : contextDefaultObjectsReader.getDefaultCatalogName(), this.object instanceof DBSSchema ? node.getNodeName() : null);
                    }
                }));
            }
        }
    }
}

