/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.sql.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.sql.SQLScriptExecuteSettings;
import org.jkiss.dbeaver.tools.sql.ui.wizard.SQLTaskConfigurationWizard;
import org.jkiss.dbeaver.tools.sql.ui.wizard.SQLTaskDataSourceSelectorDialog;
import org.jkiss.dbeaver.tools.sql.ui.wizard.SQLTaskScriptSelectorDialog;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.utils.CommonUtils;

class SQLTaskPageSettings
extends ActiveWizardPage<SQLTaskConfigurationWizard> {
    private static final Log log = Log.getLog(SQLTaskPageSettings.class);
    private SQLTaskConfigurationWizard sqlWizard;
    private Button ignoreErrorsCheck;
    private Button dumpQueryCheck;
    private Button autoCommitCheck;
    private TableViewer scriptsViewer;
    private TableViewer dataSourceViewer;
    private List<DBNResource> selectedScripts = new ArrayList<DBNResource>();
    private List<DBNDataSource> selectedDataSources = new ArrayList<DBNDataSource>();

    SQLTaskPageSettings(SQLTaskConfigurationWizard wizard) {
        super(DTMessages.sql_script_task_title);
        this.setTitle(DTMessages.sql_script_task_page_settings_title);
        this.setDescription(DTMessages.sql_script_task_page_settings_description);
        this.sqlWizard = wizard;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        SQLScriptExecuteSettings dtSettings = ((SQLTaskConfigurationWizard)this.getWizard()).getSettings();
        SashForm mainGroup = new SashForm(composite, 0);
        mainGroup.setSashWidth(5);
        mainGroup.setLayoutData((Object)new GridData(1808));
        final DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(this.sqlWizard.getProject());
        Group filesGroup = UIUtils.createControlGroup((Composite)mainGroup, (String)DTMessages.sql_script_task_page_settings_group_files, (int)2, (int)1808, (int)0);
        this.scriptsViewer = new TableViewer((Composite)filesGroup, 67586);
        this.scriptsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.scriptsViewer.getTable().setHeaderVisible(true);
        this.scriptsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DBNResource)element).getResource().getProjectRelativePath().toString();
            }

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)((DBNResource)element).getNodeIconDefault());
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.scriptsViewer.getTable().setLayoutData((Object)gd);
        SQLTaskScriptSelectorDialog.createScriptColumns((ColumnViewer)this.scriptsViewer);
        final Table scriptTable = this.scriptsViewer.getTable();
        scriptTable.setLayoutData((Object)new GridData(1808));
        ToolBar buttonsToolbar = new ToolBar((Composite)filesGroup, 512);
        buttonsToolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Add script", (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLTaskScriptSelectorDialog dialog = new SQLTaskScriptSelectorDialog(SQLTaskPageSettings.this.getShell(), projectNode);
                if (dialog.open() == 0) {
                    for (DBNResource script : dialog.getSelectedScripts()) {
                        if (SQLTaskPageSettings.this.selectedScripts.contains(script)) continue;
                        SQLTaskPageSettings.this.selectedScripts.add(script);
                    }
                    SQLTaskPageSettings.this.refreshScripts();
                }
            }
        });
        ToolItem deleteItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Remove script", (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SQLTaskPageSettings.this.scriptsViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof DBNResource) {
                            SQLTaskPageSettings.this.selectedScripts.remove(element);
                        }
                        ++n2;
                    }
                    SQLTaskPageSettings.this.refreshScripts();
                }
            }
        });
        UIUtils.createToolBarSeparator((ToolBar)buttonsToolbar, (int)256);
        ToolItem moveUpItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Move script up", (DBPImage)UIIcon.ARROW_UP, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = scriptTable.getSelectionIndex();
                if (selectionIndex > 0) {
                    DBNResource prevScript = (DBNResource)SQLTaskPageSettings.this.selectedScripts.get(selectionIndex - 1);
                    SQLTaskPageSettings.this.selectedScripts.set(selectionIndex - 1, (DBNResource)SQLTaskPageSettings.this.selectedScripts.get(selectionIndex));
                    SQLTaskPageSettings.this.selectedScripts.set(selectionIndex, prevScript);
                    SQLTaskPageSettings.this.refreshScripts();
                }
            }
        });
        ToolItem moveDownItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Move script down", (DBPImage)UIIcon.ARROW_DOWN, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = scriptTable.getSelectionIndex();
                if (selectionIndex < scriptTable.getItemCount() - 1) {
                    DBNResource nextScript = (DBNResource)SQLTaskPageSettings.this.selectedScripts.get(selectionIndex + 1);
                    SQLTaskPageSettings.this.selectedScripts.set(selectionIndex + 1, (DBNResource)SQLTaskPageSettings.this.selectedScripts.get(selectionIndex));
                    SQLTaskPageSettings.this.selectedScripts.set(selectionIndex, nextScript);
                    SQLTaskPageSettings.this.refreshScripts();
                }
            }
        });
        this.scriptsViewer.addSelectionChangedListener(event -> {
            int selectionIndex = scriptTable.getSelectionIndex();
            deleteItem.setEnabled(selectionIndex >= 0);
            moveUpItem.setEnabled(selectionIndex > 0);
            moveDownItem.setEnabled(selectionIndex < scriptTable.getItemCount() - 1);
        });
        deleteItem.setEnabled(false);
        Group connectionsGroup = UIUtils.createControlGroup((Composite)mainGroup, (String)DTMessages.sql_script_task_page_settings_group_connections, (int)2, (int)1808, (int)0);
        this.dataSourceViewer = new TableViewer((Composite)connectionsGroup, 67586);
        this.dataSourceViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.dataSourceViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DBNDataSource)element).getNodeName();
            }

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)((DBNDataSource)element).getNodeIcon());
            }
        });
        gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.dataSourceViewer.getTable().setLayoutData((Object)gd);
        final Table dsTable = this.dataSourceViewer.getTable();
        dsTable.setLayoutData((Object)new GridData(1808));
        buttonsToolbar = new ToolBar((Composite)connectionsGroup, 512);
        buttonsToolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Add datasource", (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLTaskDataSourceSelectorDialog dialog = new SQLTaskDataSourceSelectorDialog(SQLTaskPageSettings.this.getShell(), projectNode);
                if (dialog.open() == 0) {
                    for (DBNDataSource ds : dialog.getSelectedDataSources()) {
                        if (SQLTaskPageSettings.this.selectedDataSources.contains(ds)) continue;
                        SQLTaskPageSettings.this.selectedDataSources.add(ds);
                    }
                    SQLTaskPageSettings.this.refreshDataSources();
                }
            }
        });
        deleteItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Remove datasource", (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SQLTaskPageSettings.this.dataSourceViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof DBNDataSource) {
                            SQLTaskPageSettings.this.selectedDataSources.remove(element);
                        }
                        ++n2;
                    }
                    SQLTaskPageSettings.this.refreshDataSources();
                }
            }
        });
        UIUtils.createToolBarSeparator((ToolBar)buttonsToolbar, (int)256);
        moveUpItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Move datasource up", (DBPImage)UIIcon.ARROW_UP, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = dsTable.getSelectionIndex();
                if (selectionIndex > 0) {
                    DBNDataSource prevScript = (DBNDataSource)SQLTaskPageSettings.this.selectedDataSources.get(selectionIndex - 1);
                    SQLTaskPageSettings.this.selectedDataSources.set(selectionIndex - 1, (DBNDataSource)SQLTaskPageSettings.this.selectedDataSources.get(selectionIndex));
                    SQLTaskPageSettings.this.selectedDataSources.set(selectionIndex, prevScript);
                    SQLTaskPageSettings.this.refreshDataSources();
                }
            }
        });
        moveDownItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Move datasource down", (DBPImage)UIIcon.ARROW_DOWN, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = dsTable.getSelectionIndex();
                if (selectionIndex < dsTable.getItemCount() - 1) {
                    DBNDataSource nextScript = (DBNDataSource)SQLTaskPageSettings.this.selectedDataSources.get(selectionIndex + 1);
                    SQLTaskPageSettings.this.selectedDataSources.set(selectionIndex + 1, (DBNDataSource)SQLTaskPageSettings.this.selectedDataSources.get(selectionIndex));
                    SQLTaskPageSettings.this.selectedDataSources.set(selectionIndex, nextScript);
                    SQLTaskPageSettings.this.refreshScripts();
                }
            }
        });
        this.dataSourceViewer.addSelectionChangedListener(event -> {
            int selectionIndex = dsTable.getSelectionIndex();
            deleteItem.setEnabled(selectionIndex >= 0);
            moveUpItem.setEnabled(selectionIndex > 0);
            moveDownItem.setEnabled(selectionIndex < dsTable.getItemCount() - 1);
        });
        deleteItem.setEnabled(false);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)DTMessages.sql_script_task_page_settings_group_script, (int)3, (int)32, (int)0);
        this.ignoreErrorsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)DTMessages.sql_script_task_page_settings_option_ignore_errors, (String)"", (boolean)dtSettings.isIgnoreErrors(), (int)1);
        this.dumpQueryCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)DTMessages.sql_script_task_page_settings_option_dump_results, (String)"", (boolean)dtSettings.isDumpQueryResultsToLog(), (int)1);
        this.dumpQueryCheck.setEnabled(false);
        this.autoCommitCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)DTMessages.sql_script_task_page_settings_option_auto_commit, (String)"", (boolean)dtSettings.isAutoCommit(), (int)1);
        ((SQLTaskConfigurationWizard)this.getWizard()).createTaskSaveButtons(composite, true, 1);
        this.loadSettings();
        this.setControl((Control)composite);
    }

    private void refreshScripts() {
        this.scriptsViewer.refresh(true, true);
        this.updateSelectedScripts();
    }

    private void refreshDataSources() {
        this.dataSourceViewer.refresh(true, true);
    }

    private void updateSelectedScripts() {
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(this.sqlWizard.getProject());
        LinkedHashSet dataSources = new LinkedHashSet();
        for (DBNResource element : this.selectedScripts) {
            Collection resDS = element.getAssociatedDataSources();
            if (CommonUtils.isEmpty((Collection)resDS)) continue;
            dataSources.addAll(resDS);
        }
        if (!dataSources.isEmpty()) {
            ArrayList<DBNDataSource> checkedDataSources = new ArrayList<DBNDataSource>();
            for (DBPDataSourceContainer ds : dataSources) {
                DBNDataSource dsNode = projectNode.getDatabases().getDataSource(ds);
                if (dsNode == null) continue;
                checkedDataSources.add(dsNode);
            }
            if (!checkedDataSources.isEmpty()) {
                this.refreshDataSources();
                for (DBNDataSource dsNode : checkedDataSources) {
                    if (this.selectedDataSources.contains(dsNode)) continue;
                    this.selectedDataSources.add(dsNode);
                }
            }
        }
        this.refreshDataSources();
        this.updatePageCompletion();
    }

    public void activatePage() {
        this.updatePageCompletion();
    }

    public void deactivatePage() {
    }

    protected boolean determinePageCompletion() {
        if (this.selectedScripts.isEmpty()) {
            this.setErrorMessage("You must select script(s) to execute");
            return false;
        }
        if (this.selectedDataSources.isEmpty()) {
            this.setErrorMessage("You must select connection(s)");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void loadSettings() {
        SQLScriptExecuteSettings settings = this.sqlWizard.getSettings();
        List scriptFiles = settings.getScriptFiles();
        for (String filePath : scriptFiles) {
            DBNResource resource;
            IFile file = SQLScriptExecuteSettings.getWorkspaceFile((String)filePath);
            if (file == null) {
                log.debug((Object)("Script file '" + filePath + "' not found"));
                continue;
            }
            DBPProject currentProject = DBWorkbench.getPlatform().getWorkspace().getProject(file.getProject());
            if (currentProject == null) {
                log.debug((Object)("Project '" + file.getProject().getName() + "' not found"));
                continue;
            }
            DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(currentProject);
            if (projectNode == null || (resource = projectNode.findResource((IResource)file)) == null) continue;
            this.selectedScripts.add(resource);
        }
        this.scriptsViewer.setInput(this.selectedScripts);
        for (DBPDataSourceContainer dataSource : settings.getDataSources()) {
            DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(dataSource.getProject());
            DBNDataSource dsNode = projectNode.getDatabases().getDataSource(dataSource);
            if (dsNode == null) continue;
            this.selectedDataSources.add(dsNode);
        }
        this.dataSourceViewer.setInput(this.selectedDataSources);
    }

    public void saveSettings() {
        if (this.sqlWizard == null) {
            return;
        }
        SQLScriptExecuteSettings settings = this.sqlWizard.getSettings();
        ArrayList<String> scriptPaths = new ArrayList<String>();
        for (DBNResource resource : this.selectedScripts) {
            IResource res = resource.getResource();
            if (!(res instanceof IFile)) continue;
            scriptPaths.add(res.getFullPath().toString());
        }
        settings.setScriptFiles(scriptPaths);
        ArrayList<DBPDataSourceContainer> dsList = new ArrayList<DBPDataSourceContainer>();
        for (DBNDataSource dsNode : this.selectedDataSources) {
            dsList.add(dsNode.getDataSourceContainer());
        }
        settings.setDataSources(dsList);
        settings.setIgnoreErrors(this.ignoreErrorsCheck.getSelection());
        settings.setDumpQueryResultsToLog(this.dumpQueryCheck.getSelection());
        settings.setAutoCommit(this.autoCommitCheck.getSelection());
    }
}

