/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.config;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUser;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;

public class OracleSchemaConfigurator
implements DBEObjectConfigurator<OracleSchema> {
    public OracleSchema configureObject(DBRProgressMonitor monitor, final Object container, final OracleSchema newSchema) {
        return (OracleSchema)new UITask<OracleSchema>(){

            protected OracleSchema runTask() {
                NewUserDialog dialog = new NewUserDialog(UIUtils.getActiveWorkbenchShell(), (OracleDataSource)container);
                if (dialog.open() != 0) {
                    return null;
                }
                newSchema.setName(dialog.getUser().getName());
                newSchema.setUser(dialog.getUser());
                return newSchema;
            }
        }.execute();
    }

    static class NewUserDialog
    extends Dialog {
        private OracleUser user;
        private Text nameText;
        private Text passwordText;

        NewUserDialog(Shell parentShell, OracleDataSource dataSource) {
            super(parentShell);
            this.user = new OracleUser(dataSource);
        }

        OracleUser getUser() {
            return this.user;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Set schema/user properties");
            Control container = super.createDialogArea(parent);
            Composite composite = UIUtils.createPlaceholder((Composite)((Composite)container), (int)2, (int)5);
            composite.setLayoutData((Object)new GridData(1808));
            this.nameText = UIUtils.createLabelText((Composite)composite, (String)"Schema/User Name", null);
            this.nameText.setLayoutData((Object)new GridData(768));
            this.passwordText = UIUtils.createLabelText((Composite)composite, (String)"User Password", null, (int)0x400800);
            this.passwordText.setLayoutData((Object)new GridData(768));
            UIUtils.createInfoLabel((Composite)composite, (String)"Creating a schema is the same as creating a user.\nYou need to specify a password.", (int)768, (int)2);
            return parent;
        }

        protected void okPressed() {
            this.user.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)this.user, (String)this.nameText.getText()));
            this.user.setPassword(this.passwordText.getText());
            super.okPressed();
        }
    }
}

