/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.registry.TaskConfiguratorDescriptor;

public class TaskUIRegistry {
    public static final String TASK_EXTENSION_ID = "org.jkiss.dbeaver.task.ui";
    private static final Log log = Log.getLog(TaskUIRegistry.class);
    private static TaskUIRegistry instance = null;
    private final Map<DBTTaskType, TaskConfiguratorDescriptor> taskConfigurators = new LinkedHashMap<DBTTaskType, TaskConfiguratorDescriptor>();

    public static synchronized TaskUIRegistry getInstance() {
        if (instance == null) {
            instance = new TaskUIRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private TaskUIRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(TASK_EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("configurator".equals(ext.getName())) {
                String typeId = ext.getAttribute("type");
                TaskTypeDescriptor taskType = TaskRegistry.getInstance().getTaskType(typeId);
                if (taskType == null) {
                    log.debug((Object)("Task type '" + typeId + "' not found. Skip configurator."));
                } else {
                    TaskConfiguratorDescriptor configDescriptor = new TaskConfiguratorDescriptor(taskType, ext);
                    this.taskConfigurators.put((DBTTaskType)taskType, configDescriptor);
                }
            }
            ++n2;
        }
    }

    public boolean supportsConfigurator(DBTTaskType taskType) {
        return this.taskConfigurators.containsKey(taskType);
    }

    public boolean supportsConfiguratorPage(DBTTaskType type) {
        TaskConfiguratorDescriptor configuratorDescriptor = this.taskConfigurators.get(type);
        if (configuratorDescriptor != null) {
            return configuratorDescriptor.supportsPanel();
        }
        return false;
    }

    public DBTTaskConfigurator createConfigurator(DBTTaskType taskType) throws DBCException {
        TaskConfiguratorDescriptor configuratorDescriptor = this.taskConfigurators.get(taskType);
        if (configuratorDescriptor == null) {
            throw new DBCException("Task configurator not supported for " + taskType.getName());
        }
        try {
            return configuratorDescriptor.createConfigurator();
        }
        catch (DBException e) {
            throw new DBCException("Task configurator create error", (Throwable)e);
        }
    }
}

