/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.text.ParseException;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.DateTimeValueHandler;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class DateTimeCustomValueHandler
extends DateTimeValueHandler {
    protected static final Log log = Log.getLog(DateTimeCustomValueHandler.class);
    private final DBDDataFormatterProfile formatterProfile;
    protected DBDDataFormatter formatter;

    public DateTimeCustomValueHandler(DBDDataFormatterProfile formatterProfile) {
        this.formatterProfile = formatterProfile;
    }

    @Override
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return copy ? ((Date)object).clone() : object;
        }
        if (object instanceof String) {
            String strValue = (String)object;
            if (strValue.isEmpty()) {
                return null;
            }
            if (session != null && session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.format.datetime.native")) {
                return object;
            }
            try {
                return this.getFormatter(type).parseValue(strValue, null);
            }
            catch (ParseException parseException) {
                try {
                    Date result = new Date(strValue);
                    return result;
                }
                catch (Exception exception) {
                    return object;
                }
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    @Override
    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value == null || value instanceof String || value instanceof Number) {
            return super.getValueDisplayString(column, value, format);
        }
        try {
            return this.getFormatter(column).formatValue(value);
        }
        catch (Exception exception) {
            return String.valueOf(value);
        }
    }

    private DBDDataFormatter getFormatter(DBSTypedObject typedObject, String typeId) {
        try {
            return this.formatterProfile.createFormatter(typeId, typedObject);
        }
        catch (Exception e) {
            log.error("Can't create formatter for datetime value handler", e);
            return DefaultDataFormatter.INSTANCE;
        }
    }

    @NotNull
    protected DBDDataFormatter getFormatter(DBSTypedObject column) {
        if (this.formatter == null) {
            this.formatter = this.getFormatter(column, this.getFormatterId(column));
        }
        return this.formatter;
    }

    @NotNull
    protected abstract String getFormatterId(DBSTypedObject var1);
}

