/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.sql.generator.GenerateSQLContributor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenObjectConsole;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorHandlerRunProcedureConsole
extends SQLEditorHandlerOpenObjectConsole {
    private static final Log log = Log.getLog(SQLEditorHandlerRunProcedureConsole.class);

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        SQLNavigatorContext navContext = null;
        String procName = null;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)currentSelection);
        ArrayList<DBSProcedure> entities = new ArrayList<DBSProcedure>();
        for (DBSObject object : selectedObjects) {
            if (!(object instanceof DBSProcedure)) continue;
            DBSProcedure proc = (DBSProcedure)object;
            procName = proc.getName();
            entities.add(proc);
            if (navContext != null) continue;
            navContext = new SQLNavigatorContext(object);
        }
        if (navContext == null || navContext.getDataSourceContainer() == null) {
            log.debug((Object)"No active datasource");
            return null;
        }
        GenerateSQLContributor.SQLGenerator<DBSProcedure> generator = GenerateSQLContributor.CALL_GENERATOR(entities);
        String title = "Stored procedures call";
        if (entities.size() == 1 && !CommonUtils.isEmpty((String)procName)) {
            title = String.valueOf(procName) + " call";
        }
        try {
            this.openConsole(workbenchWindow, generator, navContext, title, false, currentSelection);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Open console", "Can open SQL editor", (Throwable)e);
        }
        return null;
    }
}

