/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandListener;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.prop.DBECommandProperty;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAdapter;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICustomActionsProvider;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectEditorPageControl;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class TabbedFolderPageForm
extends TabbedFolderPage
implements IRefreshablePart,
ICustomActionsProvider {
    private static final Log log = Log.getLog(TabbedFolderPageForm.class);
    private static final String VALUE_KEY = "form.data.value";
    private static final String LIST_VALUE_KEY = "form.data.list.value";
    protected IWorkbenchPart part;
    protected ObjectEditorPageControl ownerControl;
    protected IDatabaseEditorInput input;
    private Font boldFont;
    private Composite propertiesGroup;
    private DBPPropertySource curPropertySource;
    private final Map<DBPPropertyDescriptor, Control> editorMap = new HashMap<DBPPropertyDescriptor, Control>();
    private boolean activated;
    private Button saveButton;
    private Button scriptButton;
    private Button revertButton;
    private Composite curButtonsContainer;
    private volatile transient boolean isLoading;

    public TabbedFolderPageForm(IWorkbenchPart part, ObjectEditorPageControl ownerControl, IDatabaseEditorInput input) {
        this.part = part;
        this.ownerControl = ownerControl;
        this.input = input;
    }

    public void createControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        this.propertiesGroup = new Composite(parent, 0);
        this.curPropertySource = this.input.getPropertySource();
        DBECommandContext commandContext = this.input.getCommandContext();
        if (commandContext != null) {
            commandContext.addCommandListener((DBECommandListener)new DBECommandAdapter(){

                public void onCommandChange(DBECommand<?> command) {
                    UIUtils.asyncExec(() -> {
                        TabbedFolderPageForm.this.updateEditButtonsState();
                        if (command instanceof DBECommandProperty) {
                            Object propId = ((DBECommandProperty)command).getHandler().getId();
                            TabbedFolderPageForm.this.updateOtherPropertyValues(propId);
                        }
                    });
                }

                public void onSave() {
                    UIUtils.asyncExec(() -> TabbedFolderPageForm.this.updateEditButtonsState());
                }

                public void onReset() {
                    UIUtils.asyncExec(() -> {
                        TabbedFolderPageForm.this.refreshProperties();
                        TabbedFolderPageForm.this.updateEditButtonsState();
                    });
                }
            });
        }
        this.propertiesGroup.addDisposeListener(e -> this.dispose());
        this.refreshProperties();
    }

    private void updateEditButtonsState() {
        if (this.saveButton == null || this.saveButton.isDisposed()) {
            return;
        }
        DBECommandContext commandContext = this.input.getCommandContext();
        boolean isDirty = commandContext != null && commandContext.isDirty();
        this.saveButton.setEnabled(isDirty);
        this.revertButton.setEnabled(isDirty);
        this.scriptButton.setEnabled(isDirty);
    }

    public void setFocus() {
        this.propertiesGroup.setFocus();
    }

    public void dispose() {
        if (this.curPropertySource != null && this.curPropertySource.getEditableValue() instanceof DBSObject) {
            this.curPropertySource = null;
        }
        UIUtils.dispose((Resource)this.boldFont);
        super.dispose();
    }

    private void refreshProperties() {
        if (this.curPropertySource == null) {
            return;
        }
        this.curPropertySource = this.input.getPropertySource();
        List<DBPPropertyDescriptor> allProps = this.filterProperties(this.curPropertySource.getPropertyDescriptors2());
        boolean firstInit = this.editorMap.isEmpty();
        if (firstInit) {
            ArrayList<Object> primaryProps = new ArrayList<Object>();
            ArrayList<DBPPropertyDescriptor> secondaryProps = new ArrayList<DBPPropertyDescriptor>();
            ArrayList<DBPPropertyDescriptor> specificProps = new ArrayList<DBPPropertyDescriptor>();
            if (this.isEditableObject()) {
                for (DBPPropertyDescriptor prop : allProps) {
                    if (prop.getId().equals("name") || prop.getId().equals("description") || prop.isEditable(this.curPropertySource.getEditableValue())) {
                        primaryProps.add(prop);
                        continue;
                    }
                    if (prop instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)prop).isSpecific()) {
                        specificProps.add(prop);
                        continue;
                    }
                    secondaryProps.add(prop);
                }
                if (primaryProps.isEmpty()) {
                    primaryProps.addAll(secondaryProps);
                    secondaryProps.clear();
                }
            } else {
                primaryProps.addAll(allProps);
            }
            boolean hasEditButtons = false;
            boolean hasSecondaryProps = !secondaryProps.isEmpty();
            boolean hasSpecificProps = !specificProps.isEmpty();
            int colCount = 1;
            if (hasEditButtons) {
                ++colCount;
            }
            if (hasSecondaryProps) {
                ++colCount;
            }
            if (hasSpecificProps) {
                ++colCount;
            }
            GridLayout propsLayout = new GridLayout(colCount, true);
            this.propertiesGroup.setLayout((Layout)propsLayout);
            Composite parent = this.propertiesGroup;
            int editorWidth = parent.getSize().x;
            while (editorWidth == 0 && parent != null) {
                editorWidth = parent.getSize().x;
                parent = parent.getParent();
            }
            int minGroupWidth = UIUtils.getFontHeight((Control)this.propertiesGroup) * 30;
            int maxGroupWidth = editorWidth * 33 / 100;
            int buttonPanelWidth = editorWidth / 10;
            if (maxGroupWidth < minGroupWidth) {
                maxGroupWidth = minGroupWidth;
                buttonPanelWidth = 0;
            }
            Composite primaryGroup = new Composite(this.propertiesGroup, 0);
            primaryGroup.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(1808);
            gd.widthHint = maxGroupWidth;
            primaryGroup.setLayoutData((Object)gd);
            Composite secondaryGroup = null;
            if (hasSecondaryProps) {
                secondaryGroup = new Composite(this.propertiesGroup, 0);
                secondaryGroup.setLayout((Layout)new GridLayout(2, false));
                gd = new GridData(1808);
                gd.widthHint = maxGroupWidth;
                secondaryGroup.setLayoutData((Object)gd);
            }
            Composite specificGroup = null;
            if (hasSpecificProps) {
                specificGroup = new Composite(this.propertiesGroup, 0);
                specificGroup.setLayout((Layout)new GridLayout(2, false));
                gd = new GridData(1808);
                gd.widthHint = maxGroupWidth;
                specificGroup.setLayoutData((Object)gd);
            }
            if (hasEditButtons) {
                Composite composite = new Composite(this.propertiesGroup, 0);
                gd = new GridData(2);
                gd.widthHint = buttonPanelWidth;
                composite.setLayoutData((Object)gd);
                RowLayout rowLayout = new RowLayout(512);
                rowLayout.pack = true;
                rowLayout.fill = true;
                composite.setLayout((Layout)rowLayout);
                this.saveButton = UIUtils.createPushButton((Composite)composite, (String)"Save", (Image)DBeaverIcons.getImage((DBPImage)UIIcon.SAVE), (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ActionUtils.runCommand((String)"org.eclipse.ui.file.save", (IServiceLocator)TabbedFolderPageForm.this.part.getSite());
                    }
                });
                this.scriptButton = UIUtils.createPushButton((Composite)composite, (String)"View script", (Image)DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT), (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TabbedFolderPageForm.this.showAlterScript();
                    }
                });
                this.revertButton = UIUtils.createPushButton((Composite)composite, (String)"Revert", (Image)DBeaverIcons.getImage((DBPImage)UIIcon.REVERT), (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ActionUtils.runCommand((String)"org.eclipse.ui.file.revert", (IServiceLocator)TabbedFolderPageForm.this.part.getSite());
                    }
                });
                this.saveButton.setEnabled(false);
                this.scriptButton.setEnabled(false);
                this.revertButton.setEnabled(false);
            }
            if (editorWidth > 1000) {
                Composite composite = UIUtils.createPlaceholder((Composite)this.propertiesGroup, (int)1);
                composite.setLayoutData((Object)new GridData(768));
                ++propsLayout.numColumns;
            }
            try {
                this.isLoading = true;
                for (DBPPropertyDescriptor dBPPropertyDescriptor : primaryProps) {
                    this.createPropertyEditor(primaryGroup, dBPPropertyDescriptor);
                }
                if (secondaryGroup != null) {
                    for (DBPPropertyDescriptor dBPPropertyDescriptor : secondaryProps) {
                        this.createPropertyEditor(secondaryGroup, dBPPropertyDescriptor);
                    }
                }
                if (specificGroup != null) {
                    for (DBPPropertyDescriptor dBPPropertyDescriptor : specificProps) {
                        this.createPropertyEditor(specificGroup, dBPPropertyDescriptor);
                    }
                }
            }
            finally {
                this.isLoading = false;
            }
        }
        this.refreshPropertyValues(allProps, firstInit);
    }

    private void showAlterScript() {
        EntityEditor ownerEditor = this.getOwnerEditor();
        if (ownerEditor != null) {
            ownerEditor.showChanges(false);
        }
    }

    private EntityEditor getOwnerEditor() {
        MultiPageEditorPart mainEditor;
        IWorkbenchPartSite site = this.part.getSite();
        if (site instanceof MultiPageEditorSite && (mainEditor = ((MultiPageEditorSite)site).getMultiPageEditor()) instanceof EntityEditor) {
            return (EntityEditor)mainEditor;
        }
        return null;
    }

    private void refreshPropertyValues(final List<DBPPropertyDescriptor> allProps, boolean disableControls) {
        DBSObject databaseObject = this.input.getDatabaseObject();
        if (databaseObject == null) {
            return;
        }
        disableControls = false;
        ControlEnableState blockEnableState = disableControls ? ControlEnableState.disable((Control)this.propertiesGroup) : null;
        this.ownerControl.runService(LoadingJob.createService((ILoadService)new DatabaseLoadService<Map<DBPPropertyDescriptor, Object>>("Load main properties", databaseObject.getDataSource()){

            public Map<DBPPropertyDescriptor, Object> evaluate(DBRProgressMonitor monitor) {
                DBPPropertySource propertySource = TabbedFolderPageForm.this.curPropertySource;
                monitor.beginTask("Load '" + DBValueFormatting.getDefaultValueDisplayString((Object)propertySource.getEditableValue(), (DBDDisplayFormat)DBDDisplayFormat.UI) + "' properties", allProps.size());
                HashMap<DBPPropertyDescriptor, Object> propValues = new HashMap<DBPPropertyDescriptor, Object>();
                for (DBPPropertyDescriptor prop : allProps) {
                    if (monitor.isCanceled()) break;
                    Object value = propertySource.getPropertyValue(monitor, prop.getId());
                    propValues.put(prop, value);
                    monitor.worked(1);
                }
                monitor.done();
                return propValues;
            }
        }, (ILoadVisualizer)this.ownerControl.createDefaultLoadVisualizer(editorValues -> {
            this.loadEditorValues((Map<DBPPropertyDescriptor, Object>)editorValues);
            if (blockEnableState != null) {
                blockEnableState.restore();
            }
        })));
    }

    private void updateOtherPropertyValues(Object excludePropId) {
        List<DBPPropertyDescriptor> allProps = this.filterProperties(this.curPropertySource.getPropertyDescriptors2());
        HashMap<DBPPropertyDescriptor, Object> propValues = new HashMap<DBPPropertyDescriptor, Object>();
        for (DBPPropertyDescriptor prop : allProps) {
            if (excludePropId != null && excludePropId.equals(prop.getId())) continue;
            Object value = this.curPropertySource.getPropertyValue(null, prop.getId());
            propValues.put(prop, value);
        }
        this.loadEditorValues(propValues);
    }

    private boolean isEditableObject() {
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = this.curPropertySource.getPropertyDescriptors2();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            if (prop.isEditable(this.curPropertySource.getEditableValue()) || prop.getId().equals("name") && this.supportsObjectRename()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean supportsObjectRename() {
        return DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(this.curPropertySource.getEditableValue().getClass(), DBEObjectRenamer.class) != null;
    }

    private void createPropertyEditor(Composite group, final DBPPropertyDescriptor prop) {
        boolean isReadOnlyCon;
        DBSObject databaseObject = this.input.getDatabaseObject();
        boolean bl = isReadOnlyCon = databaseObject == null || DBUtils.isReadOnly((DBSObject)databaseObject);
        if (prop == null) {
            UIUtils.createEmptyLabel((Composite)group, (int)2, (int)1);
        } else {
            boolean editable = !isReadOnlyCon && (prop.isEditable(this.curPropertySource.getEditableValue()) || prop.getId().equals("name") && this.supportsObjectRename());
            prop.getDataType();
            Object propertyValue = this.curPropertySource.getPropertyValue(null, prop.getId());
            if (propertyValue == null && prop instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)prop).isOptional()) {
                return;
            }
            Control editControl = this.createEditorControl(group, this.curPropertySource.getEditableValue(), prop, propertyValue, !editable);
            String propDescription = prop.getDescription();
            if (!CommonUtils.isEmpty((String)propDescription)) {
                editControl.setToolTipText(propDescription);
            }
            if (!(editControl instanceof Button)) {
                GridData gd = (GridData)editControl.getLayoutData();
                if (gd == null) {
                    gd = new GridData(34);
                    editControl.setLayoutData((Object)gd);
                }
                if (editControl instanceof Text || editControl instanceof Combo) {
                    gd.widthHint = Math.max(UIUtils.getFontHeight((Control)group) * 15, editControl.computeSize((int)-1, (int)-1).x);
                }
            }
            this.editorMap.put(prop, editControl);
            final Control finalEditControl = editControl;
            if (finalEditControl instanceof Combo) {
                ((Combo)finalEditControl).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TabbedFolderPageForm.this.updatePropertyValue(prop, ((Combo)finalEditControl).getText());
                    }
                });
            } else if (finalEditControl instanceof Text) {
                ((Text)finalEditControl).addModifyListener(e -> this.updatePropertyValue(prop, ((Text)finalEditControl).getText()));
            } else if (finalEditControl instanceof Button) {
                ((Button)finalEditControl).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TabbedFolderPageForm.this.updatePropertyValue(prop, ((Button)finalEditControl).getSelection());
                    }
                });
            }
        }
    }

    private void updatePropertyValue(DBPPropertyDescriptor prop, Object value) {
        if (!this.isLoading) {
            DBSObject databaseObject = this.input.getDatabaseObject();
            if (prop.getId().equals("name") && databaseObject.isPersisted()) {
                DBEObjectRenamer renamer = (DBEObjectRenamer)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(this.curPropertySource.getEditableValue().getClass(), DBEObjectRenamer.class);
                if (renamer != null) {
                    try {
                        renamer.renameObject(this.input.getCommandContext(), databaseObject, CommonUtils.toString((Object)value));
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error renaming object", e);
                    }
                }
            } else {
                Class dataType = prop.getDataType();
                if (value instanceof String) {
                    value = GeneralUtils.convertString((String)((String)value), (Class)dataType);
                }
                this.curPropertySource.getPropertyValue(null, prop.getId());
                this.curPropertySource.setPropertyValue(null, prop.getId(), value);
            }
        }
    }

    public Control createEditorControl(Composite parent, Object object, DBPPropertyDescriptor property, Object value, boolean readOnly) {
        Class propType;
        if (!readOnly && property instanceof IPropertyValueListProvider) {
            IPropertyValueListProvider listProvider = (IPropertyValueListProvider)property;
            Object[] items = listProvider.getPossibleValues(object);
            if (items == null && property instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)property).hasListValueProvider()) {
                items = new Object[]{};
            }
            if (items != null) {
                String[] strings = new String[items.length];
                int i = 0;
                int itemsLength = items.length;
                while (i < itemsLength) {
                    strings[i] = TabbedFolderPageForm.objectValueToString(items[i]);
                    ++i;
                }
                Combo combo = UIUtils.createLabelCombo((Composite)parent, (String)property.getDisplayName(), (int)(0x804 | (listProvider.allowCustomValue() ? 0 : 8) | (readOnly ? 8 : 0)));
                combo.setItems(strings);
                combo.setText(TabbedFolderPageForm.objectValueToString(value));
                combo.setLayoutData((Object)new GridData(34));
                if ((combo.getStyle() & 8) == 0) {
                    SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(strings);
                    proposalProvider.setFiltering(true);
                    UIUtils.installContentProposal((Control)combo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)proposalProvider, (boolean)true, (boolean)true);
                }
                return combo;
            }
        }
        if (TabbedFolderPageForm.isTextPropertyType(propType = property.getDataType())) {
            if (property instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)property).isMultiLine()) {
                Label label = UIUtils.createControlLabel((Composite)parent, (String)property.getDisplayName());
                label.setLayoutData((Object)new GridData(2));
                Text editor = new Text(parent, 0xA42 | (readOnly ? 8 : 0));
                editor.setText(TabbedFolderPageForm.objectValueToString(value));
                GridData gd = new GridData(1808);
                gd.heightHint = (UIUtils.getTextHeight((Control)editor) + editor.getBorderWidth()) * 2;
                editor.setLayoutData((Object)gd);
                return editor;
            }
            Text text = UIUtils.createLabelText((Composite)parent, (String)property.getDisplayName(), (String)TabbedFolderPageForm.objectValueToString(value), (int)(0x800 | (readOnly ? 8 : 0) | (property instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)property).isPassword() ? 0x400000 : 0)));
            text.setLayoutData((Object)new GridData((BeanUtils.isNumericType((Class)propType) ? 32 : 768) | 2));
            return text;
        }
        if (BeanUtils.isBooleanType((Type)propType)) {
            if (this.curButtonsContainer == null) {
                UIUtils.createEmptyLabel((Composite)parent, (int)1, (int)1);
                this.curButtonsContainer = new Composite(parent, 0);
                RowLayout layout = new RowLayout(256);
                this.curButtonsContainer.setLayout((Layout)layout);
                GridData gd = new GridData(768);
                this.curButtonsContainer.setLayoutData((Object)gd);
            }
            Button editor = UIUtils.createCheckbox((Composite)this.curButtonsContainer, (String)property.getDisplayName(), (String)"", (boolean)CommonUtils.toBoolean((Object)value), (int)1);
            if (readOnly) {
                editor.setEnabled(false);
            }
            return editor;
        }
        if (!readOnly && propType.isEnum()) {
            T[] enumConstants = propType.getEnumConstants();
            String[] strings = new String[enumConstants.length];
            int i = 0;
            int itemsLength = enumConstants.length;
            while (i < itemsLength) {
                strings[i] = ((Enum)enumConstants[i]).name();
                ++i;
            }
            Combo combo = UIUtils.createLabelCombo((Composite)parent, (String)property.getDisplayName(), (int)(0x80C | (readOnly ? 8 : 0)));
            combo.setItems(strings);
            combo.setText(TabbedFolderPageForm.objectValueToString(value));
            combo.setLayoutData((Object)new GridData(34));
            return combo;
        }
        if (DBSObject.class.isAssignableFrom(propType) || property instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)property).isLinkPossible()) {
            UIUtils.createControlLabel((Composite)parent, (String)property.getDisplayName());
            Composite linkPH = new Composite(parent, 0);
            linkPH.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            linkPH.setLayout((Layout)layout);
            final Link link = new Link(linkPH, 0);
            link.setText(this.getLinktitle(value));
            link.setData(value);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBSObject object = (DBSObject)link.getData();
                    if (object != null) {
                        NavigatorHandlerObjectOpen.openEntityEditor(object);
                    }
                }
            });
            link.setLayoutData((Object)new GridData(768));
            return link;
        }
        return UIUtils.createLabelText((Composite)parent, (String)property.getDisplayName(), (String)TabbedFolderPageForm.objectValueToString(value), (int)2056);
    }

    private String getLinktitle(Object value) {
        return value == null ? "N/A" : "<a>" + TabbedFolderPageForm.objectValueToString(value) + "</a>";
    }

    private void loadEditorValues(Map<DBPPropertyDescriptor, Object> editorValues) {
        try {
            this.isLoading = true;
            if (this.curPropertySource != null) {
                Object object = this.curPropertySource.getEditableValue();
                for (Map.Entry<DBPPropertyDescriptor, Object> prop : editorValues.entrySet()) {
                    this.setEditorValue(object, prop.getKey(), prop.getValue());
                }
            }
        }
        finally {
            this.isLoading = false;
        }
    }

    public void setEditorValue(Object object, DBPPropertyDescriptor property, Object value) {
        Control editorControl = this.editorMap.get(property);
        Class propertyType = property.getDataType();
        String stringValue = TabbedFolderPageForm.objectValueToString(value);
        if (editorControl instanceof Combo) {
            Combo combo = (Combo)editorControl;
            if (property instanceof IPropertyValueListProvider) {
                IPropertyValueListProvider listProvider = (IPropertyValueListProvider)property;
                Object[] items = listProvider.getPossibleValues(object);
                Object[] oldItems = (Object[])combo.getData(LIST_VALUE_KEY);
                combo.setData(LIST_VALUE_KEY, (Object)items);
                if (items != null) {
                    if (oldItems == null || !Arrays.equals(items, oldItems)) {
                        String[] strings = new String[items.length];
                        int i = 0;
                        int itemsLength = items.length;
                        while (i < itemsLength) {
                            strings[i] = items[i] instanceof DBPNamedObject ? ((DBPNamedObject)items[i]).getName() : CommonUtils.toString((Object)items[i]);
                            ++i;
                        }
                        combo.setItems(strings);
                    }
                    combo.setText(stringValue);
                }
            } else if (propertyType.isEnum()) {
                if (combo.getItemCount() == 0) {
                    T[] enumConstants = propertyType.getEnumConstants();
                    String[] strings = new String[enumConstants.length];
                    int i = 0;
                    int itemsLength = enumConstants.length;
                    while (i < itemsLength) {
                        strings[i] = ((Enum)enumConstants[i]).name();
                        ++i;
                    }
                    combo.setItems(strings);
                }
                combo.setText(stringValue);
            }
        } else if (editorControl instanceof Text) {
            Text text = (Text)editorControl;
            if (!CommonUtils.equalObjects((Object)text.getText(), (Object)stringValue)) {
                text.setText(stringValue);
            }
        } else if (editorControl instanceof Button) {
            ((Button)editorControl).setSelection(CommonUtils.toBoolean((Object)value));
        } else if (editorControl instanceof Link) {
            Link link = (Link)editorControl;
            link.setData(value);
            link.setText(this.getLinktitle(value));
        }
    }

    private static String objectValueToString(Object value) {
        if (value instanceof DBPNamedObject) {
            return ((DBPNamedObject)value).getName();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)DBDDisplayFormat.EDIT);
    }

    private static boolean isTextPropertyType(Class<?> propertyType) {
        return propertyType == null || CharSequence.class.isAssignableFrom(propertyType) || BeanUtils.isNumericType(propertyType);
    }

    private List<DBPPropertyDescriptor> filterProperties(DBPPropertyDescriptor[] props) {
        ArrayList<DBPPropertyDescriptor> result = new ArrayList<DBPPropertyDescriptor>();
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            String category = prop.getCategory();
            if (CommonUtils.isEmpty((String)category)) {
                result.add(prop);
            }
            ++n2;
        }
        return result;
    }

    public void refreshPart(Object source, boolean force) {
        if (force) {
            this.refreshProperties();
            this.updateEditButtonsState();
        }
    }

    public void aboutToBeShown() {
        if (!this.activated) {
            this.activated = true;
        }
    }

    public void fillCustomActions(IContributionManager contributionManager) {
    }
}

