/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.sql.task;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.model.sql.exec.SQLScriptProcessor;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTUtils;
import org.jkiss.dbeaver.tools.sql.SQLScriptExecuteSettings;
import org.jkiss.dbeaver.tools.sql.task.SQLScriptDataReceiver;
import org.jkiss.utils.IOUtils;

public class SQLScriptExecuteHandler
implements DBTTaskHandler {
    public void executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull Writer logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        SQLScriptExecuteSettings settings = new SQLScriptExecuteSettings();
        settings.loadConfiguration(runnableContext, task.getProperties());
        this.executeWithSettings(runnableContext, task, locale, log, logStream, listener, settings);
    }

    private void executeWithSettings(@NotNull DBRRunnableContext runnableContext, DBTTask task, @NotNull Locale locale, @NotNull Log log, Writer logStream, @NotNull DBTTaskExecutionListener listener, SQLScriptExecuteSettings settings) throws DBException {
        listener.taskStarted((Object)settings);
        log.debug((Object)"SQL Script Execute");
        DBPDataSourceContainer dataSourceContainer = settings.getDataSourceContainer();
        Throwable error = null;
        try {
            runnableContext.run(true, true, monitor -> {
                try {
                    this.runScripts(monitor, task, dataSourceContainer, settings, log, logStream);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException interruptedException) {
            log.debug((Object)"Task canceled");
        }
        if (error != null) {
            log.error((Object)error);
        }
        listener.taskFinished((Object)settings, error);
        log.debug((Object)"SQL script execute completed");
    }

    private void runScripts(DBRProgressMonitor monitor, DBTTask task, DBPDataSourceContainer dataSourceContainer, SQLScriptExecuteSettings settings, Log log, Writer logStream) throws DBException {
        DBPDataSource dataSource;
        if (!dataSourceContainer.isConnected()) {
            dataSourceContainer.connect(monitor, true, true);
        }
        if ((dataSource = dataSourceContainer.getDataSource()) == null) {
            throw new DBException("Can't obtain data source connection");
        }
        DBCExecutionContext executionContext = dataSource.getDefaultInstance().getDefaultContext(monitor, false);
        for (String filePath : settings.getScriptFiles()) {
            IFile sqlFile = SQLScriptExecuteSettings.getWorkspaceFile(filePath);
            try {
                Throwable throwable = null;
                Object var13_15 = null;
                try (InputStream sqlStream = sqlFile.getContents(true);){
                    Throwable throwable2 = null;
                    Object var16_20 = null;
                    try (InputStreamReader fileReader = new InputStreamReader(sqlStream, sqlFile.getCharset());){
                        String sqlScriptContent = IOUtils.readToString((Reader)fileReader);
                        try {
                            this.processScript(monitor, task, settings, executionContext, filePath, sqlScriptContent, log, logStream);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                Throwable error = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                throw new DBException("Error executing script '" + filePath + "'", error);
            }
        }
    }

    private void processScript(DBRProgressMonitor monitor, DBTTask task, SQLScriptExecuteSettings settings, DBCExecutionContext executionContext, String filePath, String sqlScriptContent, Log log, Writer logStream) throws DBException {
        List scriptElements = SQLScriptParser.parseScript((DBCExecutionContext)executionContext, (String)sqlScriptContent);
        SQLScriptContext scriptContext = new SQLScriptContext(null, () -> executionContext, null, logStream, null);
        scriptContext.setVariables(DBTUtils.getVariables((DBTTask)task));
        SQLScriptDataReceiver dataReceiver = new SQLScriptDataReceiver();
        SQLScriptProcessor scriptProcessor = new SQLScriptProcessor(executionContext, scriptElements, scriptContext, (DBDDataReceiver)dataReceiver, log);
        scriptProcessor.setCommitType(settings.isAutoCommit() ? SQLScriptCommitType.AUTOCOMMIT : SQLScriptCommitType.AT_END);
        scriptProcessor.setErrorHandling(settings.isIgnoreErrors() ? SQLScriptErrorHandling.IGNORE : SQLScriptErrorHandling.STOP_ROLLBACK);
        if (settings.isDumpQueryResultsToLog()) {
            dataReceiver.setDumpWriter(logStream);
        }
        scriptProcessor.runScript(monitor);
    }
}

