/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SQLScriptExecuteSettings {
    private static final Log log = Log.getLog(SQLScriptExecuteSettings.class);
    private List<String> scriptFiles = new ArrayList<String>();
    private DBPDataSourceContainer dataSourceContainer;
    private boolean autoCommit;
    private DBPTransactionIsolation transactionIsolation;
    private boolean ignoreErrors;
    private boolean dumpQueryResultsToLog;

    public List<String> getScriptFiles() {
        return this.scriptFiles;
    }

    public void setScriptFiles(List<String> scriptFiles) {
        this.scriptFiles = scriptFiles;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public void setDataSourceContainer(DBPDataSourceContainer dataSourceContainer) {
        this.dataSourceContainer = dataSourceContainer;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isDumpQueryResultsToLog() {
        return this.dumpQueryResultsToLog;
    }

    public void setDumpQueryResultsToLog(boolean dumpQueryResultsToLog) {
        this.dumpQueryResultsToLog = dumpQueryResultsToLog;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public DBPTransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(DBPTransactionIsolation transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void loadConfiguration(DBRRunnableContext runnableContext, Map<String, Object> config) {
        String dataSourceContainerId;
        DBPProject project;
        String projectName = JSONUtils.getString(config, (String)"project");
        DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
        if (project != null && !CommonUtils.isEmpty((String)(dataSourceContainerId = JSONUtils.getString(config, (String)"dataSourceContainer")))) {
            this.dataSourceContainer = project.getDataSourceRegistry().getDataSource(dataSourceContainerId);
        }
        this.scriptFiles = JSONUtils.deserializeStringList(config, (String)"scriptFiles");
        this.ignoreErrors = JSONUtils.getBoolean(config, (String)"ignoreErrors");
        this.dumpQueryResultsToLog = JSONUtils.getBoolean(config, (String)"dumpQueryResultsToLog");
        this.autoCommit = JSONUtils.getBoolean(config, (String)"autoCommit");
    }

    public void saveConfiguration(Map<String, Object> config) {
        config.put("project", this.dataSourceContainer == null ? null : this.dataSourceContainer.getProject().getName());
        config.put("dataSourceContainer", this.dataSourceContainer == null ? null : this.dataSourceContainer.getId());
        config.put("scriptFiles", this.scriptFiles);
        config.put("ignoreErrors", this.ignoreErrors);
        config.put("dumpQueryResultsToLog", this.dumpQueryResultsToLog);
        config.put("autoCommit", this.autoCommit);
    }

    public static IFile getWorkspaceFile(String filePath) {
        return DBWorkbench.getPlatform().getWorkspace().getEclipseWorkspace().getRoot().getFile((IPath)new Path(filePath));
    }
}

