/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.sql.ui.wizard;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTaskConfigPanel;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.sql.SQLScriptExecuteSettings;
import org.jkiss.dbeaver.tools.sql.ui.wizard.SQLTaskConfigurationWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.SelectDataSourceCombo;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;

class SQLTaskConfigPanel
implements DBTTaskConfigPanel {
    private DBRRunnableContext runnableContext;
    private DBTTaskType taskType;
    private DBPProject currentProject;
    private SQLTaskConfigurationWizard sqlWizard;
    private Runnable propertyChangeListener;
    private DBNResource selectedScript;
    private DBPProject selectedProject;
    private SelectDataSourceCombo dsSelectCombo;
    private DatabaseNavigatorTree scriptsTree;

    SQLTaskConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType) {
        this.runnableContext = runnableContext;
        this.taskType = taskType;
        this.currentProject = NavigatorUtils.getSelectedProject();
    }

    public void createControl(Object parent, Object wizard, Runnable propertyChangeListener) {
        this.sqlWizard = (SQLTaskConfigurationWizard)((Object)wizard);
        this.propertyChangeListener = propertyChangeListener;
        Group group = UIUtils.createControlGroup((Composite)((Composite)parent), (String)"SQL Script parameters", (int)2, (int)1808, (int)0);
        INavigatorFilter filter = null;
        this.scriptsTree = new DatabaseNavigatorTree((Composite)group, (DBNNode)DBWorkbench.getPlatform().getNavigatorModel().getRoot(), 2052, false, filter);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 300;
        this.scriptsTree.setLayoutData((Object)gd);
        this.scriptsTree.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TreeNodeSpecial) {
                    return true;
                }
                if (element instanceof DBNResource) {
                    return SQLTaskConfigPanel.this.isResourceApplicable((DBNResource)element);
                }
                return false;
            }
        });
        this.scriptsTree.getViewer().addSelectionChangedListener(event -> {
            Object firstElement;
            DBPProject oldSelectedProject = this.selectedProject;
            this.selectedProject = null;
            this.selectedScript = null;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof DBNResource) {
                this.selectedScript = (DBNResource)firstElement;
                this.selectedProject = this.selectedScript.getOwnerProject();
            }
            if (this.selectedProject != oldSelectedProject) {
                this.fillProjectDataSources();
            }
            this.updateDataSource();
        });
        UIUtils.createControlLabel((Composite)group, (String)"Datasource");
        this.dsSelectCombo = new SelectDataSourceCombo((Composite)group){

            protected DBPProject getActiveProject() {
                return SQLTaskConfigPanel.this.selectedProject == null ? NavigatorUtils.getSelectedProject() : SQLTaskConfigPanel.this.selectedProject;
            }
        };
    }

    private void fillProjectDataSources() {
        this.dsSelectCombo.removeAll();
        if (this.selectedProject != null) {
            for (DBPDataSourceContainer ds : this.selectedProject.getDataSourceRegistry().getDataSources()) {
                this.dsSelectCombo.addItem((Object)ds);
            }
        }
    }

    private boolean isResourceApplicable(DBNResource element) {
        IResource resource = element.getResource();
        if (resource instanceof IFolder) {
            return "script folder".equals(element.getNodeType());
        }
        return resource instanceof IContainer || resource instanceof IFile && "sql".equals(resource.getFileExtension());
    }

    private void updateDataSource() {
        Collection associatedDataSources;
        DBPDataSourceContainer ds = null;
        if (this.selectedScript != null && !CommonUtils.isEmpty((Collection)(associatedDataSources = this.selectedScript.getAssociatedDataSources()))) {
            ds = (DBPDataSourceContainer)associatedDataSources.iterator().next();
        }
        this.dsSelectCombo.select(ds);
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.run();
        }
    }

    private void updateSettings(Runnable propertyChangeListener) {
    }

    public void loadSettings() {
        DBPDataSourceContainer dataSourceContainer;
        SQLScriptExecuteSettings settings = this.sqlWizard.getSettings();
        List scriptFiles = settings.getScriptFiles();
        if (!scriptFiles.isEmpty()) {
            String filePath = (String)scriptFiles.get(0);
            IFile file = SQLScriptExecuteSettings.getWorkspaceFile((String)filePath);
            if (file != null) {
                this.currentProject = DBWorkbench.getPlatform().getWorkspace().getProject(file.getProject());
            }
            if (this.currentProject != null) {
                DBNResource resource;
                this.fillProjectDataSources();
                DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(this.currentProject);
                if (projectNode != null && (resource = projectNode.findResource((IResource)file)) != null) {
                    this.scriptsTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)resource), true);
                }
            }
        }
        if ((dataSourceContainer = settings.getDataSourceContainer()) != null) {
            this.dsSelectCombo.select((Object)dataSourceContainer);
        }
    }

    public void saveSettings() {
        if (this.sqlWizard == null) {
            return;
        }
        SQLScriptExecuteSettings settings = this.sqlWizard.getSettings();
        settings.setDataSourceContainer((DBPDataSourceContainer)this.dsSelectCombo.getSelectedItem());
        IResource resource = this.selectedScript.getResource();
        if (resource != null) {
            String filePath = resource.getFullPath().toString();
            settings.setScriptFiles(Collections.singletonList(filePath));
        } else {
            settings.setScriptFiles(Collections.emptyList());
        }
    }

    public boolean isComplete() {
        return this.selectedScript != null && this.dsSelectCombo.getSelectedItem() != null;
    }

    public String getErrorMessage() {
        if (this.selectedScript == null) {
            return "Select SQL script to execute";
        }
        if (this.dsSelectCombo.getSelectedItem() == null) {
            return "Select datasource";
        }
        return null;
    }
}

