/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public abstract class SQLTableColumnManager<OBJECT_TYPE extends DBSEntityAttribute, TABLE_TYPE extends DBSEntity>
extends SQLObjectEditor<OBJECT_TYPE, TABLE_TYPE> {
    public static final long DDL_FEATURE_OMIT_COLUMN_CLAUSE_IN_DROP = 1L;
    public static final String QUOTE = "'";
    protected final ColumnModifier<OBJECT_TYPE> DataTypeModifier = (monitor, column, sql, command) -> {
        String typeName = column.getTypeName();
        DBPDataKind dataKind = column.getDataKind();
        DBSDataType dataType = SQLTableColumnManager.findDataType(column.getDataSource(), typeName);
        sql.append(' ').append(typeName);
        if (dataType == null) {
            log.debug("Type name '" + typeName + "' is not supported by driver");
        } else {
            dataKind = dataType.getDataKind();
        }
        String modifiers = SQLUtils.getColumnTypeModifiers(column.getDataSource(), column, typeName, dataKind);
        if (modifiers != null) {
            sql.append(modifiers);
        }
    };
    protected final ColumnModifier<OBJECT_TYPE> NotNullModifier = (monitor, column, sql, command) -> {
        if (column.isRequired()) {
            sql.append(" NOT NULL");
        }
    };
    protected final ColumnModifier<OBJECT_TYPE> NullNotNullModifier = (monitor, column, sql, command) -> {
        StringBuilder stringBuilder = sql.append(column.isRequired() ? " NOT NULL" : " NULL");
    };
    protected final ColumnModifier<OBJECT_TYPE> NullNotNullModifierConditional = (monitor, column, sql, command) -> {
        if (command instanceof DBECommandComposite && ((DBECommandComposite)command).getProperty("required") == null) {
            return;
        }
        this.NullNotNullModifier.appendModifier(monitor, (DBSEntityAttribute)column, sql, command);
    };
    protected final ColumnModifier<OBJECT_TYPE> DefaultModifier = (monitor, column, sql, command) -> {
        String defaultValue = CommonUtils.toString((Object)column.getDefaultValue());
        if (!CommonUtils.isEmpty((String)defaultValue)) {
            DBPDataKind dataKind = column.getDataKind();
            boolean useQuotes = false;
            if (!defaultValue.startsWith(QUOTE) && !defaultValue.endsWith(QUOTE)) {
                char firstChar;
                if (useQuotes && defaultValue.trim().startsWith(QUOTE)) {
                    useQuotes = false;
                }
                if (dataKind == DBPDataKind.DATETIME && !Character.isLetter(firstChar = defaultValue.trim().charAt(0)) && firstChar != '(' && firstChar != '[') {
                    useQuotes = true;
                }
            }
            sql.append(" DEFAULT ");
            if (useQuotes) {
                sql.append(QUOTE);
            }
            sql.append(defaultValue);
            if (useQuotes) {
                sql.append(QUOTE);
            }
        }
    };

    protected ColumnModifier[] getSupportedModifiers(OBJECT_TYPE column, Map<String, Object> options) {
        return new ColumnModifier[]{this.DataTypeModifier, this.NotNullModifier, this.DefaultModifier};
    }

    @Override
    public boolean canEditObject(OBJECT_TYPE object) {
        DBSEntity table = object.getParentObject();
        return table != null && !DBUtils.isView(table);
    }

    @Override
    public boolean canCreateObject(Object container) {
        return container instanceof DBSTable && !((DBSTable)container).isView();
    }

    @Override
    public boolean canDeleteObject(OBJECT_TYPE object) {
        return this.canEditObject(object);
    }

    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected long getDDLFeatures(OBJECT_TYPE object) {
        return 0L;
    }

    private boolean hasDDLFeature(OBJECT_TYPE object, long feature) {
        return (this.getDDLFeatures(object) & feature) != 0L;
    }

    @Override
    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        DBSEntity table = ((DBSEntityAttribute)command.getObject()).getParentObject();
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table_column, "ALTER TABLE " + DBUtils.getObjectFullName(table, DBPEvaluationContext.DDL) + " ADD " + this.getNestedDeclaration(monitor, (TABLE_TYPE)table, (DBECommandAbstract<OBJECT_TYPE>)command, options)));
    }

    @Override
    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table_column, "ALTER TABLE " + DBUtils.getObjectFullName(((DBSEntityAttribute)command.getObject()).getParentObject(), DBPEvaluationContext.DDL) + " DROP " + (this.hasDDLFeature((DBSEntityAttribute)command.getObject(), 1L) ? "" : "COLUMN ") + DBUtils.getQuotedIdentifier((DBSObject)command.getObject())));
    }

    protected String getNewColumnName(DBRProgressMonitor monitor, DBECommandContext context, TABLE_TYPE table) {
        int i = 1;
        while (true) {
            String name = DBObjectNameCaseTransformer.transformName(table.getDataSource(), "Column" + i);
            try {
                boolean exists;
                boolean bl = exists = table.getAttribute(monitor, name) != null;
                if (!exists) {
                    for (DBPObject contextObject : context.getEditedObjects()) {
                        if (!(contextObject instanceof DBSEntityAttribute) || ((DBSEntityAttribute)contextObject).getParentObject() != table || !name.equalsIgnoreCase(((DBSEntityAttribute)contextObject).getName())) continue;
                        exists = true;
                        break;
                    }
                }
                if (!exists) {
                    return name;
                }
            }
            catch (DBException e) {
                log.warn(e);
                return name;
            }
            ++i;
        }
    }

    @Override
    protected StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, TABLE_TYPE owner, DBECommandAbstract<OBJECT_TYPE> command, Map<String, Object> options) {
        DBSEntityAttribute column = (DBSEntityAttribute)command.getObject();
        String columnName = DBUtils.getQuotedIdentifier(column.getDataSource(), column.getName());
        if (command instanceof SQLObjectEditor.ObjectRenameCommand) {
            columnName = DBUtils.getQuotedIdentifier(column.getDataSource(), ((SQLObjectEditor.ObjectRenameCommand)command).getNewName());
        }
        StringBuilder decl = new StringBuilder(40);
        decl.append(columnName);
        ColumnModifier[] columnModifierArray = this.getSupportedModifiers(column, options);
        int n = columnModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnModifier modifier = columnModifierArray[n2];
            modifier.appendModifier(monitor, column, decl, command);
            ++n2;
        }
        return decl;
    }

    @Override
    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((DBSEntityAttribute)command.getObject()).getName())) {
            throw new DBException("Column name cannot be empty");
        }
        if (CommonUtils.isEmpty((String)((DBSEntityAttribute)command.getObject()).getTypeName())) {
            throw new DBException("Column type name cannot be empty");
        }
    }

    private static DBSDataType findDataType(DBPDataSource dataSource, String typeName) {
        if (dataSource instanceof DBPDataTypeProvider) {
            return ((DBPDataTypeProvider)((Object)dataSource)).getLocalDataType(typeName);
        }
        return null;
    }

    protected static DBSDataType findBestDataType(DBPDataSource dataSource, String ... typeNames) {
        if (dataSource instanceof DBPDataTypeProvider) {
            return DBUtils.findBestDataType(((DBPDataTypeProvider)((Object)dataSource)).getLocalDataTypes(), typeNames);
        }
        return null;
    }

    protected static interface ColumnModifier<OBJECT_TYPE extends DBPObject> {
        public void appendModifier(DBRProgressMonitor var1, OBJECT_TYPE var2, StringBuilder var3, DBECommandAbstract<OBJECT_TYPE> var4);
    }
}

