/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DefaultServerOutputReader;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;

public class AsyncServerOutputReader
extends DefaultServerOutputReader {
    @Override
    public boolean isAsyncOutputReadSupported() {
        return true;
    }

    @Override
    public void readServerOutput(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, SQLQueryResult queryResult, DBCStatement statement, @NotNull PrintWriter output) throws DBCException {
        if (statement == null) {
            super.readServerOutput(monitor, context, queryResult, null, output);
        } else {
            Throwable[] statementWarnings;
            try {
                SQLWarning connWarning = ((JDBCSession)statement.getSession()).getWarnings();
                if (connWarning != null) {
                    this.dumpWarnings(output, Collections.singletonList(connWarning));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if ((statementWarnings = statement.getStatementWarnings()) != null && statementWarnings.length > 0) {
                this.dumpWarnings(output, Arrays.asList(statementWarnings));
            }
        }
    }
}

