/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;

public abstract class AbstractSimpleDataSource<EXEC_CONTEXT extends DBCExecutionContext>
implements DBPDataSource,
DBSInstance,
DBSObjectContainer,
DBSObject {
    @NotNull
    private final DBPDataSourceContainer container;
    protected EXEC_CONTEXT executionContext;
    @NotNull
    protected List<EXEC_CONTEXT> allContexts = new ArrayList<EXEC_CONTEXT>();

    public AbstractSimpleDataSource(@NotNull DBPDataSourceContainer container) {
        this.container = container;
    }

    @Override
    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this;
    }

    @Override
    public DBSObject getParentObject() {
        return this.container;
    }

    @Override
    @NotNull
    public String getName() {
        return this.container.getName();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public EXEC_CONTEXT getDefaultContext(DBRProgressMonitor monitor, boolean meta) {
        return this.executionContext;
    }

    public EXEC_CONTEXT getDefaultContext() {
        return this.executionContext;
    }

    @Override
    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return this.allContexts.toArray(new DBCExecutionContext[0]);
    }

    @NotNull
    public abstract EXEC_CONTEXT openIsolatedContext(@NotNull DBRProgressMonitor var1, @NotNull String var2, @Nullable DBCExecutionContext var3) throws DBException;

    public void addExecutionContext(EXEC_CONTEXT context) {
        this.allContexts.add(context);
    }

    public void removeExecutionContext(EXEC_CONTEXT context) {
        this.allContexts.remove(context);
    }

    @Override
    @NotNull
    public DBSInstance getDefaultInstance() {
        return this;
    }

    @Override
    @NotNull
    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singletonList(this);
    }
}

