/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec;

import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.net.DBWForwarder;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;
import org.jkiss.dbeaver.runtime.net.GlobalProxyAuthenticator;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBExecUtils {
    public static final int DEFAULT_READ_FETCH_SIZE = 10000;
    private static final Log log = Log.getLog(DBExecUtils.class);
    private static final ThreadLocal<DBPDataSourceContainer> ACTIVE_CONTEXT = new ThreadLocal();
    private static final List<DBPDataSourceContainer> ACTIVE_CONTEXTS = new ArrayList<DBPDataSourceContainer>();
    private static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;

    public static DBPDataSourceContainer getCurrentThreadContext() {
        return ACTIVE_CONTEXT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DBPDataSourceContainer> getActiveContexts() {
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            return new ArrayList<DBPDataSourceContainer>(ACTIVE_CONTEXTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.set(context);
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.add(context);
        }
        boolean hasProxy = false;
        for (DBWHandlerConfiguration handler : context.getConnectionConfiguration().getHandlers()) {
            if (!handler.isEnabled() || handler.getType() != DBWHandlerType.PROXY) continue;
            hasProxy = true;
            break;
        }
        if (hasProxy) {
            Authenticator.setDefault(new GlobalProxyAuthenticator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.remove();
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBPDataSourceContainer findConnectionContext(String host, int port, String path) {
        DBPDataSourceContainer curContext = DBExecUtils.getCurrentThreadContext();
        if (curContext != null) {
            return DBExecUtils.contextMatches(host, port, curContext) ? curContext : null;
        }
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            for (DBPDataSourceContainer ctx : ACTIVE_CONTEXTS) {
                if (!DBExecUtils.contextMatches(host, port, ctx)) continue;
                return ctx;
            }
        }
        return null;
    }

    private static boolean contextMatches(String host, int port, DBPDataSourceContainer ctx) {
        DBPConnectionConfiguration cfg = ctx.getConnectionConfiguration();
        if (CommonUtils.equalObjects((Object)cfg.getHostName(), (Object)host) && String.valueOf(port).equals(cfg.getHostPort())) {
            return true;
        }
        DBWNetworkHandler[] dBWNetworkHandlerArray = ctx.getActiveNetworkHandlers();
        int n = dBWNetworkHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBWNetworkHandler networkHandler = dBWNetworkHandlerArray[n2];
            if (networkHandler instanceof DBWForwarder && ((DBWForwarder)((Object)networkHandler)).matchesParameters(host, port)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @NotNull
    public static DBPErrorAssistant.ErrorType discoverErrorType(@NotNull DBPDataSource dataSource, @NotNull Throwable error) {
        DBPErrorAssistant errorAssistant = DBUtils.getAdapter(DBPErrorAssistant.class, dataSource);
        if (errorAssistant != null) {
            return ((DBPErrorAssistant)((Object)dataSource)).discoverErrorType(error);
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    public static <T> boolean tryExecuteRecover(@NotNull T param, @NotNull DBPDataSource dataSource, @NotNull DBRRunnableParametrized<T> runnable) throws DBException {
        int tryCount = 1;
        boolean recoverEnabled = dataSource.getContainer().getPreferenceStore().getBoolean("execute.recover.enabled");
        if (recoverEnabled) {
            tryCount += dataSource.getContainer().getPreferenceStore().getInt("execute.recover.retryCount");
        }
        Throwable lastError = null;
        int i = 0;
        while (i < tryCount) {
            try {
                runnable.run(param);
                lastError = null;
                break;
            }
            catch (InvocationTargetException e) {
                DBPErrorAssistant.ErrorType errorType;
                lastError = e.getTargetException();
                if (!recoverEnabled || (errorType = DBExecUtils.discoverErrorType(dataSource, lastError)) != DBPErrorAssistant.ErrorType.TRANSACTION_ABORTED && errorType != DBPErrorAssistant.ErrorType.CONNECTION_LOST) break;
                DBRProgressMonitor monitor = param instanceof DBRProgressMonitor ? (DBRProgressMonitor)param : (param instanceof DBCSession ? ((DBCSession)param).getProgressMonitor() : new VoidProgressMonitor());
                if (!monitor.isCanceled()) {
                    if (errorType == DBPErrorAssistant.ErrorType.TRANSACTION_ABORTED) {
                        DBCExecutionContext executionContext = null;
                        if (lastError instanceof DBCException) {
                            executionContext = ((DBCException)lastError).getExecutionContext();
                        }
                        if (executionContext != null) {
                            log.debug("Invalidate context [" + executionContext.getDataSource().getContainer().getName() + "/" + executionContext.getContextName() + "] transactions");
                        } else {
                            log.debug("Invalidate datasource [" + dataSource.getContainer().getName() + "] transactions");
                        }
                        InvalidateJob.invalidateTransaction(monitor, dataSource, executionContext);
                    } else {
                        log.debug("Invalidate datasource '" + dataSource.getContainer().getName() + "' connections...");
                        InvalidateJob.invalidateDataSource(monitor, dataSource, false, true, () -> DBWorkbench.getPlatformUI().openConnectionEditor(dataSource.getContainer()));
                        if (i < tryCount - 1) {
                            log.error("Operation failed. Retry count remains = " + (tryCount - i - 1), lastError);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                log.error("Operation interrupted");
                return false;
            }
            ++i;
        }
        if (lastError != null) {
            if (lastError instanceof DBException) {
                throw (DBException)lastError;
            }
            throw new DBException(lastError, dataSource);
        }
        return true;
    }

    public static void setStatementFetchSize(DBCStatement dbStat, long firstRow, long maxRows, int fetchSize) {
        boolean useFetchSize;
        boolean bl = useFetchSize = fetchSize > 0 || dbStat.getSession().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.fetch.size");
        if (useFetchSize) {
            if (fetchSize <= 0) {
                fetchSize = 10000;
            }
            try {
                dbStat.setResultsFetchSize(firstRow < 0L || maxRows <= 0L ? fetchSize : (int)(firstRow + maxRows));
            }
            catch (Exception e) {
                log.warn(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void executeScript(DBRProgressMonitor monitor, DBCExecutionContext executionContext, String jobName, List<DBEPersistAction> persistActions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkSmartAutoCommit(DBCSession session, String queryText) {
        DBCTransactionManager txnManager = DBUtils.getTransactionManager(session.getExecutionContext());
        if (txnManager != null) {
            try {
                if (!txnManager.isAutoCommit()) {
                    return;
                }
                SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(session.getDataSource());
                if (!sqlDialect.isTransactionModifyingQuery(queryText)) {
                    return;
                }
                if (txnManager.isAutoCommit()) {
                    txnManager.setAutoCommit(session.getProgressMonitor(), false);
                }
            }
            catch (DBCException e) {
                log.warn(e);
            }
        }
    }

    public static void setExecutionContextDefaults(DBRProgressMonitor monitor, DBPDataSource dataSource, DBCExecutionContext executionContext, @Nullable String newInstanceName, @Nullable String curInstanceName, @Nullable String newObjectName) throws DBException {
        DBSObjectContainer rootContainer = DBUtils.getAdapter(DBSObjectContainer.class, dataSource);
        if (rootContainer == null) {
            return;
        }
        DBCExecutionContextDefaults contextDefaults = null;
        if (executionContext != null) {
            contextDefaults = executionContext.getContextDefaults();
        }
        if (contextDefaults != null && (contextDefaults.supportsSchemaChange() || contextDefaults.supportsCatalogChange())) {
            DBExecUtils.changeDefaultObject(monitor, rootContainer, contextDefaults, newInstanceName, curInstanceName, newObjectName);
        }
    }

    public static void changeDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer rootContainer, @NotNull DBCExecutionContextDefaults contextDefaults, @Nullable String newCatalogName, @Nullable String curCatalogName, @Nullable String newObjectName) throws DBException {
        boolean changeCatalog;
        DBSObject newInstance;
        DBSObjectContainer newCatalog = null;
        DBSSchema newSchema = null;
        if (newCatalogName != null && (newInstance = rootContainer.getChild(monitor, newCatalogName)) instanceof DBSCatalog) {
            newCatalog = (DBSCatalog)newInstance;
        }
        if (newObjectName != null) {
            DBSObject newObject = newCatalog == null ? rootContainer.getChild(monitor, newObjectName) : newCatalog.getChild(monitor, newObjectName);
            if (newObject instanceof DBSSchema) {
                newSchema = (DBSSchema)newObject;
            } else if (newObject instanceof DBSCatalog) {
                newCatalog = (DBSCatalog)newObject;
            }
        }
        boolean bl = curCatalogName != null ? !CommonUtils.equalObjects((Object)curCatalogName, (Object)newCatalogName) : (changeCatalog = newCatalog != null);
        if (newCatalog != null && newSchema != null && changeCatalog) {
            contextDefaults.setDefaultCatalog(monitor, newCatalog, newSchema);
        } else if (newSchema != null) {
            contextDefaults.setDefaultSchema(monitor, newSchema);
        } else if (newCatalog != null && changeCatalog) {
            contextDefaults.setDefaultCatalog(monitor, newCatalog, null);
        }
    }

    public static void recoverSmartCommit(DBCExecutionContext executionContext) {
        DBCTransactionManager transactionManager;
        DBPPreferenceStore preferenceStore = executionContext.getDataSource().getContainer().getPreferenceStore();
        if (preferenceStore.getBoolean("transaction.smart.commit") && preferenceStore.getBoolean("transaction.smart.commit.recover") && (transactionManager = DBUtils.getTransactionManager(executionContext)) != null) {
            new AbstractJob("Recover smart commit mode"){

                @Override
                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        if (!transactionManager.isAutoCommit()) {
                            transactionManager.setAutoCommit(monitor, true);
                        }
                    }
                    catch (DBCException e) {
                        return GeneralUtils.makeExceptionStatus(e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;
        }
        int[] nArray = new int[DBPPlatformUI.UserResponse.values().length];
        try {
            nArray[DBPPlatformUI.UserResponse.CANCEL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE_ALL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.RETRY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.STOP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse = nArray;
        return nArray;
    }
}

