/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.sql;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;

class OracleDialectRules
implements TPRuleProvider {
    OracleDialectRules() {
    }

    public void extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull List<TPRule> rules, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.INITIAL || position == TPRuleProvider.RulePosition.PARTITION) {
            rules.add((TPRule)new QStringRule());
        }
    }

    private static class QStringRule
    implements TPPredicateRule {
        private final TPToken stringToken;
        private char quoteStartChar = (char)65535;

        QStringRule() {
            this.stringToken = new TPTokenDefault((TPTokenType)SQLTokenType.T_STRING);
        }

        private TPToken doEvaluate(TPCharacterScanner scanner, boolean resume) {
            int c;
            int n = c = resume ? 113 : scanner.read();
            if (c == 81 || c == 113) {
                int n2 = c = resume ? 39 : scanner.read();
                if (c == 39) {
                    boolean quoteCharRead = false;
                    if (resume && this.quoteStartChar != '\uffffffff') {
                        quoteCharRead = true;
                    }
                    if (!quoteCharRead) {
                        this.quoteStartChar = (char)scanner.read();
                    }
                    if (!Character.isLetterOrDigit(this.quoteStartChar)) {
                        boolean isQuote;
                        int charsRead;
                        block13: {
                            int quoteEndChar = QStringRule.getQuoteEndChar(this.quoteStartChar);
                            charsRead = 0;
                            isQuote = true;
                            while (true) {
                                c = scanner.read();
                                ++charsRead;
                                if (c == quoteEndChar) {
                                    c = scanner.read();
                                    ++charsRead;
                                    if (c != 39) continue;
                                    break block13;
                                }
                                if (c == -1) break;
                            }
                            isQuote = false;
                        }
                        if (isQuote) {
                            return this.stringToken;
                        }
                        int i = 0;
                        while (i < charsRead) {
                            scanner.unread();
                            ++i;
                        }
                    } else {
                        this.quoteStartChar = (char)65535;
                        if (quoteCharRead) {
                            scanner.unread();
                        }
                    }
                } else {
                    scanner.unread();
                }
            } else {
                scanner.unread();
            }
            return TPTokenAbstract.UNDEFINED;
        }

        private static char getQuoteEndChar(char startChar) {
            switch (startChar) {
                case '<': {
                    return '>';
                }
                case '(': {
                    return ')';
                }
                case '[': {
                    return ']';
                }
                case '{': {
                    return '}';
                }
            }
            return startChar;
        }

        public TPToken getSuccessToken() {
            return this.stringToken;
        }

        public TPToken evaluate(TPCharacterScanner scanner) {
            return this.doEvaluate(scanner, false);
        }

        public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
            return this.doEvaluate(scanner, resume);
        }
    }
}

