/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleMaterializedView;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class OracleMaterializedViewManager
extends SQLObjectEditor<OracleMaterializedView, OracleSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((OracleMaterializedView)command.getObject()).getName())) {
            throw new DBException("View name cannot be empty");
        }
        if (CommonUtils.isEmpty((String)((OracleMaterializedView)command.getObject()).getObjectDefinitionText(null, DBPScriptObject.EMPTY_OPTIONS))) {
            throw new DBException("View definition cannot be empty");
        }
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleMaterializedView> getObjectsCache(OracleMaterializedView object) {
        return object.getSchema().mviewCache;
    }

    protected OracleMaterializedView createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        OracleMaterializedView newView = new OracleMaterializedView((OracleSchema)container, "NewView");
        newView.setObjectDefinitionText("SELECT 1 FROM DUAL");
        return newView;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actions, (DBECommandComposite<OracleMaterializedView, SQLObjectEditor.PropertyHandler>)command);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actionList, (DBECommandComposite<OracleMaterializedView, SQLObjectEditor.PropertyHandler>)command);
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP MATERIALIZED VIEW " + ((OracleMaterializedView)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    private void createOrReplaceViewQuery(List<DBEPersistAction> actions, DBECommandComposite<OracleMaterializedView, SQLObjectEditor.PropertyHandler> command) {
        boolean hasComment;
        OracleMaterializedView view = (OracleMaterializedView)command.getObject();
        StringBuilder decl = new StringBuilder(200);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        boolean bl = hasComment = command.getProperty((Object)"comment") != null;
        if (!hasComment || command.getProperties().size() > 1) {
            decl.append("CREATE MATERIALIZED VIEW ").append(view.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(lineSeparator).append("AS ").append(view.getObjectDefinitionText(null, DBPScriptObject.EMPTY_OPTIONS));
            if (view.isPersisted()) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP MATERIALIZED VIEW " + view.getFullyQualifiedName(DBPEvaluationContext.DDL)));
            }
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", decl.toString()));
        }
        if (hasComment) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON MATERIALIZED VIEW " + view.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS '" + view.getComment() + "'"));
        }
    }
}

