/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAccessMethod;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAvailableExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeCache;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExecutionContext;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignDataWrapper;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstanceLazy;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.LongKeyMap;

public class PostgreDatabase
extends JDBCRemoteInstance
implements DBSCatalog,
DBPRefreshableObject,
DBPStatefulObject,
DBPNamedObject2,
PostgreObject,
DBPDataTypeProvider,
DBSInstanceLazy {
    private static final Log log = Log.getLog(PostgreDatabase.class);
    private transient PostgreRole initialOwner;
    private transient PostgreTablespace initialTablespace;
    private transient PostgreCharset initialEncoding;
    private long oid;
    private String name;
    private long ownerId;
    private String templateName;
    private long encodingId;
    private String collate;
    private String ctype;
    private boolean isTemplate;
    private boolean allowConnect;
    private int connectionLimit;
    private long tablespaceId;
    private String description;
    public final RoleCache roleCache = new RoleCache();
    public final AccessMethodCache accessMethodCache = new AccessMethodCache();
    public final ForeignDataWrapperCache foreignDataWrapperCache = new ForeignDataWrapperCache();
    public final ForeignServerCache foreignServerCache = new ForeignServerCache();
    public final LanguageCache languageCache = new LanguageCache();
    public final EncodingCache encodingCache = new EncodingCache();
    public final ExtensionCache extensionCache = new ExtensionCache();
    public final AvailableExtensionCache availableExtensionCache = new AvailableExtensionCache();
    public final CollationCache collationCache = new CollationCache();
    public final TablespaceCache tablespaceCache = new TablespaceCache();
    public final LongKeyMap<PostgreDataType> dataTypeCache = new LongKeyMap();
    public JDBCObjectLookupCache<PostgreDatabase, PostgreSchema> schemaCache;

    public PostgreDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, ResultSet dbResult) throws DBException {
        super(monitor, (JDBCDataSource)dataSource, false);
        this.initCaches();
        this.loadInfo(dbResult);
    }

    @NotNull
    public PostgreExecutionContext getDefaultContext() {
        return (PostgreExecutionContext)super.getDefaultContext(true);
    }

    private void initCaches() {
        this.schemaCache = this.getDataSource().getServerType().createSchemaCache(this);
    }

    public PostgreDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, String databaseName) throws DBException {
        super(monitor, (JDBCDataSource)dataSource, false);
        this.name = databaseName;
        this.initCaches();
        this.checkInstanceConnection(monitor);
        try {
            this.readDatabaseInfo(monitor);
        }
        catch (DBCException e) {
            log.debug((Object)"Error reading database info", (Throwable)e);
        }
    }

    public PostgreDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, String name, PostgreRole owner, String templateName, PostgreTablespace tablespace, PostgreCharset encoding) throws DBException {
        super(monitor, (JDBCDataSource)dataSource, false);
        this.name = name;
        this.initialOwner = owner;
        this.initialTablespace = tablespace;
        this.initialEncoding = encoding;
        this.ownerId = owner == null ? 0L : owner.getObjectId();
        this.templateName = templateName;
        this.tablespaceId = tablespace == null ? 0L : tablespace.getObjectId();
        this.encodingId = encoding == null ? 0L : encoding.getObjectId();
        this.initCaches();
    }

    private void readDatabaseInfo(DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = this.getDefaultContext().openSession(monitor, DBCExecutionPurpose.META, "Load database info");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT db.oid,db.*\nFROM pg_catalog.pg_database db WHERE datname=?");){
                    dbStat.setString(1, this.name);
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.nextRow()) {
                            this.loadInfo((ResultSet)dbResult);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public PostgreRole getInitialOwner() {
        return this.initialOwner;
    }

    public void setInitialOwner(PostgreRole initialOwner) {
        this.initialOwner = initialOwner;
    }

    public PostgreTablespace getInitialTablespace() {
        return this.initialTablespace;
    }

    public void setInitialTablespace(PostgreTablespace initialTablespace) {
        this.initialTablespace = initialTablespace;
    }

    public PostgreCharset getInitialEncoding() {
        return this.initialEncoding;
    }

    public void setInitialEncoding(PostgreCharset initialEncoding) {
        this.initialEncoding = initialEncoding;
    }

    public void checkInstanceConnection(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.executionContext == null) {
            this.initializeMainContext(monitor);
            this.initializeMetaContext(monitor);
        }
    }

    public boolean isInstanceConnected() {
        return this.metaContext != null || this.executionContext != null;
    }

    private void loadInfo(ResultSet dbResult) {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datname");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"datdba");
        this.encodingId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"encoding");
        if (this.dataSource.isServerVersionAtLeast(8, 4)) {
            this.collate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datcollate");
            this.ctype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datctype");
        }
        this.isTemplate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"datistemplate");
        this.allowConnect = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"datallowconn");
        this.connectionLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"datconnlimit");
        this.tablespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"dattablespace");
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=true, multiline=true, order=100)
    public String getDescription(DBRProgressMonitor monitor) {
        if (!this.getDataSource().getServerType().supportsDatabaseDescription()) {
            return null;
        }
        if (this.description != null) {
            return this.description;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this.getDataSource(), (String)"Read database description");){
                this.description = JDBCUtils.queryString((JDBCSession)session, (String)"select description from pg_shdescription join pg_database on objoid = pg_database.oid where datname = ?", (Object[])new Object[]{this.getName()});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Error reading database description ", (Throwable)e);
        }
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    public boolean isActiveDatabase() {
        return this.dataSource.getDefaultInstance() == this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Property(editable=true, updatable=true, order=3, listProvider=RoleListProvider.class)
    @Nullable
    public PostgreRole getDBA(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.getRoleById(monitor, this.ownerId);
    }

    public void setDBA(PostgreRole owner) {
        this.ownerId = owner.getObjectId();
    }

    @Nullable
    public PostgreRole getRoleById(DBRProgressMonitor monitor, long roleId) throws DBException {
        if (!this.getDataSource().getServerType().supportsRoles()) {
            return null;
        }
        this.checkInstanceConnection(monitor);
        return (PostgreRole)PostgreUtils.getObjectById(monitor, this.roleCache, this, roleId);
    }

    @Nullable
    public PostgreRole getRoleByName(DBRProgressMonitor monitor, PostgreDatabase owner, String roleName) throws DBException {
        if (!this.getDataSource().getServerType().supportsRoles()) {
            return null;
        }
        this.checkInstanceConnection(monitor);
        return (PostgreRole)this.roleCache.getObject(monitor, owner, roleName);
    }

    @Property(editable=false, updatable=false, order=5)
    public PostgreCharset getDefaultEncoding(DBRProgressMonitor monitor) throws DBException {
        if (!this.getDataSource().getServerType().supportsEncodings()) {
            return null;
        }
        this.checkInstanceConnection(monitor);
        return (PostgreCharset)PostgreUtils.getObjectById(monitor, this.encodingCache, this, this.encodingId);
    }

    public void setDefaultEncoding(PostgreCharset charset) throws DBException {
        this.encodingId = charset.getObjectId();
    }

    @Property(order=10)
    public String getCollate() {
        return this.collate;
    }

    @Property(order=11)
    public String getCtype() {
        return this.ctype;
    }

    @Property(order=12)
    public boolean isTemplate() {
        return this.isTemplate;
    }

    @Property(order=13)
    public boolean isAllowConnect() {
        return this.allowConnect;
    }

    @Property(order=14)
    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    @Association
    public Collection<PostgreRole> getAuthIds(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.roleCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreAccessMethod> getAccessMethods(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.accessMethodCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreForeignDataWrapper> getForeignDataWrappers(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.foreignDataWrapperCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreForeignServer> getForeignServers(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.foreignServerCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreLanguage> getLanguages(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.languageCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreCharset> getEncodings(DBRProgressMonitor monitor) throws DBException {
        if (!this.getDataSource().getServerType().supportsEncodings()) {
            return null;
        }
        this.checkInstanceConnection(monitor);
        return this.encodingCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreExtension> getExtensions(DBRProgressMonitor monitor) throws DBException {
        return this.extensionCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreAvailableExtension> getAvailableExtensions(DBRProgressMonitor monitor) throws DBException {
        return this.availableExtensionCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreCollation> getCollations(DBRProgressMonitor monitor) throws DBException {
        return this.collationCache.getAllObjects(monitor, this);
    }

    @Association
    public PostgreCollation getCollation(DBRProgressMonitor monitor, long id) throws DBException {
        for (PostgreCollation collation : this.collationCache.getAllObjects(monitor, this)) {
            if (collation.getObjectId() != id) continue;
            return collation;
        }
        log.debug((Object)("Collation '" + id + "' not found in schema " + this.getName()));
        return null;
    }

    public DBPDataKind resolveDataKind(String typeName, int typeID) {
        return this.dataSource.resolveDataKind(typeName, typeID);
    }

    public DBSDataType resolveDataType(DBRProgressMonitor monitor, String typeFullName) throws DBException {
        return this.dataSource.resolveDataType(monitor, typeFullName);
    }

    public Collection<PostgreDataType> getLocalDataTypes() {
        PostgreSchema schema = this.getCatalogSchema();
        if (schema != null) {
            return schema.dataTypeCache.getCachedObjects();
        }
        return null;
    }

    public PostgreDataType getLocalDataType(String typeName) {
        return this.getDataType(null, typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.getDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeID);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return PostgreUtils.getDefaultDataTypeName(dataKind);
    }

    @Association
    public Collection<PostgreTablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.tablespaceCache.getAllObjects(monitor, this);
    }

    @Property(editable=true, updatable=true, order=4, listProvider=TablespaceListProvider.class)
    public PostgreTablespace getDefaultTablespace(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return (PostgreTablespace)PostgreUtils.getObjectById(monitor, this.tablespaceCache, this, this.tablespaceId);
    }

    public void setDefaultTablespace(PostgreTablespace tablespace) throws DBException {
        this.tablespaceId = tablespace.getObjectId();
    }

    public PostgreTablespace getTablespace(DBRProgressMonitor monitor, long tablespaceId) throws DBException {
        this.checkInstanceConnection(monitor);
        for (PostgreTablespace ts : this.tablespaceCache.getAllObjects(monitor, this)) {
            if (ts.getObjectId() != tablespaceId) continue;
            return ts;
        }
        return null;
    }

    @Association
    public Collection<PostgreSchema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Nullable
    public PostgreSchema getCatalogSchema(DBRProgressMonitor monitor) throws DBException {
        return this.getSchema(monitor, "pg_catalog");
    }

    @Nullable
    PostgreSchema getCatalogSchema() {
        return (PostgreSchema)this.schemaCache.getCachedObject("pg_catalog");
    }

    @Nullable
    PostgreSchema getActiveSchema() {
        return this.getDefaultContext().getDefaultSchema();
    }

    @Nullable
    PostgreSchema getPublicSchema() {
        return (PostgreSchema)this.schemaCache.getCachedObject("public");
    }

    void cacheDataTypes(DBRProgressMonitor monitor, boolean forceRefresh) throws DBException {
        if (this.dataTypeCache.isEmpty() || forceRefresh) {
            this.dataTypeCache.clear();
            for (PostgreSchema pgSchema : this.getSchemas(monitor)) {
                if (!"pg_catalog".equals(pgSchema.getName())) continue;
                pgSchema.getDataTypes(monitor);
            }
        }
    }

    public PostgreSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        this.checkInstanceConnection(monitor);
        return (PostgreSchema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    public PostgreSchema getSchema(DBRProgressMonitor monitor, long oid) throws DBException {
        this.checkInstanceConnection(monitor);
        for (PostgreSchema schema : this.schemaCache.getAllObjects(monitor, (DBSObject)this)) {
            if (schema.getObjectId() != oid) continue;
            return schema;
        }
        return null;
    }

    PostgreTableBase findTable(DBRProgressMonitor monitor, long schemaId, long tableId) throws DBException {
        PostgreSchema schema = this.getSchema(monitor, schemaId);
        if (schema == null) {
            log.error((Object)("Catalog " + schemaId + " not found"));
            return null;
        }
        return schema.getTable(monitor, tableId);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getSchema(monitor, childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return PostgreSchema.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (this == this.dataSource.getDefaultInstance()) {
            return DBSObjectState.NORMAL;
        }
        return PostgreConstants.STATE_UNAVAILABLE;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.oid == 0L) {
            this.readDatabaseInfo(monitor);
            return this;
        }
        PostgreDatabase refDatabase = (PostgreDatabase)this.getDataSource().getDatabaseCache().refreshObject(monitor, (DBSObject)this.getDataSource(), this);
        if (refDatabase != null && refDatabase == this.dataSource.getDefaultInstance()) {
            refDatabase.cacheDataTypes(monitor, true);
        }
        return refDatabase;
    }

    public Collection<PostgreRole> getUsers(DBRProgressMonitor monitor) throws DBException {
        if (!this.getDataSource().getServerType().supportsRoles()) {
            return Collections.emptyList();
        }
        this.checkInstanceConnection(monitor);
        return this.roleCache.getAllObjects(monitor, this);
    }

    public PostgreProcedure getProcedure(DBRProgressMonitor monitor, long schemaId, long procId) throws DBException {
        PostgreSchema schema = this.getSchema(monitor, schemaId);
        if (schema != null) {
            return (PostgreProcedure)PostgreUtils.getObjectById(monitor, schema.getProceduresCache(), schema, procId);
        }
        return null;
    }

    public PostgreProcedure getProcedure(DBRProgressMonitor monitor, long procId) throws DBException {
        for (PostgreSchema schema : this.getSchemas(monitor)) {
            PostgreProcedure procedure = (PostgreProcedure)PostgreUtils.getObjectById(monitor, schema.getProceduresCache(), schema, procId);
            if (procedure == null) continue;
            return procedure;
        }
        return null;
    }

    public PostgreDataType getDataType(DBRProgressMonitor monitor, long typeId) {
        if (typeId <= 0L) {
            return null;
        }
        PostgreDataType dataType = (PostgreDataType)this.dataTypeCache.get(typeId);
        if (dataType != null) {
            return dataType;
        }
        for (PostgreSchema schema : this.schemaCache.getCachedObjects()) {
            dataType = schema.dataTypeCache.getDataType(typeId);
            if (dataType == null) continue;
            this.dataTypeCache.put(typeId, (Object)dataType);
            return dataType;
        }
        try {
            dataType = PostgreDataTypeCache.resolveDataType(monitor, this, typeId);
            ((PostgreSchema)dataType.getParentObject()).dataTypeCache.cacheObject(dataType);
            return dataType;
        }
        catch (Exception e) {
            log.debug((Object)("Can't resolve data type " + typeId), (Throwable)e);
            return null;
        }
    }

    public PostgreDataType getDataType(@Nullable DBRProgressMonitor monitor, String typeName) {
        PostgreDataType dataType;
        PostgreSchema schema;
        if (typeName.endsWith("[]")) {
            typeName = "_" + typeName.substring(0, typeName.length() - 2);
        }
        if ((schema = this.getCatalogSchema()) != null && (dataType = (PostgreDataType)schema.dataTypeCache.getCachedObject(typeName)) != null) {
            return dataType;
        }
        List<String> searchPath = this.getDefaultContext().getSearchPath();
        for (String schemaName : searchPath) {
            PostgreDataType dataType2;
            PostgreSchema schema2 = (PostgreSchema)this.schemaCache.getCachedObject(schemaName);
            if (schema2 == null || (dataType2 = (PostgreDataType)schema2.dataTypeCache.getCachedObject(typeName)) == null) continue;
            return dataType2;
        }
        for (PostgreSchema schema3 : this.schemaCache.getCachedObjects()) {
            PostgreDataType dataType3;
            if (searchPath.contains(schema3.getName()) || (dataType3 = (PostgreDataType)schema3.dataTypeCache.getCachedObject(typeName)) == null) continue;
            return dataType3;
        }
        if (monitor == null) {
            return null;
        }
        try {
            dataType = PostgreDataTypeCache.resolveDataType(monitor, this, typeName);
            ((PostgreSchema)dataType.getParentObject()).dataTypeCache.cacheObject(dataType);
            return dataType;
        }
        catch (Exception exception) {
            log.debug((Object)("Can't resolve data type '" + typeName + "' in database '" + this.getName() + "'"));
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    class AccessMethodCache
    extends JDBCObjectCache<PostgreDatabase, PostgreAccessMethod> {
        AccessMethodCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT am.oid,am.* FROM pg_catalog.pg_am am \nORDER BY am.oid");
        }

        protected PostgreAccessMethod fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreAccessMethod(owner, (ResultSet)dbResult);
        }
    }

    class AvailableExtensionCache
    extends JDBCObjectCache<PostgreDatabase, PostgreAvailableExtension> {
        AvailableExtensionCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT name,default_version,installed_version,comment FROM pg_catalog.pg_available_extensions ORDER BY name");
        }

        protected PostgreAvailableExtension fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreAvailableExtension(owner, (ResultSet)dbResult);
        }
    }

    public static class CharsetListProvider
    implements IPropertyValueListProvider<PostgreDatabase> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(PostgreDatabase object) {
            try {
                Collection<PostgreCharset> tablespaces = object.getEncodings((DBRProgressMonitor)new VoidProgressMonitor());
                return tablespaces.toArray(new Object[0]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }

    class CollationCache
    extends JDBCObjectCache<PostgreDatabase, PostgreCollation> {
        CollationCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT c.oid,c.* FROM pg_catalog.pg_collation c \nORDER BY c.oid");
        }

        protected PostgreCollation fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreCollation(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }

    class EncodingCache
    extends JDBCObjectCache<PostgreDatabase, PostgreCharset> {
        EncodingCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT c.contoencoding as encid,pg_catalog.pg_encoding_to_char(c.contoencoding) as encname\nFROM pg_catalog.pg_conversion c\nGROUP BY c.contoencoding\nORDER BY 2\n");
        }

        protected PostgreCharset fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreCharset(owner, (ResultSet)dbResult);
        }
    }

    class ExtensionCache
    extends JDBCObjectCache<PostgreDatabase, PostgreExtension> {
        ExtensionCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT \n e.oid,\n a.rolname oname,\n cfg.tbls,\n  n.nspname as schema_name,\n e.* \nFROM \n pg_catalog.pg_extension e \n join pg_authid a on a.oid = e.extowner\n join pg_namespace n on n.oid =e.extnamespace\n left join  (\n         select\n            ARRAY_AGG(ns.nspname || '.' ||  cls.relname) tbls, oid_ext\n          from\n            (\n            select\n                unnest(e1.extconfig) oid , e1.oid oid_ext\n            from\n                pg_catalog.pg_extension e1 ) c \n                join    pg_class cls on cls.oid = c.oid \n                join pg_namespace ns on ns.oid = cls.relnamespace\n            group by oid_ext        \n         ) cfg on cfg.oid_ext = e.oid\nORDER BY e.oid");
        }

        protected PostgreExtension fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreExtension(owner, (ResultSet)dbResult);
        }
    }

    class ForeignDataWrapperCache
    extends JDBCObjectCache<PostgreDatabase, PostgreForeignDataWrapper> {
        ForeignDataWrapperCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.*,p.pronamespace as handler_schema_id \nFROM pg_catalog.pg_foreign_data_wrapper l\nLEFT OUTER JOIN pg_catalog.pg_proc p ON p.oid=l.fdwhandler \nORDER BY l.fdwname");
        }

        protected PostgreForeignDataWrapper fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreForeignDataWrapper(owner, (ResultSet)dbResult);
        }
    }

    class ForeignServerCache
    extends JDBCObjectCache<PostgreDatabase, PostgreForeignServer> {
        ForeignServerCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.* FROM pg_catalog.pg_foreign_server l\nORDER BY l.srvname");
        }

        protected PostgreForeignServer fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreForeignServer(owner, (ResultSet)dbResult);
        }
    }

    class LanguageCache
    extends JDBCObjectCache<PostgreDatabase, PostgreLanguage> {
        LanguageCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.* FROM pg_catalog.pg_language l \nORDER BY l.oid");
        }

        protected PostgreLanguage fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreLanguage(owner, (ResultSet)dbResult);
        }
    }

    class RoleCache
    extends JDBCObjectCache<PostgreDatabase, PostgreRole> {
        RoleCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT a.oid,a.* FROM pg_catalog.pg_roles a \nORDER BY a.oid");
        }

        protected PostgreRole fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreRole(owner, (ResultSet)dbResult);
        }

        protected boolean handleCacheReadError(Exception error) {
            if (error instanceof DBException && "42501".equals(((DBException)((Object)error)).getDatabaseState())) {
                log.warn((Object)error);
                this.setCache(Collections.emptyList());
                return true;
            }
            return false;
        }
    }

    public static class RoleListProvider
    implements IPropertyValueListProvider<PostgreDatabase> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(PostgreDatabase object) {
            try {
                Collection<PostgreRole> roles = object.getAuthIds((DBRProgressMonitor)new VoidProgressMonitor());
                return roles.toArray(new Object[0]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }

    public static class SchemaCache
    extends JDBCObjectLookupCache<PostgreDatabase, PostgreSchema> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable PostgreSchema object, @Nullable String objectName) throws SQLException {
            StringBuilder catalogQuery = new StringBuilder("SELECT n.oid,n.*,d.description FROM pg_catalog.pg_namespace n\nLEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=n.oid AND d.objsubid=0 AND d.classoid='pg_namespace'::regclass\n");
            DBSObjectFilter catalogFilters = database.getDataSource().getContainer().getObjectFilter(PostgreSchema.class, null, false);
            if (catalogFilters != null && !catalogFilters.isNotApplicable() || object != null || objectName != null) {
                if (object != null || objectName != null) {
                    catalogFilters = new DBSObjectFilter();
                    catalogFilters.addInclude(object != null ? object.getName() : objectName);
                } else {
                    catalogFilters = new DBSObjectFilter(catalogFilters);
                    catalogFilters.addInclude("pg_catalog");
                }
                JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"nspname", (boolean)true);
            }
            catalogQuery.append(" ORDER BY nspname");
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            if (catalogFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
            }
            return dbStat;
        }

        protected PostgreSchema fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"nspname");
            if (name == null) {
                return null;
            }
            if (PostgreSchema.isUtilitySchema(name) && !owner.getDataSource().getContainer().isShowUtilityObjects()) {
                return null;
            }
            return new PostgreSchema(owner, name, (ResultSet)resultSet);
        }
    }

    class TablespaceCache
    extends JDBCObjectCache<PostgreDatabase, PostgreTablespace> {
        TablespaceCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT t.oid,t.*" + (owner.getDataSource().getServerType().supportsTeblespaceLocation() ? ",pg_tablespace_location(t.oid) loc" : "") + "\nFROM pg_catalog.pg_tablespace t " + "\nORDER BY t.oid");
        }

        protected PostgreTablespace fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreTablespace(owner, (ResultSet)dbResult);
        }
    }

    public static class TablespaceListProvider
    implements IPropertyValueListProvider<PostgreDatabase> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(PostgreDatabase object) {
            try {
                Collection<PostgreTablespace> tablespaces = object.getTablespaces((DBRProgressMonitor)new VoidProgressMonitor());
                return tablespaces.toArray(new Object[0]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }
}

