/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreServerHome;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCURL;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.WindowsRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class PostgreDataSourceProvider
extends JDBCDataSourceProvider
implements DBPNativeClientLocationManager {
    private static Map<String, String> connectionsProps = new HashMap<String, String>();
    private static Map<String, PostgreServerHome> localServers;

    static {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (preferenceStore != null) {
            PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)preferenceStore, (String)"postgresql.dd.plain.string", (Object)false);
            PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)preferenceStore, (String)"postgresql.dd.tag.string", (Object)false);
        }
        localServers = null;
    }

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    public long getFeatures() {
        return 3L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        PostgreServerType serverType = PostgreUtils.getServerType(driver);
        if (serverType.supportsCustomConnectionURL()) {
            return JDBCURL.generateUrlByTemplate((DBPDriver)driver, (DBPConnectionConfiguration)connectionInfo);
        }
        StringBuilder url = new StringBuilder();
        url.append("jdbc:postgresql://");
        url.append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append(connectionInfo.getDatabaseName());
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new PostgreDataSource(monitor, container);
    }

    public List<DBPNativeClientLocation> findLocalClientLocations() {
        PostgreDataSourceProvider.findLocalClients();
        return new ArrayList<PostgreServerHome>(localServers.values());
    }

    public DBPNativeClientLocation getDefaultLocalClientLocation() {
        PostgreDataSourceProvider.findLocalClients();
        return localServers.isEmpty() ? null : (DBPNativeClientLocation)localServers.values().iterator().next();
    }

    public String getProductName(DBPNativeClientLocation location) throws DBException {
        if (location instanceof PostgreServerHome) {
            return ((PostgreServerHome)location).getProductName();
        }
        return "PostgreSQL";
    }

    public String getProductVersion(DBPNativeClientLocation location) throws DBException {
        return PostgreDataSourceProvider.getFullServerVersion(location.getPath());
    }

    public static PostgreServerHome getServerHome(String homeId) {
        PostgreDataSourceProvider.findLocalClients();
        PostgreServerHome home = localServers.get(homeId);
        return home == null ? new PostgreServerHome(homeId, homeId, null, null, null) : home;
    }

    public static synchronized void findLocalClients() {
        if (localServers != null) {
            return;
        }
        localServers = new LinkedHashMap<String, PostgreServerHome>();
        OSDescriptor localSystem = DBWorkbench.getPlatform().getLocalSystem();
        if (localSystem.isWindows()) {
            try {
                List homeKeys = WindowsRegistry.getInstance().readStringSubKeys((long)WindowsRegistry.HKEY_LOCAL_MACHINE, "SOFTWARE\\PostgreSQL\\Installations");
                if (homeKeys != null) {
                    block2: for (String homeKey : homeKeys) {
                        Map valuesMap = WindowsRegistry.getInstance().readStringValues((long)WindowsRegistry.HKEY_LOCAL_MACHINE, "SOFTWARE\\PostgreSQL\\Installations\\" + homeKey);
                        if (valuesMap == null) continue;
                        for (String key : valuesMap.keySet()) {
                            if (!"Base Directory".equalsIgnoreCase(key)) continue;
                            String baseDir = CommonUtils.removeTrailingSlash((String)((String)valuesMap.get("Base Directory")));
                            String version = (String)valuesMap.get("Version");
                            String branding = (String)valuesMap.get("Branding");
                            String dataDir = (String)valuesMap.get("Data Directory");
                            localServers.put(homeKey, new PostgreServerHome(homeKey, baseDir, version, branding, dataDir));
                            continue block2;
                        }
                    }
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Error reading Windows registry", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getFullServerVersion(File path) {
        File binPath = path;
        File binSubfolder = new File(binPath, "bin");
        if (binSubfolder.exists()) {
            binPath = binSubfolder;
        }
        String cmd = new File(binPath, RuntimeUtils.getNativeBinaryName((String)"psql")).getAbsolutePath();
        try {
            Process p = Runtime.getRuntime().exec(new String[]{cmd, "--version"});
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line = input.readLine();
                    if (line != null) {
                        String string = line;
                        return string;
                    }
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error reading PostgreSQL native client version from " + cmd), (Throwable)ex);
        }
        return null;
    }
}

